/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.fetcher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.conf.ProfileFetcher;
import org.apache.inlong.agent.conf.TriggerProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.db.CommandDb;
import org.apache.inlong.agent.plugin.Trigger;
import org.apache.inlong.agent.plugin.fetcher.ManagerResultFormatter;
import org.apache.inlong.agent.plugin.utils.PluginUtils;
import org.apache.inlong.agent.pojo.ConfirmAgentIpRequest;
import org.apache.inlong.agent.pojo.DbCollectorTaskRequestDto;
import org.apache.inlong.agent.pojo.DbCollectorTaskResult;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.HttpManager;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.db.CommandEntity;
import org.apache.inlong.common.enums.ManagerOpEnum;
import org.apache.inlong.common.enums.PullJobTypeEnum;
import org.apache.inlong.common.pojo.agent.CmdConfig;
import org.apache.inlong.common.pojo.agent.TaskRequest;
import org.apache.inlong.common.pojo.agent.TaskResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerFetcher
extends AbstractDaemon
implements ProfileFetcher {
    public static final String AGENT = "agent";
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerFetcher.class);
    private static final GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Gson GSON = gsonBuilder.create();
    private static final int MAX_RETRY = 2;
    private final String managerVipUrl;
    private final String baseManagerUrl;
    private final String managerTaskUrl;
    private final String managerIpsCheckUrl;
    private final String managerDbCollectorTaskUrl;
    private final AgentConfiguration conf;
    private final String uniqId;
    private final AgentManager agentManager;
    private final HttpManager httpManager;
    private String localIp;
    private String uuid;
    private String clusterName;
    private CommandDb commandDb;

    public ManagerFetcher(AgentManager agentManager) {
        this.agentManager = agentManager;
        this.conf = AgentConfiguration.getAgentConf();
        if (!this.requiredKeys(this.conf)) {
            throw new RuntimeException("init manager error, cannot find required key");
        }
        this.httpManager = new HttpManager(this.conf);
        this.baseManagerUrl = this.buildBaseUrl();
        this.managerVipUrl = this.buildVipUrl(this.baseManagerUrl);
        this.managerTaskUrl = this.buildFileCollectTaskUrl(this.baseManagerUrl);
        this.managerIpsCheckUrl = this.buildIpCheckUrl(this.baseManagerUrl);
        this.managerDbCollectorTaskUrl = this.buildDbCollectorGetTaskUrl(this.baseManagerUrl);
        this.uniqId = this.conf.get("agent.uniq.id", AgentConstants.DEFAULT_AGENT_UNIQ_ID);
        this.clusterName = this.conf.get("agent.cluster.name");
        this.commandDb = agentManager.getCommandDb();
    }

    private boolean requiredKeys(AgentConfiguration conf) {
        return conf.hasKey("agent.manager.vip.http.host") && conf.hasKey("agent.manager.vip.http.port");
    }

    private String buildBaseUrl() {
        return "http://" + this.conf.get("agent.manager.vip.http.host") + ":" + this.conf.get("agent.manager.vip.http.port") + this.conf.get("agent.manager.vip.http.prefix.path", "/inlong/manager/openapi");
    }

    private String buildVipUrl(String baseUrl) {
        return baseUrl + this.conf.get("agent.manager.vip.http.managerIp.path", "/agent/getManagerIpList");
    }

    private String buildFileCollectTaskUrl(String baseUrl) {
        return baseUrl + this.conf.get("agent.manager.task.http.path", "/agent/reportAndGetTask");
    }

    private String buildIpCheckUrl(String baseUrl) {
        return baseUrl + this.conf.get("agent.manager.vip.http.checkIP.path", "/fileAgent/confirmAgentIp");
    }

    private String buildDbCollectorGetTaskUrl(String baseUrl) {
        return baseUrl + this.conf.get("agent.manager.dbcollect.gettask.http.path", "/dbCollector/getTask");
    }

    public List<JobProfile> getJobProfiles() {
        this.getTriggerProfiles();
        return null;
    }

    public List<String> requestTdmList() {
        JsonObject result = ManagerResultFormatter.getResultData(this.httpManager.doSendPost(this.managerVipUrl));
        JsonArray data = result.get("data").getAsJsonArray();
        ArrayList<String> managerIpList = new ArrayList<String>();
        for (JsonElement datum : data) {
            JsonObject asJsonObject = datum.getAsJsonObject();
            managerIpList.add(asJsonObject.get("ip").getAsString());
        }
        return managerIpList;
    }

    public void fetchCommand() {
        LOGGER.info("fetchCommand start");
        List unackedCommands = this.commandDb.getUnackedCommands();
        String resultStr = this.httpManager.doSentPost(this.managerTaskUrl, (Object)this.getFetchRequest(unackedCommands));
        JsonObject resultData = ManagerResultFormatter.getResultData(resultStr);
        JsonElement element = resultData.get("data");
        if (element != null) {
            LOGGER.info("fetchCommand not null {}", (Object)resultData);
            this.dealWithFetchResult((TaskResult)GSON.fromJson((JsonElement)element.getAsJsonObject(), TaskResult.class));
        } else {
            LOGGER.info("fetchCommand nothing to do");
        }
        this.ackCommands(unackedCommands);
        LOGGER.info("fetchCommand end");
    }

    private void ackCommands(List<CommandEntity> unackedCommands) {
        for (CommandEntity command : unackedCommands) {
            command.setAcked(true);
            this.commandDb.storeCommand(command);
        }
    }

    public void fetchDbCollectTask() {
        if (this.agentManager.getJobManager().sqlJobExist()) {
            return;
        }
        JsonObject resultData = ManagerResultFormatter.getResultData(this.httpManager.doSentPost(this.managerDbCollectorTaskUrl, (Object)this.getSqlTaskRequest()));
        this.dealWithSqlTaskResult((DbCollectorTaskResult)GSON.fromJson((JsonElement)resultData.get("data").getAsJsonObject(), DbCollectorTaskResult.class));
    }

    private void dealWithSqlTaskResult(DbCollectorTaskResult taskResult) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("deal with sql task result {}", (Object)taskResult);
        }
        if (!taskResult.getVersion().equals("1.0")) {
            LOGGER.error("invalid version {} != {}", (Object)taskResult.getVersion(), (Object)"1.0");
            return;
        }
        JobProfile profile = taskResult.getJobProfile();
        if (profile == null) {
            return;
        }
        this.agentManager.getJobManager().submitJobProfile(profile, true, true);
    }

    private void dealWithFetchResult(TaskResult taskResult) {
        if (!taskResult.getCmdConfigs().isEmpty() || !taskResult.getDataConfigs().isEmpty()) {
            LOGGER.info("deal with fetch result {}", (Object)taskResult);
        }
        taskResult.getDataConfigs().stream().map(TriggerProfile::getTriggerProfiles).forEach(profile -> {
            LOGGER.info("the triggerProfile: {}", (Object)profile.toJsonStr());
            if (profile.hasKey("job.fileJob.trigger")) {
                this.dealWithTdmTriggerProfile((TriggerProfile)profile);
            } else {
                this.dealWithJobProfile((TriggerProfile)profile);
            }
        });
        taskResult.getCmdConfigs().forEach(this::dealWithTdmCmd);
    }

    public TaskRequest getFetchRequest(List<CommandEntity> unackedCommands) {
        TaskRequest request = new TaskRequest();
        request.setAgentIp(this.localIp);
        request.setUuid(this.uuid);
        request.setClusterName(this.clusterName);
        if (this.agentManager.getJobManager().isJobOverLimit()) {
            request.setPullJobType(PullJobTypeEnum.NEVER.getType());
        } else {
            request.setPullJobType(PullJobTypeEnum.NEW.getType());
        }
        request.setCommandInfo(unackedCommands);
        return request;
    }

    public DbCollectorTaskRequestDto getSqlTaskRequest() {
        DbCollectorTaskRequestDto request = new DbCollectorTaskRequestDto();
        request.setVersion("1.0");
        request.setMd5("123456");
        return request;
    }

    public CommandDb getCommandDb() {
        return this.commandDb;
    }

    public void dealWithTdmCmd(CmdConfig cmdConfig) {
        Trigger trigger = this.agentManager.getTriggerManager().getTrigger(cmdConfig.getTaskId().toString());
        if (trigger == null) {
            LOGGER.error("trigger {} doesn't exist, cmd is {}", (Object)cmdConfig.getTaskId(), (Object)cmdConfig);
            this.commandDb.saveSpecialCmds(cmdConfig.getId(), cmdConfig.getTaskId(), false);
            return;
        }
        TriggerProfile copiedProfile = TriggerProfile.parseJsonStr((String)trigger.getTriggerProfile().toJsonStr());
        String dataTime = cmdConfig.getDataTime();
        copiedProfile.set("job.retryTime", dataTime);
        boolean cmdResult = this.executeCmd(copiedProfile, ManagerOpEnum.getOpType((int)cmdConfig.getOp()), dataTime);
        this.commandDb.saveSpecialCmds(cmdConfig.getId(), cmdConfig.getTaskId(), cmdResult);
    }

    private boolean executeCmd(TriggerProfile triggerProfile, ManagerOpEnum opType, String dataTime) {
        switch (opType) {
            case RETRY: 
            case BACKTRACK: {
                return this.agentManager.getJobManager().submitFileJobProfile((JobProfile)triggerProfile);
            }
            case MAKEUP: {
                return this.makeUpFiles(triggerProfile, dataTime);
            }
            case CHECK: {
                return !PluginUtils.findSuitFiles((JobProfile)triggerProfile).isEmpty();
            }
        }
        LOGGER.error("do not support such opType {}", (Object)opType);
        return false;
    }

    private boolean makeUpFiles(TriggerProfile triggerProfile, String dataTime) {
        LOGGER.info("start to make up files with trigger {}, dataTime {}", (Object)triggerProfile, (Object)dataTime);
        Collection<File> suitFiles = PluginUtils.findSuitFiles((JobProfile)triggerProfile);
        List pendingFiles = suitFiles.stream().filter(file -> !this.agentManager.getJobManager().checkJobExist(file.getAbsolutePath())).collect(Collectors.toList());
        for (File pendingFile : pendingFiles) {
            JobProfile copiedProfile = PluginUtils.copyJobProfile(triggerProfile, pendingFile);
            LOGGER.info("ready to make up file with job {}", (Object)copiedProfile.toJsonStr());
            this.agentManager.getJobManager().submitFileJobProfile(copiedProfile);
        }
        return true;
    }

    public void dealWithTdmTriggerProfile(TriggerProfile triggerProfile) {
        ManagerOpEnum opType = ManagerOpEnum.getOpType((int)triggerProfile.getInt("job.op"));
        boolean success = true;
        try {
            switch (Objects.requireNonNull(opType)) {
                case ACTIVE: {
                    this.agentManager.getTriggerManager().submitTrigger(triggerProfile, false);
                    break;
                }
                case ADD: {
                    this.agentManager.getTriggerManager().submitTrigger(triggerProfile, true);
                    break;
                }
                case DEL: {
                    this.agentManager.getTriggerManager().deleteTrigger(triggerProfile.getTriggerId(), false);
                    break;
                }
                case FROZEN: {
                    this.agentManager.getTriggerManager().deleteTrigger(triggerProfile.getTriggerId(), true);
                    break;
                }
                default: {
                    LOGGER.error("can not handle option type {}", (Object)opType);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Deal with trigger profile err.", (Throwable)e);
            success = false;
        }
        this.commandDb.saveNormalCmds(triggerProfile, success);
    }

    public void dealWithJobProfile(TriggerProfile triggerProfile) {
        ManagerOpEnum opType = ManagerOpEnum.getOpType((int)triggerProfile.getInt("job.op"));
        boolean success = true;
        try {
            switch (Objects.requireNonNull(opType)) {
                case ACTIVE: {
                    success = this.agentManager.getJobManager().submitJobProfile((JobProfile)triggerProfile, true, false);
                    break;
                }
                case ADD: {
                    success = this.agentManager.getJobManager().submitJobProfile((JobProfile)triggerProfile, true, true);
                    break;
                }
                case DEL: {
                    success = this.agentManager.getJobManager().deleteJob(triggerProfile.getTriggerId(), false);
                    break;
                }
                case FROZEN: {
                    success = this.agentManager.getJobManager().deleteJob(triggerProfile.getTriggerId(), true);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Deal with job profile err.", (Throwable)e);
            success = false;
        }
        this.commandDb.saveNormalCmds(triggerProfile, success);
    }

    private String confirmLocalIps(List<String> localIps) {
        ConfirmAgentIpRequest request = new ConfirmAgentIpRequest(AGENT, localIps);
        JsonObject resultData = ManagerResultFormatter.getResultData(this.httpManager.doSentPost(this.managerIpsCheckUrl, (Object)request)).get("data").getAsJsonObject();
        if (!resultData.has("ip")) {
            throw new IllegalArgumentException("cannot get ip from data " + resultData.getAsString());
        }
        return resultData.get("ip").getAsString();
    }

    private Runnable profileFetchThread() {
        return () -> {
            Thread.currentThread().setName("ManagerFetcher");
            while (this.isRunnable()) {
                try {
                    int configSleepTime = this.conf.getInt("agent.fetcher.interval", 10);
                    TimeUnit.SECONDS.sleep(AgentUtils.getRandomBySeed((int)configSleepTime));
                    this.fetchCommand();
                    this.fetchDbCollectTask();
                }
                catch (Throwable ex) {
                    LOGGER.warn("exception caught", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
            }
        };
    }

    public List<TriggerProfile> getTriggerProfiles() {
        return null;
    }

    public void start() throws Exception {
        this.localIp = AgentUtils.fetchLocalIp();
        this.uuid = AgentUtils.fetchLocalUuid();
        this.submitWorker(this.profileFetchThread());
    }

    public void stop() {
        this.waitForTerminate();
    }
}

