/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.network.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProxyUtils.class);
    private static final int TIME_LENGTH = 13;
    private static final Set<String> invalidAttr = new HashSet<String>();

    public static boolean isAttrKeysValid(Map<String, String> attrsMap) {
        if (attrsMap == null || attrsMap.size() == 0) {
            return false;
        }
        for (String key : attrsMap.keySet()) {
            if (!invalidAttr.contains(key)) continue;
            logger.error("the attributes is invalid ,please check ! {}", (Object)key);
            return false;
        }
        return true;
    }

    public static boolean isDtValid(long dt) {
        if (String.valueOf(dt).length() != 13) {
            logger.error("dt {} is error", (Object)dt);
            return false;
        }
        return true;
    }

    public static boolean isBodyValid(byte[] body) {
        if (body == null || body.length == 0) {
            logger.error("body is error {}", (Object)body);
            return false;
        }
        return true;
    }

    public static boolean isBodyValid(List<byte[]> bodyList) {
        if (bodyList == null || bodyList.size() == 0) {
            logger.error("body  is error");
            return false;
        }
        return true;
    }

    public static long covertZeroDt(long dt) {
        if (dt == 0L) {
            return System.currentTimeMillis();
        }
        return dt;
    }

    public static void validClientConfig(ProxyClientConfig clientConfig) {
        if (clientConfig.isNeedAuthentication()) {
            if (Utils.isBlank(clientConfig.getUserName())) {
                throw new IllegalArgumentException("Authentication require userName not Blank!");
            }
            if (Utils.isBlank(clientConfig.getSecretKey())) {
                throw new IllegalArgumentException("Authentication require secretKey not Blank!");
            }
        }
        if (!clientConfig.isLocalVisit()) {
            if (!clientConfig.isNeedAuthentication()) {
                throw new IllegalArgumentException("OutNetwork visit isNeedAuthentication must be true!");
            }
            if (Utils.isBlank(clientConfig.getUserName())) {
                throw new IllegalArgumentException("Authentication require userName not Blank!");
            }
            if (Utils.isBlank(clientConfig.getSecretKey())) {
                throw new IllegalArgumentException("Authentication require secretKey not Blank!");
            }
            if (!clientConfig.isNeedVerServer()) {
                throw new IllegalArgumentException("OutNetwork visit need https, please set https parameters!");
            }
            if (Utils.isBlank(clientConfig.getTlsServerCertFilePathAndName())) {
                throw new IllegalArgumentException("OutNetwork visit need https, TlsServerCertFilePathAndName is Blank!");
            }
            if (Utils.isBlank(clientConfig.getTlsServerKey())) {
                throw new IllegalArgumentException("OutNetwork visit need https, tlsServerKey is Blank!");
            }
        }
    }

    static {
        Collections.addAll(invalidAttr, "groupId", "streamId", "dt", "msgUUID", "cp", "cnt", "mt", "m", "sid", "t", "NodeIP", "messageId", "_file_status_check", "_secretId", "_signature", "_timeStamp", "_nonce", "_userName", "_clientIP", "_encyVersion", "_encyAesKey", "proxySend", "errMsg", "errCode", "rtms");
    }
}

