/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.threads;

import io.netty.channel.Channel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.sdk.dataproxy.FileCallback;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.SendResult;
import org.apache.inlong.sdk.dataproxy.network.ClientMgr;
import org.apache.inlong.sdk.dataproxy.network.QueueObject;
import org.apache.inlong.sdk.dataproxy.network.TimeScanObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutScanThread
extends Thread {
    private static final int MAX_CHANNEL_TIMEOUT = 300000;
    private final Logger logger = LoggerFactory.getLogger(TimeoutScanThread.class);
    private final ConcurrentHashMap<Channel, ConcurrentHashMap<String, QueueObject>> callbacks;
    private final AtomicInteger currentBufferSize;
    private final ProxyClientConfig config;
    private final ClientMgr clientMgr;
    private final ConcurrentHashMap<Channel, TimeScanObject> timeoutChannelStat = new ConcurrentHashMap();
    private volatile boolean bShutDown = false;
    private long printCount = 0L;

    public TimeoutScanThread(ConcurrentHashMap<Channel, ConcurrentHashMap<String, QueueObject>> callbacks, AtomicInteger currentBufferSize, ProxyClientConfig config, ClientMgr clientMgr) {
        this.callbacks = callbacks;
        this.currentBufferSize = currentBufferSize;
        this.config = config;
        this.clientMgr = clientMgr;
        this.setDaemon(true);
        this.setName("TimeoutScanThread");
    }

    public void shutDown() {
        this.logger.info("begin to shut down TimeoutScanThread!");
        this.bShutDown = true;
    }

    public void addTimeoutChannel(Channel channel) {
        if (channel != null) {
            TimeScanObject tmpTimeObj;
            TimeScanObject timeScanObject = this.timeoutChannelStat.get(channel);
            if (timeScanObject == null && (timeScanObject = this.timeoutChannelStat.putIfAbsent(channel, tmpTimeObj = new TimeScanObject())) == null) {
                timeScanObject = tmpTimeObj;
            }
            timeScanObject.incrementAndGet();
        }
    }

    public void resetTimeoutChannel(Channel channel) {
        TimeScanObject timeScanObject;
        if (channel != null && (timeScanObject = this.timeoutChannelStat.get(channel)) != null) {
            timeScanObject.updateCountToZero();
        }
    }

    private void checkTimeoutChannel() {
        for (Channel tmpChannel : this.timeoutChannelStat.keySet()) {
            TimeScanObject timeScanObject = tmpChannel != null ? this.timeoutChannelStat.get(tmpChannel) : null;
            if (timeScanObject == null) continue;
            if (System.currentTimeMillis() - timeScanObject.getTime() > 300000L) {
                this.timeoutChannelStat.remove(tmpChannel);
                continue;
            }
            if (timeScanObject.getCurTimeoutCount() <= this.config.getMaxTimeoutCnt()) continue;
            this.timeoutChannelStat.remove(tmpChannel);
            if (!tmpChannel.isOpen() || !tmpChannel.isActive()) continue;
            this.clientMgr.setConnectionBusy(tmpChannel);
            this.logger.error("this client {} is busy!", (Object)tmpChannel);
        }
    }

    private void checkMessageIdBasedCallbacks(Channel channel, ConcurrentHashMap<String, QueueObject> messageIdCallbacks) {
        for (String messageId : messageIdCallbacks.keySet()) {
            QueueObject queueObject = messageId != null ? messageIdCallbacks.get(messageId) : null;
            if (queueObject == null || System.currentTimeMillis() - queueObject.getSendTimeInMillis() < queueObject.getTimeoutInMillis()) continue;
            QueueObject queueObject1 = messageIdCallbacks.remove(messageId);
            if (queueObject1 != null) {
                if (this.config.isFile()) {
                    ((FileCallback)queueObject1.getCallback()).onMessageAck(SendResult.TIMEOUT.toString());
                    this.currentBufferSize.addAndGet(-queueObject1.getSize());
                } else {
                    queueObject1.getCallback().onMessageAck(SendResult.TIMEOUT);
                    this.currentBufferSize.decrementAndGet();
                }
            }
            this.addTimeoutChannel(channel);
        }
    }

    @Override
    public void run() {
        this.logger.info("TimeoutScanThread Thread=" + Thread.currentThread().getId() + " started !");
        while (!this.bShutDown) {
            try {
                for (Channel channel : this.callbacks.keySet()) {
                    ConcurrentHashMap<String, QueueObject> msgQueueMap;
                    ConcurrentHashMap<String, QueueObject> concurrentHashMap = msgQueueMap = channel != null ? this.callbacks.get(channel) : null;
                    if (msgQueueMap == null) continue;
                    this.checkMessageIdBasedCallbacks(channel, msgQueueMap);
                }
                this.checkTimeoutChannel();
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (Throwable e) {
                if (!this.bShutDown) {
                    this.logger.error("TimeoutScanThread exception {}", (Object)e.getMessage());
                }
                this.logger.warn("TimeoutScanThread exception {}", (Object)e.getMessage());
            }
            if (this.printCount++ % 20L != 0L) continue;
            this.logger.info("TimeoutScanThread thread=" + Thread.currentThread().getId() + "'s currentBufferSize = " + this.currentBufferSize.get());
        }
        this.logger.info("TimeoutScanThread Thread=" + Thread.currentThread().getId() + " existed !");
    }
}

