/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.network;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.sdk.dataproxy.pb.network.ByteArrayToBinaryEncoder;
import org.apache.inlong.sdk.dataproxy.pb.network.IpPort;
import org.apache.inlong.sdk.dataproxy.pb.network.TcpChannel;
import org.apache.inlong.sdk.dataproxy.pb.network.TcpResult;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpChannelGroup {
    public static final Logger LOG = LoggerFactory.getLogger(TcpChannelGroup.class);
    private String bid;
    private int senderThreadNum;
    private ClientBootstrap client = new ClientBootstrap();
    private Set<IpPort> currentIpLists = new HashSet<IpPort>();
    private List<LinkedBlockingQueue<TcpChannel>> channelQueues = new ArrayList<LinkedBlockingQueue<TcpChannel>>();
    private List<List<TcpChannel>> channelLists = new ArrayList<List<TcpChannel>>();
    private int mIndex = 0;
    private ConcurrentHashMap<Object, TcpChannel> channelMap = new ConcurrentHashMap();
    private AtomicLong channelId = new AtomicLong(0L);

    public TcpChannelGroup(String bid, int senderThreadNum, ChannelUpstreamHandler decoder, SimpleChannelHandler clientHandler) {
        this.bid = bid;
        this.senderThreadNum = senderThreadNum;
        LOG.info("TcpChannelGroup netty thread pool size is " + senderThreadNum);
        this.client.setFactory((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool(), this.senderThreadNum));
        this.client.setPipelineFactory(() -> {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)decoder);
            pipeline.addLast("encoder", (ChannelHandler)new ByteArrayToBinaryEncoder());
            pipeline.addLast("handler", (ChannelHandler)clientHandler);
            return pipeline;
        });
        this.client.setOption("tcpNoDelay", (Object)false);
        this.client.setOption("child.tcpNoDelay", (Object)false);
        this.client.setOption("keepAlive", (Object)true);
        this.client.setOption("child.keepAlive", (Object)true);
        this.client.setOption("reuseAddr", (Object)false);
        this.channelQueues.add(new LinkedBlockingQueue());
        this.channelQueues.add(new LinkedBlockingQueue());
        this.channelLists.add(new ArrayList());
        this.channelLists.add(new ArrayList());
    }

    public void updateConfig(Set<IpPort> ipList) {
        boolean hasIpChange = !this.currentIpLists.equals(ipList);
        LOG.info("TcpChannelGroup updateConfig bid:{},hasIpChange:{},currentIpLists:{},ipLists:{}", new Object[]{this.bid, hasIpChange, this.currentIpLists, ipList});
        int oldIndex = this.mIndex ^ 1;
        this.channelQueues.get(oldIndex).clear();
        for (TcpChannel tcpChannel : this.channelLists.get(oldIndex)) {
            LOG.info(String.format("TcpChannelGroup updateConfig bid:%s,disconnect and close:%s", this.bid, tcpChannel));
            this.channelMap.remove(tcpChannel.getChannel().getAttachment());
            tcpChannel.close();
        }
        this.channelLists.get(oldIndex).clear();
        if (!hasIpChange) {
            for (Map.Entry entry : this.channelMap.entrySet()) {
                LOG.info("TcpChannelGroup channel status index:{},isConnected:{},isHasException:{},isReconnectFail:{},availablePermits:{}", new Object[]{((TcpChannel)entry.getValue()).getChannel().getAttachment(), ((TcpChannel)entry.getValue()).getChannel().isConnected(), ((TcpChannel)entry.getValue()).isHasException(), ((TcpChannel)entry.getValue()).isReconnectFail(), ((TcpChannel)entry.getValue()).getPackToken().availablePermits()});
                ((TcpChannel)entry.getValue()).setHasException(false);
                ((TcpChannel)entry.getValue()).setReconnectFail(false);
            }
            return;
        }
        int newIndex = this.mIndex ^ 1;
        LinkedBlockingQueue<TcpChannel> linkedBlockingQueue = this.channelQueues.get(newIndex);
        List<TcpChannel> newChannelList = this.channelLists.get(newIndex);
        for (IpPort ipPortObj : ipList) {
            try {
                ChannelFuture future = this.client.connect((SocketAddress)ipPortObj.addr).await();
                Channel channel = future.getChannel();
                Long newChannelId = this.channelId.getAndIncrement();
                channel.setAttachment((Object)newChannelId);
                TcpChannel tcpChannel = new TcpChannel(channel, ipPortObj);
                linkedBlockingQueue.add(tcpChannel);
                newChannelList.add(tcpChannel);
                this.channelMap.put(newChannelId, tcpChannel);
            }
            catch (Throwable ex) {
                LOG.error(String.format("bid:%s,ipPort:%s,connect failed:%s", this.bid, ipPortObj, ex.getMessage()), ex);
            }
        }
        this.currentIpLists = ipList;
        this.mIndex = newIndex;
    }

    public TcpResult send(ChannelBuffer dataBuf) {
        LinkedBlockingQueue<TcpChannel> channelQueue = this.channelQueues.get(this.mIndex);
        TcpChannel tcpChannel = this.getTcpChannel(channelQueue);
        try {
            if (tcpChannel == null) {
                return new TcpResult("", 0, false, "can not acquire a channel");
            }
            tcpChannel.acquireUninterruptibly();
            ChannelFuture t = tcpChannel.getChannel().write((Object)dataBuf).sync().await();
            if (!t.isSuccess()) {
                tcpChannel.setHasException(true);
                channelQueue.offer(tcpChannel);
                String errorMessage = t.getCause() != null ? t.getCause().getMessage() : "write fail";
                LOG.error(String.format("bid:%s,write failed:%s", this.bid, errorMessage), t.getCause());
                return new TcpResult(tcpChannel.getIpPort(), false, errorMessage);
            }
            channelQueue.offer(tcpChannel);
            TcpResult result = new TcpResult(tcpChannel.getIpPort(), true, "");
            result.channelId = (Long)tcpChannel.getChannel().getAttachment();
            return result;
        }
        catch (Throwable ex) {
            LOG.error(String.format("bid:%s,netty send failed:%s", this.bid, ex.getMessage()), ex);
            if (tcpChannel != null) {
                channelQueue.offer(tcpChannel);
            }
            return new TcpResult("", 0, false, ex.getMessage());
        }
    }

    private TcpChannel getTcpChannel(LinkedBlockingQueue<TcpChannel> channelQueue) {
        TcpChannel tcpChannel = null;
        try {
            for (int i = 0; i < channelQueue.size(); ++i) {
                tcpChannel = channelQueue.take();
                if (tcpChannel.isReconnectFail()) {
                    channelQueue.offer(tcpChannel);
                    tcpChannel = null;
                    continue;
                }
                if (!tcpChannel.getChannel().isConnected() || tcpChannel.isHasException()) {
                    this.reconnect(tcpChannel);
                }
                if (tcpChannel.getChannel().isConnected()) {
                    tcpChannel.setHasException(false);
                    break;
                }
                LOG.info("reconnect fail,channel:{}", (Object)tcpChannel);
                tcpChannel.setReconnectFail(true);
                tcpChannel = null;
            }
            return tcpChannel;
        }
        catch (Throwable ex) {
            LOG.error(String.format("bid:%s,get channel error:%s", this.bid, ex.getMessage()), ex);
            if (tcpChannel != null) {
                channelQueue.offer(tcpChannel);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(TcpChannel tcpChannel) {
        try {
            TcpChannel tcpChannel2 = tcpChannel;
            synchronized (tcpChannel2) {
                Channel oldChannel = tcpChannel.getChannel();
                if (oldChannel != null && oldChannel.isOpen()) {
                    return;
                }
                LOG.info("reconnect channel:{}", (Object)tcpChannel);
                ChannelFuture future = this.client.connect((SocketAddress)tcpChannel.getIpPort().addr).await();
                Channel newChannel = future.getChannel();
                tcpChannel.setChannel(newChannel);
                newChannel.setAttachment(oldChannel.getAttachment());
                if (oldChannel != null) {
                    oldChannel.disconnect();
                    oldChannel.close();
                }
            }
        }
        catch (Throwable ex) {
            LOG.error("reconnect failed:" + ex.getMessage(), ex);
        }
    }

    public String getBid() {
        return this.bid;
    }

    public void close() {
        for (LinkedBlockingQueue<TcpChannel> linkedBlockingQueue : this.channelQueues) {
            linkedBlockingQueue.clear();
        }
        this.channelQueues.clear();
        for (List list : this.channelLists) {
            for (TcpChannel tcpChannel : list) {
                LOG.info("TcpChannelGroup close bid:{},disconnect and close:{}", (Object)this.bid, (Object)tcpChannel);
                tcpChannel.close();
            }
        }
        this.channelMap.clear();
    }

    public void exceptionChannel(Channel channel) {
        TcpChannel tcpChannel = this.channelMap.get(channel.getAttachment());
        if (tcpChannel != null) {
            tcpChannel.setHasException(true);
        }
    }

    public void releaseChannel(Channel channel) {
        TcpChannel tcpChannel = this.channelMap.get(channel.getAttachment());
        if (tcpChannel != null) {
            tcpChannel.release();
        }
    }
}

