/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.network;

import java.util.concurrent.Semaphore;
import org.apache.inlong.sdk.dataproxy.pb.network.IpPort;
import org.apache.inlong.sdk.dataproxy.pb.network.TcpChannelGroup;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpChannel {
    public static final Logger LOG = LoggerFactory.getLogger(TcpChannelGroup.class);
    private IpPort ipPort;
    private Channel channel;
    private boolean hasException = false;
    private boolean reconnectFail = false;
    private Semaphore packToken;

    public TcpChannel(Channel channel, IpPort ipPort) {
        this.channel = channel;
        this.ipPort = ipPort;
        this.packToken = new Semaphore(1, true);
    }

    public String toString() {
        return this.ipPort.key;
    }

    public IpPort getIpPort() {
        return this.ipPort;
    }

    public void setIpPort(IpPort ipPort) {
        this.ipPort = ipPort;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public boolean isHasException() {
        return this.hasException;
    }

    public void setHasException(boolean hasException) {
        this.hasException = hasException;
    }

    public boolean isReconnectFail() {
        return this.reconnectFail;
    }

    public void setReconnectFail(boolean reconnectFail) {
        this.reconnectFail = reconnectFail;
    }

    public void close() {
        try {
            if (this.channel != null && this.channel.isConnected()) {
                this.channel.disconnect();
                this.channel.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean tryAcquire() {
        return this.packToken.tryAcquire();
    }

    public void acquireUninterruptibly() {
        this.packToken.acquireUninterruptibly();
    }

    public void release() {
        this.packToken.release();
    }

    public Semaphore getPackToken() {
        return this.packToken;
    }
}

