/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.dispatch;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.sdk.dataproxy.pb.context.ProfileEvent;

public class DispatchProfile {
    private final String inlongGroupId;
    private final String inlongStreamId;
    private final String uid;
    private List<ProfileEvent> events = new ArrayList<ProfileEvent>();
    private long createTime = System.currentTimeMillis();
    private long count = 0L;
    private long size = 0L;
    private long dispatchTime;
    private long sendTime;

    public DispatchProfile(String uid, String inlongGroupId, String inlongStreamId, long dispatchTime) {
        this.uid = uid;
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        this.dispatchTime = dispatchTime;
    }

    public boolean addEvent(ProfileEvent event, long maxPackCount, long maxPackSize) {
        long eventLength = event.getBody().length;
        if (this.count >= maxPackCount || this.count > 0L && this.size + eventLength > maxPackSize) {
            return false;
        }
        this.events.add(event);
        ++this.count;
        this.size += eventLength;
        return true;
    }

    public boolean isTimeout(long createThreshold) {
        return createThreshold >= this.createTime;
    }

    public String getUid() {
        return this.uid;
    }

    public List<ProfileEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<ProfileEvent> events) {
        this.events = events;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public long getDispatchTime() {
        return this.dispatchTime;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(long sendTime) {
        this.sendTime = sendTime;
    }
}

