/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.context;

import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.apache.inlong.sdk.dataproxy.pb.metrics.SdkMetricItem;
import org.apache.inlong.sdk.dataproxy.pb.metrics.SdkMetricItemSet;
import org.apache.inlong.sdk.dataproxy.utils.IpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkContext {
    public static final Logger LOG = LoggerFactory.getLogger(SinkContext.class);
    public static final String KEY_NODE_ID = "nodeId";
    public static final String KEY_MAX_THREADS = "maxThreads";
    public static final String KEY_PROCESSINTERVAL = "processInterval";
    public static final String KEY_RELOADINTERVAL = "reloadInterval";
    public static final String KEY_AUDITFORMATINTERVAL = "auditFormatInterval";
    protected final String nodeId;
    protected final String nodeIp;
    protected final Context context;
    protected final Channel channel;
    protected final int maxThreads;
    protected final long processInterval;
    protected final long reloadInterval;
    protected long auditFormatInterval = 60000L;
    protected final SdkMetricItemSet metricItemSet;
    protected Timer reloadTimer;

    public SinkContext(Context context, Channel channel) {
        this.nodeId = context.getString(KEY_NODE_ID, IpUtils.getLocalAddress());
        this.nodeIp = IpUtils.getLocalAddress();
        this.context = context;
        this.channel = channel;
        this.maxThreads = context.getInteger(KEY_MAX_THREADS, Integer.valueOf(10));
        this.processInterval = context.getInteger(KEY_PROCESSINTERVAL, Integer.valueOf(100)).intValue();
        this.reloadInterval = context.getLong(KEY_RELOADINTERVAL, Long.valueOf(60000L));
        this.auditFormatInterval = context.getLong(KEY_AUDITFORMATINTERVAL, Long.valueOf(60000L));
        this.metricItemSet = new SdkMetricItemSet(this.nodeId);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
    }

    public void start() {
        try {
            this.reload();
            this.setReloadTimer();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void close() {
        try {
            this.reloadTimer.cancel();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void setReloadTimer() {
        this.reloadTimer = new Timer(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    SinkContext.this.reload();
                }
                catch (Throwable e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        };
        this.reloadTimer.schedule(task, new Date(System.currentTimeMillis() + this.reloadInterval), this.reloadInterval);
    }

    public void reload() {
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Context getContext() {
        return this.context;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public long getProcessInterval() {
        return this.processInterval;
    }

    public long getReloadInterval() {
        return this.reloadInterval;
    }

    public void fillAuditFormatTime(Event event, Map<String, String> dimensions) {
        long msgTime = SdkMetricItem.getLogTime(event);
        long auditFormatTime = msgTime - msgTime % this.auditFormatInterval;
        dimensions.put("msgTime", String.valueOf(auditFormatTime));
    }

    public long getAuditFormatTime(long msgTime) {
        long auditFormatTime = msgTime - msgTime % this.auditFormatInterval;
        return auditFormatTime;
    }

    public SdkMetricItemSet getMetricItemSet() {
        return this.metricItemSet;
    }
}

