/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.apache.inlong.sdk.dataproxy.pb.config.ProxyClusterConfigHolder;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyClusterConfig;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyClusterResult;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyNodeInfo;
import org.apache.inlong.sdk.dataproxy.pb.context.SinkContext;
import org.apache.inlong.sdk.dataproxy.pb.dispatch.DispatchProfile;
import org.apache.inlong.sdk.dataproxy.pb.metrics.SdkMetricItem;
import org.apache.inlong.sdk.dataproxy.pb.network.IpPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkSinkContext
extends SinkContext {
    public static final Logger LOG = LoggerFactory.getLogger(SdkSinkContext.class);
    public static final String KEY_SDK_PACK_TIMEOUT = "sdkPackTimeout";
    public static final String KEY_COMPRESSED_TYPE = "compressedType";
    public static final int DEFAULT_COMPRESSED_TYPE = ProxySdk.INLONG_COMPRESSED_TYPE.INLONG_SNAPPY.getNumber();
    public static final int MAX_RESPONSE_LENGTH = 32768;
    public static final short PACK_VERSION = 1;
    public static final int PACK_VERSION_LENGTH = 2;
    private Map<String, ProxyClusterResult> proxyClusterMap;
    private Map<String, Set<IpPort>> proxyIpListMap = new ConcurrentHashMap<String, Set<IpPort>>();
    private final long sdkPackTimeout;
    private final long maxPackCount;
    private final long maxPackSize;
    private final ProxySdk.INLONG_COMPRESSED_TYPE compressedType;

    public SdkSinkContext(Context context, Channel channel) {
        super(context, channel);
        this.sdkPackTimeout = context.getLong(KEY_SDK_PACK_TIMEOUT, Long.valueOf(60000L));
        this.maxPackCount = context.getLong("dispatchMaxPackCount", Long.valueOf(256L));
        this.maxPackSize = context.getLong("dispatchMaxPackSize", Long.valueOf(327680L));
        this.compressedType = ProxySdk.INLONG_COMPRESSED_TYPE.valueOf((int)context.getInteger(KEY_COMPRESSED_TYPE, Integer.valueOf(DEFAULT_COMPRESSED_TYPE)));
        ProxyClusterConfigHolder.start(context);
    }

    @Override
    public void reload() {
        try {
            Map<String, ProxyClusterResult> newProxyClusterMap = ProxyClusterConfigHolder.getProxyClusterMap();
            if (this.proxyClusterMap != null && this.proxyClusterMap.equals(newProxyClusterMap)) {
                return;
            }
            ConcurrentHashMap<String, Set<IpPort>> newProxyIpListMap = new ConcurrentHashMap<String, Set<IpPort>>();
            for (Map.Entry<String, ProxyClusterResult> entry : newProxyClusterMap.entrySet()) {
                ProxyClusterConfig config = entry.getValue().getConfig();
                String proxyClusterId = config.getClusterId();
                HashSet<IpPort> ipPortSet = new HashSet<IpPort>();
                for (ProxyNodeInfo nodeInfo : config.getNodeList()) {
                    IpPort ipPort = new IpPort(nodeInfo.getNodeIp(), nodeInfo.getNodePort());
                    ipPortSet.add(ipPort);
                }
                newProxyIpListMap.put(proxyClusterId, ipPortSet);
            }
            this.proxyClusterMap = newProxyClusterMap;
            this.proxyIpListMap = newProxyIpListMap;
            super.reload();
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public static void fillInlongId(DispatchProfile currentRecord, Map<String, String> dimensions) {
        String inlongGroupId = currentRecord.getInlongGroupId();
        inlongGroupId = StringUtils.isBlank((CharSequence)inlongGroupId) ? "-" : inlongGroupId;
        String inlongStreamId = currentRecord.getInlongStreamId();
        inlongStreamId = StringUtils.isBlank((CharSequence)inlongStreamId) ? "-" : inlongStreamId;
        dimensions.put("inlongGroupId", inlongGroupId);
        dimensions.put("inlongStreamId", inlongStreamId);
    }

    public void addSendResultMetric(DispatchProfile currentRecord, String proxyClusterId, boolean result, long sendTime) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("nodeId", this.nodeId);
        dimensions.put("nodeIp", this.nodeIp);
        SdkSinkContext.fillInlongId(currentRecord, dimensions);
        dimensions.put("sinkId", proxyClusterId);
        long msgTime = currentRecord.getDispatchTime();
        long auditFormatTime = msgTime - msgTime % this.auditFormatInterval;
        dimensions.put("msgTime", String.valueOf(auditFormatTime));
        SdkMetricItem metricItem = (SdkMetricItem)this.getMetricItemSet().findMetricItem(dimensions);
        long count = currentRecord.getCount();
        long size = currentRecord.getSize();
        if (result) {
            metricItem.sendSuccessCount.addAndGet(count);
            metricItem.sendSuccessSize.addAndGet(size);
            if (sendTime > 0L) {
                long currentTime = System.currentTimeMillis();
                long sinkDuration = currentTime - sendTime;
                long nodeDuration = currentTime - NumberUtils.toLong((String)"sourceTime", (long)msgTime);
                long wholeDuration = currentTime - msgTime;
                metricItem.sinkDuration.addAndGet(sinkDuration * count);
                metricItem.nodeDuration.addAndGet(nodeDuration * count);
                metricItem.wholeDuration.addAndGet(wholeDuration * count);
            }
        } else {
            metricItem.sendFailCount.addAndGet(count);
            metricItem.sendFailSize.addAndGet(size);
        }
    }

    public void addSendMetric(DispatchProfile currentRecord, String proxyClusterId) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("nodeId", this.nodeId);
        dimensions.put("nodeIp", this.nodeIp);
        SdkSinkContext.fillInlongId(currentRecord, dimensions);
        dimensions.put("sinkId", proxyClusterId);
        long msgTime = currentRecord.getDispatchTime();
        long auditFormatTime = msgTime - msgTime % this.auditFormatInterval;
        dimensions.put("msgTime", String.valueOf(auditFormatTime));
        SdkMetricItem metricItem = (SdkMetricItem)this.getMetricItemSet().findMetricItem(dimensions);
        long count = currentRecord.getCount();
        long size = currentRecord.getSize();
        metricItem.sendCount.addAndGet(count);
        metricItem.sendSize.addAndGet(size);
    }

    public void addSendFailMetric() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("nodeId", this.nodeId);
        dimensions.put("nodeIp", this.nodeIp);
        long msgTime = System.currentTimeMillis();
        long auditFormatTime = msgTime - msgTime % this.auditFormatInterval;
        dimensions.put("msgTime", String.valueOf(auditFormatTime));
        SdkMetricItem metricItem = (SdkMetricItem)this.getMetricItemSet().findMetricItem(dimensions);
        metricItem.readFailCount.incrementAndGet();
    }

    public Map<String, Set<IpPort>> getProxyIpListMap() {
        return this.proxyIpListMap;
    }

    public long getSdkPackTimeout() {
        return this.sdkPackTimeout;
    }

    public long getMaxPackCount() {
        return this.maxPackCount;
    }

    public long getMaxPackSize() {
        return this.maxPackSize;
    }

    public String getProxyClusterId(String uid) {
        ProxyClusterResult result = ProxyClusterConfigHolder.getInlongStreamMap().get(uid);
        if (result != null) {
            return result.getClusterId();
        }
        return null;
    }

    public ProxySdk.INLONG_COMPRESSED_TYPE getCompressedType() {
        return this.compressedType;
    }
}

