/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.config;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Context;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.sdk.dataproxy.pb.config.ProxyClusterConfigLoader;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.GetProxyConfigBySdkRequest;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.GetProxyConfigBySdkResponse;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.GetProxyConfigByStreamResponse;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyClusterConfig;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyClusterResult;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerProxyClusterConfigLoader
implements ProxyClusterConfigLoader {
    private static Logger LOG = LoggerFactory.getLogger(ManagerProxyClusterConfigLoader.class);
    private Context context;
    private CloseableHttpClient httpClient;

    private static synchronized CloseableHttpClient constructHttpClient() {
        long timeoutInMs = TimeUnit.MILLISECONDS.toMillis(50000L);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)timeoutInMs).setSocketTimeout((int)timeoutInMs).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        return httpClientBuilder.build();
    }

    public void configure(Context context) {
        this.context = context;
        this.httpClient = ManagerProxyClusterConfigLoader.constructHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyClusterResult loadByStream(String inlongGroupId, String inlongStreamId) {
        HttpGet httpGet = null;
        try {
            String url = this.context.getString("config.loaderType.managerStreamUrl") + "?inlongGroupId=" + inlongGroupId + "&inlongStreamId=" + inlongStreamId;
            LOG.info("start to ProxyClusterConfigLoader request {} to get config info", (Object)url);
            httpGet = new HttpGet(url);
            httpGet.addHeader("Connection", "close");
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            String jsonString = EntityUtils.toString((HttpEntity)response.getEntity());
            LOG.info("end to ProxyClusterConfigLoader request {},result:{}", (Object)url, (Object)jsonString);
            GetProxyConfigByStreamResponse configResponse = (GetProxyConfigByStreamResponse)JSON.parseObject((String)jsonString, GetProxyConfigByStreamResponse.class);
            if (!configResponse.isResult()) {
                LOG.info("Fail to get config info from url:{}, error code is {}", (Object)url, (Object)configResponse.getErrCode());
                ProxyClusterResult proxyClusterResult = null;
                return proxyClusterResult;
            }
            ProxyClusterConfig config = configResponse.getData();
            ProxyClusterResult result = new ProxyClusterResult();
            result.setClusterId(config.getClusterId());
            result.setHasUpdated(true);
            result.setMd5(configResponse.getMd5());
            result.setConfig(config);
            ProxyClusterResult proxyClusterResult = result;
            return proxyClusterResult;
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            ProxyClusterResult proxyClusterResult = null;
            return proxyClusterResult;
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ProxyClusterResult> loadByClusterIds(List<ProxyInfo> proxys) {
        HttpPost httpPost = null;
        try {
            String url = this.context.getString("config.loaderType.managerSdkUrl");
            LOG.info("start to ProxyClusterConfigLoader request {} to get config info", (Object)url);
            httpPost = new HttpPost(url);
            httpPost.addHeader("Connection", "close");
            httpPost.setHeader("Content-Type", "application/json");
            GetProxyConfigBySdkRequest request = new GetProxyConfigBySdkRequest();
            request.setProxys(proxys);
            String requestJson = JSON.toJSONString((Object)request);
            httpPost.setEntity((HttpEntity)new StringEntity(requestJson));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            String jsonString = EntityUtils.toString((HttpEntity)response.getEntity());
            LOG.info("end to ProxyClusterConfigLoader request {},body:{},result:{}", new Object[]{url, requestJson, jsonString});
            GetProxyConfigBySdkResponse configResponse = (GetProxyConfigBySdkResponse)JSON.parseObject((String)jsonString, GetProxyConfigBySdkResponse.class);
            if (!configResponse.isResult()) {
                LOG.info("Fail to get config info from url:{}, error code is {}", (Object)url, (Object)configResponse.getErrCode());
                Map<String, ProxyClusterResult> map = null;
                return map;
            }
            Map<String, ProxyClusterResult> map = configResponse.getData();
            return map;
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            Map<String, ProxyClusterResult> map = null;
            return map;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
    }
}

