/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.config;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.Context;
import org.apache.inlong.sdk.dataproxy.pb.config.ProxyClusterConfigLoader;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.GetProxyConfigBySdkResponse;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.InlongStreamConfig;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyClusterResult;
import org.apache.inlong.sdk.dataproxy.pb.config.pojo.ProxyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextProxyClusterConfigLoader
implements ProxyClusterConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ContextProxyClusterConfigLoader.class);
    private Context context;

    public void configure(Context context) {
        this.context = context;
    }

    @Override
    public ProxyClusterResult loadByStream(String inlongGroupId, String inlongStreamId) {
        try {
            String jsonString = this.context.getString("config.loaderType.contextKey");
            LOG.info("get data proxy cluster from inlong group and stream result: {}", (Object)jsonString);
            GetProxyConfigBySdkResponse configResponse = (GetProxyConfigBySdkResponse)JSON.parseObject((String)jsonString, GetProxyConfigBySdkResponse.class);
            for (Map.Entry<String, ProxyClusterResult> entry : configResponse.getData().entrySet()) {
                for (InlongStreamConfig stream : entry.getValue().getConfig().getInlongStreamList()) {
                    if (!StringUtils.equals((String)inlongGroupId, (String)stream.getInlongGroupId()) || !StringUtils.equals((String)inlongStreamId, (String)stream.getInlongStreamId())) continue;
                    return entry.getValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("get data proxy cluster from inlong group and stream failed: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, ProxyClusterResult> loadByClusterIds(List<ProxyInfo> proxyInfos) {
        try {
            String jsonString = this.context.getString("config.loaderType.contextKey");
            LOG.info("get data proxy cluster from cluster result: {}", (Object)jsonString);
            GetProxyConfigBySdkResponse configResponse = (GetProxyConfigBySdkResponse)JSON.parseObject((String)jsonString, GetProxyConfigBySdkResponse.class);
            return configResponse.getData();
        }
        catch (Exception e) {
            LOG.error("get data proxy cluster from cluster failed: ", (Throwable)e);
            return null;
        }
    }
}

