/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.channel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.Transaction;
import org.apache.inlong.sdk.commons.protocol.SdkEvent;
import org.apache.inlong.sdk.dataproxy.pb.channel.BufferQueue;
import org.apache.inlong.sdk.dataproxy.pb.context.CallbackProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileTransaction
implements Transaction {
    public static final Logger LOG = LoggerFactory.getLogger(ProfileTransaction.class);
    private BufferQueue<CallbackProfile> bufferQueue;
    private List<CallbackProfile> takeList = new ArrayList<CallbackProfile>();
    private AtomicLong takeCounter = new AtomicLong(0L);
    private List<CallbackProfile> putList = new ArrayList<CallbackProfile>();

    public ProfileTransaction(BufferQueue<CallbackProfile> bufferQueue) {
        this.bufferQueue = bufferQueue;
    }

    public void begin() {
    }

    public void commit() {
        for (CallbackProfile profile : this.takeList) {
            SdkEvent event = profile.getEvent();
            this.bufferQueue.release(event.getBody().length);
        }
        this.takeList.clear();
        for (CallbackProfile event : this.putList) {
            this.bufferQueue.offer(event);
        }
        this.putList.clear();
    }

    public void rollback() {
        for (CallbackProfile event : this.takeList) {
            this.bufferQueue.offer(event);
        }
        this.takeList.clear();
        for (CallbackProfile profile : this.putList) {
            SdkEvent event = profile.getEvent();
            this.bufferQueue.release(event.getBody().length);
        }
        this.putList.clear();
    }

    public void close() {
    }

    public void doTake(CallbackProfile event) {
        this.takeList.add(event);
        this.takeCounter.incrementAndGet();
    }

    public void doPut(CallbackProfile event) {
        this.putList.add(event);
    }

    public void commitTakeEvent() {
        long current = this.takeCounter.decrementAndGet();
        if (current == 0L) {
            this.commit();
        }
    }
}

