/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb.channel;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.Transaction;
import org.apache.flume.channel.AbstractChannel;
import org.apache.inlong.sdk.commons.protocol.SdkEvent;
import org.apache.inlong.sdk.dataproxy.pb.channel.BufferQueue;
import org.apache.inlong.sdk.dataproxy.pb.channel.ProfileTransaction;
import org.apache.inlong.sdk.dataproxy.pb.channel.SizeSemaphore;
import org.apache.inlong.sdk.dataproxy.pb.context.CallbackProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferQueueChannel
extends AbstractChannel {
    public static final Logger LOG = LoggerFactory.getLogger(BufferQueueChannel.class);
    public static final String KEY_MAX_BUFFERQUEUE_SIZE_KB = "channel.maxBufferQueueSizeKb";
    public static final int DEFAULT_MAX_BUFFERQUEUE_SIZE_KB = 131072;
    private Context context;
    private static SizeSemaphore globalBufferQueueSizeKb;
    private BufferQueue<CallbackProfile> bufferQueue;
    private ThreadLocal<ProfileTransaction> currentTransaction = new ThreadLocal();
    protected Timer channelTimer;
    private AtomicLong takeCounter = new AtomicLong(0L);
    private AtomicLong putCounter = new AtomicLong(0L);

    public void put(Event event) throws ChannelException {
        this.putCounter.incrementAndGet();
        int eventSize = event.getBody().length;
        boolean tryAcquire = this.bufferQueue.tryAcquire(eventSize);
        if (!tryAcquire) {
            throw new ChannelException("The buffer is full, please create more SDK object.");
        }
        ProfileTransaction transaction = this.currentTransaction.get();
        Preconditions.checkState((transaction != null ? 1 : 0) != 0, (Object)"No transaction exists for this thread");
        if (event instanceof CallbackProfile) {
            CallbackProfile profile = (CallbackProfile)event;
            transaction.doPut(profile);
        } else {
            SdkEvent sdkEvent = new SdkEvent();
            Map headers = event.getHeaders();
            sdkEvent.setInlongGroupId((String)headers.get("inlongGroupId"));
            sdkEvent.setInlongStreamId((String)headers.get("inlongStreamId"));
            sdkEvent.setBody(event.getBody());
            sdkEvent.setHeaders(event.getHeaders());
            CallbackProfile profile = new CallbackProfile(sdkEvent, null);
            transaction.doPut(profile);
        }
    }

    public Event take() throws ChannelException {
        CallbackProfile event = this.bufferQueue.pollRecord();
        if (event != null) {
            ProfileTransaction transaction = this.currentTransaction.get();
            Preconditions.checkState((transaction != null ? 1 : 0) != 0, (Object)"No transaction exists for this thread");
            transaction.doTake(event);
            this.takeCounter.incrementAndGet();
        }
        return event;
    }

    public Transaction getTransaction() {
        ProfileTransaction newTransaction = new ProfileTransaction(this.bufferQueue);
        this.currentTransaction.set(newTransaction);
        return newTransaction;
    }

    public void start() {
        super.start();
        try {
            this.setReloadTimer();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void setReloadTimer() {
        this.channelTimer = new Timer(true);
        long reloadInterval = this.context.getLong("reloadInterval", Long.valueOf(60000L));
        TimerTask channelTask = new TimerTask(){

            @Override
            public void run() {
                LOG.info("queueSize:{},availablePermits:{},put:{},take:{}", new Object[]{BufferQueueChannel.this.bufferQueue.size(), BufferQueueChannel.this.bufferQueue.availablePermits(), BufferQueueChannel.this.putCounter.getAndSet(0L), BufferQueueChannel.this.takeCounter.getAndSet(0L)});
            }
        };
        this.channelTimer.schedule(channelTask, new Date(System.currentTimeMillis() + reloadInterval), reloadInterval);
    }

    public void configure(Context context) {
        this.context = context;
        SizeSemaphore globalSize = BufferQueueChannel.getGlobalBufferQueueSizeKb(context);
        this.bufferQueue = new BufferQueue(globalSize.maxSize() / 3, globalSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SizeSemaphore getGlobalBufferQueueSizeKb(Context context) {
        if (globalBufferQueueSizeKb != null) {
            return globalBufferQueueSizeKb;
        }
        Logger logger = LOG;
        synchronized (logger) {
            if (globalBufferQueueSizeKb != null) {
                return globalBufferQueueSizeKb;
            }
            int maxBufferQueueSizeKb = context.getInteger(KEY_MAX_BUFFERQUEUE_SIZE_KB, Integer.valueOf(131072));
            globalBufferQueueSizeKb = new SizeSemaphore(maxBufferQueueSizeKb, 1024);
            return globalBufferQueueSizeKb;
        }
    }
}

