/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.pb;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.sink.AbstractSink;
import org.apache.inlong.sdk.dataproxy.pb.SdkProxyChannelManager;
import org.apache.inlong.sdk.dataproxy.pb.context.ProfileEvent;
import org.apache.inlong.sdk.dataproxy.pb.context.SdkSinkContext;
import org.apache.inlong.sdk.dataproxy.pb.dispatch.DispatchManager;
import org.apache.inlong.sdk.dataproxy.pb.dispatch.DispatchProfile;
import org.jboss.netty.channel.ChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySdkSink
extends AbstractSink
implements Configurable {
    public static final Logger LOG = LoggerFactory.getLogger(ProxySdkSink.class);
    private Context parentContext;
    private SdkSinkContext context;
    private DispatchManager dispatchManager;
    private LinkedBlockingQueue<DispatchProfile> dispatchQueue = new LinkedBlockingQueue();
    protected Timer sinkTimer;
    protected Timer processTimer;
    private final ConcurrentHashMap<String, SdkProxyChannelManager> proxyManagers = new ConcurrentHashMap();
    private final List<SdkProxyChannelManager> deletingProxyManager = new ArrayList<SdkProxyChannelManager>();

    public void start() {
        try {
            this.context = new SdkSinkContext(this.parentContext, this.getChannel());
            if (this.getChannel() == null) {
                LOG.error("channel is null");
            }
            this.context.start();
            this.dispatchManager = new DispatchManager(this.parentContext, this.dispatchQueue);
            this.reload();
            this.setReloadTimer();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        super.start();
    }

    protected void setReloadTimer() {
        this.sinkTimer = new Timer(true);
        TimerTask reloadTask = new TimerTask(){

            @Override
            public void run() {
                ProxySdkSink.this.reload();
            }
        };
        this.sinkTimer.schedule(reloadTask, new Date(System.currentTimeMillis() + this.context.getReloadInterval()), this.context.getReloadInterval());
        TimerTask dispatchTimeoutTask = new TimerTask(){

            @Override
            public void run() {
                ProxySdkSink.this.dispatchManager.setNeedOutputOvertimeData();
            }
        };
        this.sinkTimer.schedule(dispatchTimeoutTask, new Date(System.currentTimeMillis() + this.dispatchManager.getDispatchTimeout()), this.dispatchManager.getDispatchTimeout());
        this.processTimer = new Timer(true);
        TimerTask processTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ProxySdkSink.this.outputProxyQueue();
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        this.processTimer.schedule(processTask, new Date(System.currentTimeMillis() + this.context.getProcessInterval()), this.context.getProcessInterval());
    }

    public void reload() {
        try {
            LOG.info("All proxy managers start status,proxy size:{},proxys:{},metricItemSize:{}", new Object[]{this.proxyManagers.size(), this.proxyManagers.keySet(), this.context.getMetricItemSet().getItemMap().size()});
            for (SdkProxyChannelManager sdkProxyChannelManager : this.deletingProxyManager) {
                sdkProxyChannelManager.close();
            }
            this.deletingProxyManager.clear();
            for (Map.Entry entry : this.context.getProxyIpListMap().entrySet()) {
                if (this.proxyManagers.containsKey(entry.getKey())) continue;
                SdkProxyChannelManager proxyManager = new SdkProxyChannelManager((String)entry.getKey(), this.context);
                this.proxyManagers.put((String)entry.getKey(), proxyManager);
                proxyManager.start();
            }
            HashSet<String> deletingProxys = new HashSet<String>();
            for (Map.Entry<String, SdkProxyChannelManager> entry : this.proxyManagers.entrySet()) {
                if (this.context.getProxyIpListMap().containsKey(entry.getKey())) continue;
                deletingProxys.add(entry.getKey());
            }
            for (String proxy : deletingProxys) {
                this.deletingProxyManager.add(this.proxyManagers.remove(proxy));
            }
            LOG.info("All proxy managers end status,proxy size:{},proxys:{},metricItemSize:{}", new Object[]{this.proxyManagers.size(), this.proxyManagers.keySet(), this.context.getMetricItemSet().getItemMap().size()});
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public void stop() {
        try {
            for (Map.Entry<String, SdkProxyChannelManager> entry : this.proxyManagers.entrySet()) {
                entry.getValue().close();
            }
            this.sinkTimer.cancel();
            this.context.close();
            super.stop();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void configure(Context context) {
        LOG.info("start to configure:{}, context:{}.", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)context.toString());
        this.parentContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink.Status process() throws EventDeliveryException {
        Channel channel = this.getChannel();
        tx.begin();
        try (Transaction tx = channel.getTransaction();){
            Event event = channel.take();
            if (event == null) {
                tx.commit();
                Sink.Status status = Sink.Status.BACKOFF;
                return status;
            }
            if (!(event instanceof ProfileEvent)) {
                tx.commit();
                this.context.addSendFailMetric();
                Sink.Status status = Sink.Status.READY;
                return status;
            }
            ProfileEvent profileEvent = (ProfileEvent)event;
            this.dispatchManager.addEvent(profileEvent);
            tx.commit();
            Sink.Status status = Sink.Status.READY;
            return status;
        }
    }

    private void outputProxyQueue() {
        DispatchProfile dispatchProfile = this.dispatchQueue.poll();
        while (dispatchProfile != null) {
            String uid = dispatchProfile.getUid();
            String proxyClusterId = this.context.getProxyClusterId(uid);
            if (proxyClusterId == null) {
                LOG.error("can not find uid:{}", (Object)uid);
                this.context.addSendResultMetric(dispatchProfile, uid, false, 0L);
                ChannelException ex = new ChannelException(String.format("can not find proxyClusterId:%s", uid));
                dispatchProfile.getEvents().forEach(pEvent -> {
                    try {
                        pEvent.getProfile().getCallback().onException((Throwable)ex);
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                });
                dispatchProfile = this.dispatchQueue.poll();
                continue;
            }
            SdkProxyChannelManager proxyManager = this.proxyManagers.get(proxyClusterId);
            if (proxyManager == null) {
                LOG.error("can not find proxy:{},proxyManagers:{}", (Object)proxyClusterId, (Object)JSON.toJSONString(this.proxyManagers));
                this.context.addSendResultMetric(dispatchProfile, uid, false, 0L);
                ChannelException ex = new ChannelException(String.format("can not find proxyClusterId manager:%s", proxyClusterId));
                dispatchProfile.getEvents().forEach(pEvent -> {
                    try {
                        pEvent.getProfile().getCallback().onException((Throwable)ex);
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                });
                dispatchProfile = this.dispatchQueue.poll();
                continue;
            }
            proxyManager.offerDispatchQueue(dispatchProfile);
            dispatchProfile = this.dispatchQueue.poll();
        }
    }
}

