/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network;

import com.sun.management.OperatingSystemMXBean;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.codec.EncodeObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient {
    private static final Logger logger = LoggerFactory.getLogger(NettyClient.class);
    private Channel channel = null;
    private final ReentrantLock stateLock = new ReentrantLock();
    private ConnState connState;
    private ProxyClientConfig configure;
    private Bootstrap bootstrap;
    private String serverIP;
    private int serverPort;

    public String getServerIP() {
        return this.serverIP;
    }

    public void setServerIP(String serverIP) {
        this.serverIP = serverIP;
    }

    public NettyClient(Bootstrap bootstrap, String serverIP, int serverPort, ProxyClientConfig configure) {
        this.bootstrap = bootstrap;
        this.serverIP = serverIP;
        this.serverPort = serverPort;
        this.configure = configure;
        this.setState(ConnState.INIT);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public boolean connect() {
        this.setState(ConnState.INIT);
        final CountDownLatch awaitLatch = new CountDownLatch(1);
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.serverIP, this.serverPort));
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture arg0) throws Exception {
                logger.info("connect ack! {}", (Object)NettyClient.this.serverIP);
                awaitLatch.countDown();
            }
        });
        try {
            awaitLatch.await(this.configure.getConnectTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("create connect exception! {}", (Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        if (!future.isSuccess()) {
            return false;
        }
        this.channel = future.channel();
        this.setState(ConnState.READY);
        logger.info("ip {} stat {}", (Object)this.serverIP, (Object)this.connState);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        logger.debug("begin to close this channel{}", (Object)this.channel);
        final CountDownLatch awaitLatch = new CountDownLatch(1);
        boolean ret = true;
        try {
            if (this.channel != null) {
                ChannelFuture future = this.channel.close();
                future.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture arg0) throws Exception {
                        logger.info("close client ack {}", (Object)NettyClient.this.serverIP);
                        awaitLatch.countDown();
                    }
                });
                awaitLatch.await(this.configure.getRequestTimeoutMillis(), TimeUnit.MILLISECONDS);
                if (!future.isSuccess()) {
                    ret = false;
                }
            }
        }
        catch (Exception e) {
            logger.error("close connect {" + this.serverIP + ":" + this.serverPort + "} exception! {}", (Object)e.getMessage());
            e.printStackTrace();
            ret = false;
        }
        finally {
            this.setState(ConnState.DEAD);
        }
        logger.info("end to close {" + this.serverIP + ":" + this.serverPort + "} 's channel, bSuccess = " + ret);
        return ret;
    }

    public void reconnect() {
        this.close();
        this.connect();
    }

    public boolean isActive() {
        this.stateLock.lock();
        try {
            boolean bl = this.connState == ConnState.READY && this.channel != null && this.channel.isOpen() && this.channel.isActive();
            return bl;
        }
        catch (Exception e) {
            logger.error("channel maybe null!{}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private void setState(ConnState newState) {
        this.stateLock.lock();
        try {
            this.connState = newState;
        }
        catch (Exception e) {
            logger.error("setState maybe error!{}", (Object)e.getMessage());
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public ChannelFuture write(EncodeObject encodeObject) {
        ChannelFuture future = null;
        try {
            future = this.channel.writeAndFlush((Object)encodeObject);
        }
        catch (Exception e) {
            logger.error("channel write error {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return future;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NettyClient other = (NettyClient)obj;
        return !(this.channel == null ? other.channel != null : !this.channel.equals(other.channel));
    }

    public void setFrozen() {
        this.setState(ConnState.FROZEN);
    }

    public void setBusy() {
        this.setState(ConnState.BUSY);
    }

    public double getWeight() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        return operatingSystemMXBean.getSystemLoadAverage();
    }

    private static enum ConnState {
        INIT,
        READY,
        FROZEN,
        DEAD,
        BUSY;

    }
}

