/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.SendMessageCallback;
import org.apache.inlong.sdk.dataproxy.SendResult;
import org.apache.inlong.sdk.dataproxy.config.HostInfo;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigEntry;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigManager;
import org.apache.inlong.sdk.dataproxy.http.InternalHttpSender;
import org.apache.inlong.sdk.dataproxy.network.HttpMessage;
import org.apache.inlong.sdk.dataproxy.network.Sender;
import org.apache.inlong.sdk.dataproxy.network.Utils;
import org.apache.inlong.sdk.dataproxy.utils.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxySender
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(Sender.class);
    private final ConcurrentHashSet<HostInfo> hostList = new ConcurrentHashSet();
    private final ProxyClientConfig proxyClientConfig;
    private ProxyConfigManager proxyConfigManager;
    private boolean bShutDown = false;
    private final InternalHttpSender internalHttpSender;
    private final LinkedBlockingQueue<HttpMessage> messageCache;

    public HttpProxySender(ProxyClientConfig configure) throws Exception {
        if (!"HTTP".equals(configure.getProtocolType())) {
            configure.setProtocolType("HTTP");
        }
        logger.info("Initial http sender, configure is {}", (Object)configure);
        this.proxyClientConfig = configure;
        this.initTDMClientAndRequest(configure);
        this.messageCache = new LinkedBlockingQueue(configure.getTotalAsyncCallbackSize());
        this.internalHttpSender = new InternalHttpSender(configure, this.hostList, this.messageCache);
    }

    private void initTDMClientAndRequest(ProxyClientConfig configure) throws Exception {
        try {
            this.proxyConfigManager = new ProxyConfigManager(configure, Utils.getLocalIp(), null);
            this.proxyConfigManager.setGroupId(configure.getGroupId());
            ProxyConfigEntry proxyConfigEntry = this.retryGettingProxyConfig();
            this.hostList.addAll(proxyConfigEntry.getHostMap().values());
            this.setDaemon(true);
            this.start();
        }
        catch (Throwable e) {
            if (configure.isReadProxyIPFromLocal()) {
                throw new Exception("Get local proxy configure failure! e = {}", e);
            }
            throw new Exception("Visit TDManager error! e = {}", e);
        }
        logger.info("http proxy sender starts");
    }

    private ProxyConfigEntry retryGettingProxyConfig() throws Exception {
        return this.proxyConfigManager.getGroupIdConfigure();
    }

    @Override
    public void run() {
        while (!this.bShutDown) {
            try {
                int rand = ThreadLocalRandom.current().nextInt(0, 600);
                int randSleepTime = this.proxyClientConfig.getProxyHttpUpdateIntervalMinutes() * 60 + rand;
                TimeUnit.MILLISECONDS.sleep(randSleepTime * 1000);
                if (this.proxyConfigManager != null) {
                    ProxyConfigEntry proxyConfigEntry = this.proxyConfigManager.getGroupIdConfigure();
                    this.hostList.addAll(proxyConfigEntry.getHostMap().values());
                    this.hostList.retainAll(proxyConfigEntry.getHostMap().values());
                } else {
                    logger.error("manager is null, please check it!");
                }
                logger.info("get new proxy list " + this.hostList.toString());
            }
            catch (InterruptedException rand) {
            }
            catch (Exception ex) {
                logger.error("managerFetcher get or save managerIpList occur error,", (Throwable)ex);
            }
        }
    }

    public SendResult sendMessage(String body, String groupId, String streamId, long dt, long timeout, TimeUnit timeUnit) {
        return this.sendMessage(Collections.singletonList(body), groupId, streamId, dt, timeout, timeUnit);
    }

    public SendResult sendMessage(List<String> bodies, String groupId, String streamId, long dt, long timeout, TimeUnit timeUnit) {
        if (this.hostList.isEmpty()) {
            logger.error("proxy list is empty, maybe client has been closed or groupId is not assigned with proxy list");
            return SendResult.NO_CONNECTION;
        }
        return this.internalHttpSender.sendMessageWithHostInfo(bodies, groupId, streamId, dt, timeout, timeUnit);
    }

    public void asyncSendMessage(List<String> bodies, String groupId, String streamId, long dt, long timeout, TimeUnit timeUnit, SendMessageCallback callback) {
        ArrayList<String> bodyList = new ArrayList<String>(bodies);
        HttpMessage httpMessage = new HttpMessage(bodyList, groupId, streamId, dt, timeout, timeUnit, callback);
        try {
            if (!this.messageCache.offer(httpMessage)) {
                if (!this.proxyClientConfig.isDiscardOldMessage()) {
                    this.messageCache.put(httpMessage);
                } else {
                    logger.debug("discard old message and use new message instead");
                    HttpMessage oldMessage = this.messageCache.poll();
                    if (oldMessage != null) {
                        oldMessage.getCallback().onMessageAck(SendResult.TIMEOUT);
                    }
                    this.messageCache.offer(httpMessage);
                }
            }
        }
        catch (Exception exception) {
            logger.error("error async sending data", (Throwable)exception);
        }
    }

    public void asyncSendMessage(String body, String groupId, String streamId, long dt, long timeout, TimeUnit timeUnit, SendMessageCallback callback) {
        this.asyncSendMessage(Collections.singletonList(body), groupId, streamId, dt, timeout, timeUnit, callback);
    }

    public void close() {
        this.hostList.clear();
        this.bShutDown = true;
        try {
            this.interrupt();
            this.internalHttpSender.close();
        }
        catch (Exception exception) {
            logger.error("error while closing http client", (Throwable)exception);
        }
    }
}

