/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.inlong.sdk.dataproxy.LoadBalance;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.config.EncryptConfigEntry;
import org.apache.inlong.sdk.dataproxy.config.HostInfo;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigEntry;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigManager;
import org.apache.inlong.sdk.dataproxy.network.ClientPipelineFactory;
import org.apache.inlong.sdk.dataproxy.network.HashRing;
import org.apache.inlong.sdk.dataproxy.network.NettyClient;
import org.apache.inlong.sdk.dataproxy.network.Sender;
import org.apache.inlong.sdk.dataproxy.network.Utils;
import org.apache.inlong.sdk.dataproxy.utils.ConsistencyHashUtil;
import org.apache.inlong.sdk.dataproxy.utils.EventLoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMgr {
    private static final Logger logger = LoggerFactory.getLogger(ClientMgr.class);
    private static final int[] weight = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 6, 6, 6, 6, 6, 12, 12, 12, 12, 12, 48, 96, 192, 384, 1000};
    private final Map<HostInfo, NettyClient> clientMapData = new ConcurrentHashMap<HostInfo, NettyClient>();
    private final ConcurrentHashMap<HostInfo, NettyClient> clientMapHB = new ConcurrentHashMap();
    private final ConcurrentHashMap<HostInfo, NettyClient> clientMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<HostInfo, AtomicLong> lastBadHostMap = new ConcurrentHashMap();
    private final ArrayList<NettyClient> clientList = new ArrayList();
    private final Map<HostInfo, int[]> channelLoadMapData = new ConcurrentHashMap<HostInfo, int[]>();
    private final Map<HostInfo, int[]> channelLoadMapHB = new ConcurrentHashMap<HostInfo, int[]>();
    private final ReentrantReadWriteLock fsLock = new ReentrantReadWriteLock(true);
    private List<HostInfo> proxyInfoList = new ArrayList<HostInfo>();
    private Bootstrap bootstrap;
    private int currentIndex = 0;
    private ProxyClientConfig configure;
    private Sender sender;
    private int aliveConnections;
    private int realSize;
    private SendHBThread sendHBThread;
    private ProxyConfigManager ipManager;
    private int groupIdNum = 0;
    private String groupId = "";
    private Map<String, Integer> streamIdMap = new HashMap<String, Integer>();
    private int loadThreshold;
    private int loadCycle = 0;
    private LoadBalance loadBalance;

    public ClientMgr(ProxyClientConfig configure, Sender sender) throws Exception {
        this(configure, sender, null);
    }

    public ClientMgr(ProxyClientConfig configure, Sender sender, ThreadFactory selfDefineFactory) throws Exception {
        if (selfDefineFactory == null) {
            selfDefineFactory = new DefaultThreadFactory("agent-client-io", Thread.currentThread().isDaemon());
        }
        EventLoopGroup eventLoopGroup = EventLoopUtil.newEventLoopGroup(configure.getIoThreadNum(), configure.isEnableBusyWait(), selfDefineFactory);
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(eventLoopGroup);
        this.bootstrap.channel(EventLoopUtil.getClientSocketChannelClass(eventLoopGroup));
        this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)0x1000000);
        this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)0x1000000);
        if (configure.getNetTag().equals("bobcat")) {
            this.bootstrap.option(ChannelOption.IP_TOS, (Object)96);
        }
        this.bootstrap.handler((ChannelHandler)new ClientPipelineFactory(this, sender));
        this.ipManager = new ProxyConfigManager(configure, Utils.getLocalIp(), this);
        this.ipManager.setName("proxyConfigManager");
        if (configure.getGroupId() != null) {
            this.ipManager.setGroupId(configure.getGroupId());
            this.groupId = configure.getGroupId();
        }
        this.configure = configure;
        this.sender = sender;
        this.aliveConnections = configure.getAliveConnections();
        this.loadBalance = configure.getLoadBalance();
        try {
            this.ipManager.doProxyEntryQueryWork();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.info(e.getMessage());
        }
        this.ipManager.setDaemon(true);
        this.ipManager.start();
        this.sendHBThread = new SendHBThread();
        this.sendHBThread.setName("SendHBThread");
        this.sendHBThread.start();
    }

    public LoadBalance getLoadBalance() {
        return this.loadBalance;
    }

    public int getLoadThreshold() {
        return this.loadThreshold;
    }

    public void setLoadThreshold(int loadThreshold) {
        this.loadThreshold = loadThreshold;
    }

    public int getGroupIdNum() {
        return this.groupIdNum;
    }

    public void setGroupIdNum(int groupIdNum) {
        this.groupIdNum = groupIdNum;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Map<String, Integer> getStreamIdMap() {
        return this.streamIdMap;
    }

    public void setStreamIdMap(Map<String, Integer> streamIdMap) {
        this.streamIdMap = streamIdMap;
    }

    public EncryptConfigEntry getEncryptConfigEntry() {
        return this.ipManager.getEncryptConfigEntry(this.configure.getUserName());
    }

    public List<HostInfo> getProxyInfoList() {
        return this.proxyInfoList;
    }

    public void setProxyInfoList(List<HostInfo> proxyInfoList) {
        try {
            this.writeLock();
            this.proxyInfoList = proxyInfoList;
            if (this.loadThreshold == 0) {
                if (this.aliveConnections >= proxyInfoList.size()) {
                    this.aliveConnections = this.realSize = proxyInfoList.size();
                    logger.error("there is no enough proxy to work!");
                } else {
                    this.realSize = this.aliveConnections;
                }
            } else if (this.aliveConnections >= proxyInfoList.size()) {
                this.aliveConnections = this.realSize = proxyInfoList.size();
                logger.error("there is no idle proxy to choose for balancing!");
            } else if (this.aliveConnections + 4 > proxyInfoList.size()) {
                this.realSize = proxyInfoList.size();
                logger.warn("there is only {} idle proxy to choose for balancing!", (Object)(proxyInfoList.size() - this.aliveConnections));
            } else {
                this.realSize = this.aliveConnections + 4;
            }
            List<HostInfo> hostInfos = this.getRealHosts(proxyInfoList, this.realSize);
            this.updateAllConnection(hostInfos);
            logger.info("update all connection ,client map size {},client list size {}", (Object)this.clientMapData.size(), (Object)this.clientList.size());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    public int getAliveConnections() {
        return this.aliveConnections;
    }

    public void setAliveConnections(int aliveConnections) {
        this.aliveConnections = aliveConnections;
    }

    public void readLock() {
        this.fsLock.readLock().lock();
    }

    public void readUnlock() {
        this.fsLock.readLock().unlock();
    }

    public void writeLock() {
        this.fsLock.writeLock().lock();
    }

    public void writeLockInterruptibly() throws InterruptedException {
        this.fsLock.writeLock().lockInterruptibly();
    }

    public void writeUnlock() {
        this.fsLock.writeLock().unlock();
    }

    public boolean hasWriteLock() {
        return this.fsLock.isWriteLockedByCurrentThread();
    }

    public boolean hasReadLock() {
        return this.fsLock.getReadHoldCount() > 0;
    }

    public boolean hasReadOrWriteLock() {
        return this.hasReadLock() || this.hasWriteLock();
    }

    public ProxyConfigEntry getGroupIdConfigureInfo() throws Exception {
        return this.ipManager.getGroupIdConfigure();
    }

    private boolean initConnection(HostInfo host) {
        NettyClient client = this.clientMap.get(host);
        if (client != null && client.isActive()) {
            logger.info("this client {} has open!", (Object)host.getHostName());
            throw new IllegalStateException("The channel has already been opened");
        }
        client = new NettyClient(this.bootstrap, host.getHostName(), host.getPortNumber(), this.configure);
        boolean bSuccess = client.connect();
        if (this.clientMapData.size() < this.aliveConnections) {
            if (bSuccess) {
                this.clientMapData.put(host, client);
                this.clientList.add(client);
                this.clientMap.put(host, client);
                logger.info("build a connection success! {},channel {}", (Object)host.getHostName(), (Object)client.getChannel());
            } else {
                logger.info("build a connection fail! {}", (Object)host.getHostName());
            }
            logger.info("client map size {},client list size {}", (Object)this.clientMapData.size(), (Object)this.clientList.size());
        } else if (bSuccess) {
            this.clientMapHB.put(host, client);
            this.clientMap.put(host, client);
            logger.info("build a HBconnection success! {},channel {}", (Object)host.getHostName(), (Object)client.getChannel());
        } else {
            logger.info("build a HBconnection fail! {}", (Object)host.getHostName());
        }
        return bSuccess;
    }

    public void resetClient(Channel channel) {
        if (channel == null) {
            return;
        }
        logger.info("reset this channel {}", (Object)channel);
        for (HostInfo hostInfo : this.clientMap.keySet()) {
            NettyClient client;
            if (hostInfo == null || (client = this.clientMap.get(hostInfo)) == null || client.getChannel() == null || !client.getChannel().id().equals(channel.id())) continue;
            client.reconnect();
            break;
        }
    }

    public void setConnectionFrozen(Channel channel) {
        if (channel == null) {
            return;
        }
        logger.info("set this channel {} frozen", (Object)channel);
        for (HostInfo hostInfo : this.clientMap.keySet()) {
            NettyClient client;
            if (hostInfo == null || (client = this.clientMap.get(hostInfo)) == null || client.getChannel() == null || !client.getChannel().id().equals(channel.id())) continue;
            client.setFrozen();
            logger.info("end to froze this channel {}", (Object)client.getChannel().toString());
            break;
        }
    }

    public void setConnectionBusy(Channel channel) {
        if (channel == null) {
            return;
        }
        logger.info("set this channel {} busy", (Object)channel);
        for (HostInfo hostInfo : this.clientMap.keySet()) {
            NettyClient client;
            if (hostInfo == null || (client = this.clientMap.get(hostInfo)) == null || client.getChannel() == null || !client.getChannel().id().equals(channel.id())) continue;
            client.setBusy();
            break;
        }
    }

    public synchronized NettyClient getClientByRoundRobin() {
        NettyClient client = null;
        if (this.clientList.isEmpty()) {
            return null;
        }
        int currSize = this.clientList.size();
        for (int retryTime = 0; retryTime < currSize; ++retryTime) {
            ++this.currentIndex;
            this.currentIndex %= currSize;
            client = this.clientList.get(this.currentIndex);
            if (client != null && client.isActive()) break;
        }
        if (client == null || !client.isActive()) {
            return null;
        }
        return client;
    }

    public synchronized NettyClient getClientByRandom() {
        int randomId;
        NettyClient client;
        if (this.clientList.isEmpty()) {
            return null;
        }
        int currSize = this.clientList.size();
        int maxRetry = this.configure.getMaxRetry();
        Random random = new Random(System.currentTimeMillis());
        while (!((client = this.clientList.get((randomId = random.nextInt()) % currSize)) != null && client.isActive() || --maxRetry <= 0)) {
        }
        if (client == null || !client.isActive()) {
            return null;
        }
        return client;
    }

    public synchronized NettyClient getClientByConsistencyHash(String messageId) {
        if (this.clientList.isEmpty()) {
            return null;
        }
        String hash = ConsistencyHashUtil.hashMurMurHash(messageId);
        HashRing cluster = HashRing.getInstance();
        HostInfo info = cluster.getNode(hash);
        NettyClient client = this.clientMap.get(info);
        return client;
    }

    public synchronized NettyClient getClientByWeightRoundRobin() {
        NettyClient client = null;
        double maxWeight = Double.MIN_VALUE;
        int clientId = 0;
        if (this.clientList.isEmpty()) {
            return null;
        }
        int currSize = this.clientList.size();
        for (int retryTime = 0; retryTime < currSize; ++retryTime) {
            ++this.currentIndex;
            this.currentIndex %= currSize;
            client = this.clientList.get(this.currentIndex);
            if (client == null || !client.isActive() || !(client.getWeight() > maxWeight)) continue;
            clientId = this.currentIndex;
        }
        if (client == null || !client.isActive()) {
            return null;
        }
        return this.clientList.get(clientId);
    }

    public synchronized NettyClient getClientByWeightRandom() {
        NettyClient client;
        double maxWeight = Double.MIN_VALUE;
        int clientId = 0;
        if (this.clientList.isEmpty()) {
            return null;
        }
        int currSize = this.clientList.size();
        int maxRetry = this.configure.getMaxRetry();
        Random random = new Random(System.currentTimeMillis());
        do {
            int randomId;
            if ((client = this.clientList.get((randomId = random.nextInt()) % currSize)) == null || !client.isActive()) continue;
            clientId = randomId;
            break;
        } while (--maxRetry > 0);
        if (client == null || !client.isActive()) {
            return null;
        }
        return this.clientList.get(clientId);
    }

    public NettyClient getContainProxy(String proxyip) {
        if (proxyip == null) {
            return null;
        }
        for (NettyClient tmpClient : this.clientList) {
            if (tmpClient == null || tmpClient.getServerIP() == null || !tmpClient.getServerIP().equals(proxyip)) continue;
            return tmpClient;
        }
        return null;
    }

    public void shutDown() {
        this.bootstrap.config().group().shutdownGracefully();
        this.ipManager.shutDown();
        this.sendHBThread.shutDown();
        this.closeAllConnection();
    }

    private void closeAllConnection() {
        if (!this.clientMap.isEmpty()) {
            logger.info("ready to close all connections!");
            for (HostInfo hostInfo : this.clientMap.keySet()) {
                NettyClient client;
                if (hostInfo == null || (client = this.clientMap.get(hostInfo)) == null || !client.isActive()) continue;
                this.sender.waitForAckForChannel(client.getChannel());
                client.close();
            }
        }
        this.clientMap.clear();
        this.clientMapData.clear();
        this.clientMapHB.clear();
        this.channelLoadMapData.clear();
        this.channelLoadMapHB.clear();
        this.clientList.clear();
        this.sender.clearCallBack();
    }

    private void updateAllConnection(List<HostInfo> hostInfos) {
        this.closeAllConnection();
        for (HostInfo hostInfo : hostInfos) {
            this.initConnection(hostInfo);
        }
    }

    public void notifyHBAck(Channel channel, short loadvalue) {
        try {
            HostInfo hostInfo;
            NettyClient client;
            if (loadvalue == -1 || this.loadCycle == 0) {
                return;
            }
            for (Map.Entry<HostInfo, NettyClient> entry : this.clientMapData.entrySet()) {
                client = entry.getValue();
                hostInfo = entry.getKey();
                if (client == null || client.getChannel() == null || !client.getChannel().id().equals(channel.id())) continue;
                if (!this.channelLoadMapData.containsKey(hostInfo)) {
                    this.channelLoadMapData.put(hostInfo, new int[30]);
                }
                if (this.loadCycle - 1 >= 0) {
                    this.channelLoadMapData.get((Object)hostInfo)[this.loadCycle - 1] = loadvalue;
                    break;
                }
                return;
            }
            for (Map.Entry<HostInfo, NettyClient> entry : this.clientMapHB.entrySet()) {
                client = entry.getValue();
                hostInfo = entry.getKey();
                if (client == null || client.getChannel() == null || !client.getChannel().id().equals(channel.id())) continue;
                if (!this.channelLoadMapHB.containsKey(hostInfo)) {
                    this.channelLoadMapHB.put(hostInfo, new int[30]);
                }
                if (this.loadCycle - 1 >= 0) {
                    this.channelLoadMapHB.get((Object)hostInfo)[this.loadCycle - 1] = loadvalue;
                    break;
                }
                return;
            }
        }
        catch (Exception e) {
            logger.error("{} , {}", (Object)e.toString(), (Object)e.getStackTrace());
        }
    }

    private void loadDataInfo(Map<HostInfo, Integer> loadData) {
        for (Map.Entry<HostInfo, int[]> entry : this.channelLoadMapData.entrySet()) {
            HostInfo key = entry.getKey();
            int[] value = entry.getValue();
            int numerator = 0;
            int denominator = 0;
            for (int i = 0; i < value.length; ++i) {
                if (value[i] <= 0) continue;
                numerator += value[i] * weight[i];
                denominator += weight[i];
            }
            int sum = numerator / denominator;
            loadData.put(key, sum);
        }
    }

    private void loadHBInfo(Map<HostInfo, Integer> loadHB) {
        for (Map.Entry<HostInfo, int[]> entry : this.channelLoadMapHB.entrySet()) {
            HostInfo key = entry.getKey();
            int[] value = entry.getValue();
            int numerator = 0;
            int denominator = 0;
            for (int i = 0; i < value.length; ++i) {
                if (value[i] <= 0) continue;
                numerator += value[i] * weight[i];
                denominator += weight[i];
            }
            int sum = numerator / denominator;
            loadHB.put(key, sum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyHBControl() {
        try {
            this.writeLock();
            logger.info("check if there is need to start balancing!");
            ConcurrentHashMap<HostInfo, Integer> loadData = new ConcurrentHashMap<HostInfo, Integer>();
            ConcurrentHashMap<HostInfo, Integer> loadHB = new ConcurrentHashMap<HostInfo, Integer>();
            this.loadDataInfo(loadData);
            this.loadHBInfo(loadHB);
            ArrayList listData = new ArrayList(loadData.entrySet());
            Collections.sort(listData, new Comparator<Map.Entry<HostInfo, Integer>>(){

                @Override
                public int compare(Map.Entry<HostInfo, Integer> o1, Map.Entry<HostInfo, Integer> o2) {
                    if (o2.getValue() != null && o1.getValue() != null && o1.getValue() > o2.getValue()) {
                        return -1;
                    }
                    return 1;
                }
            });
            ArrayList listHB = new ArrayList(loadHB.entrySet());
            Collections.sort(listHB, new Comparator<Map.Entry<HostInfo, Integer>>(){

                @Override
                public int compare(Map.Entry<HostInfo, Integer> o1, Map.Entry<HostInfo, Integer> o2) {
                    if (o2.getValue() != null && o1.getValue() != null && o2.getValue() > o1.getValue()) {
                        return -1;
                    }
                    return 1;
                }
            });
            logger.info("show info: last compute result!");
            for (Map.Entry entry : listData) {
                logger.info("Client:" + entry.getKey() + ";" + entry.getValue());
            }
            for (Map.Entry entry : listHB) {
                logger.info("HBClient:" + entry.getKey() + ";" + entry.getValue());
            }
            boolean isLoadSwitch = false;
            int n = 1;
            for (int i = 0; i < n; ++i) {
                if ((Integer)((Map.Entry)listData.get(i)).getValue() - (Integer)((Map.Entry)listHB.get(i)).getValue() < this.loadThreshold) continue;
                isLoadSwitch = true;
                HostInfo dataHost = (HostInfo)((Map.Entry)listData.get(i)).getKey();
                HostInfo hbHost = (HostInfo)((Map.Entry)listHB.get(i)).getKey();
                logger.info("balancing client:" + dataHost.getHostName() + ",load: " + ((Map.Entry)listData.get(i)).getValue() + "; HBclient:" + hbHost.getHostName() + ",load: " + ((Map.Entry)listHB.get(i)).getValue());
                NettyClient client = this.clientMapData.get(dataHost);
                client.setFrozen();
                this.sender.waitForAckForChannel(client.getChannel());
                client.close();
                this.clientList.remove(this.clientMapData.get(dataHost));
                this.clientMap.remove(dataHost);
                this.clientMapData.remove(dataHost);
                this.clientMapData.put(hbHost, this.clientMapHB.get(hbHost));
                this.clientList.add(this.clientMapHB.get(hbHost));
                this.clientMapHB.remove(hbHost);
            }
            if (!isLoadSwitch) {
                logger.info("Choose other HBClient because there is no load balancing! ");
            }
            for (Map.Entry<HostInfo, NettyClient> entry : this.clientMapHB.entrySet()) {
                entry.getValue().close();
                this.clientMap.remove(entry.getKey());
            }
            this.clientMapHB.clear();
            int realSize = this.realSize - this.clientMap.size();
            if (realSize > 0) {
                ArrayList<HostInfo> hostInfoList = new ArrayList<HostInfo>(this.proxyInfoList);
                hostInfoList.removeAll(this.clientMap.keySet());
                List<HostInfo> replaceHost = this.getRealHosts(hostInfoList, realSize);
                for (HostInfo hostInfo : replaceHost) {
                    this.initConnection(hostInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("notifyHBcontrol", (Throwable)e);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void sendHeartBeat() {
        for (Map.Entry<HostInfo, NettyClient> clientEntry : this.clientMapHB.entrySet()) {
            if (clientEntry.getKey() == null || clientEntry.getValue() == null) continue;
            this.sendHeartBeat(clientEntry.getKey(), clientEntry.getValue());
        }
        for (Map.Entry<HostInfo, NettyClient> clientEntry : this.clientMapData.entrySet()) {
            if (clientEntry.getKey() == null || clientEntry.getValue() == null || !this.sender.isIdleClient(clientEntry.getValue())) continue;
            this.sendHeartBeat(clientEntry.getKey(), clientEntry.getValue());
        }
    }

    private void sendHeartBeat(HostInfo hostInfo, NettyClient client) {
        if (!client.isActive()) {
            logger.info("client {} is inActive", (Object)hostInfo.getReferenceName());
            return;
        }
        logger.debug("active host to send heartbeat! {}", (Object)hostInfo.getReferenceName());
        String hbMsg = "heartbeat:" + hostInfo.getHostName();
        EncodeObject encodeObject = new EncodeObject(hbMsg.getBytes(StandardCharsets.UTF_8), 8, false, false, false, System.currentTimeMillis() / 1000L, 1L, "", "", "");
        try {
            if (this.configure.isNeedAuthentication()) {
                encodeObject.setAuth(this.configure.isNeedAuthentication(), this.configure.getUserName(), this.configure.getSecretKey());
            }
            client.write(encodeObject);
        }
        catch (Throwable e) {
            logger.error("sendHeartBeat to " + hostInfo.getReferenceName() + " exception {}, {}", (Object)e.toString(), (Object)e.getStackTrace());
        }
    }

    private void fillUpWorkClientWithHBClient() {
        if (this.clientMapHB.size() > 0) {
            logger.info("fill up work client with HB, clientMapData {}, clientMapHB {}", (Object)this.clientMapData.size(), (Object)this.clientMapHB.size());
        }
        Iterator<Map.Entry<HostInfo, NettyClient>> it = this.clientMapHB.entrySet().iterator();
        while (it.hasNext() && this.clientMapData.size() < this.aliveConnections) {
            Map.Entry<HostInfo, NettyClient> entry = it.next();
            this.clientMapData.put(entry.getKey(), entry.getValue());
            this.clientList.add(entry.getValue());
            this.channelLoadMapHB.remove(entry.getKey());
            it.remove();
        }
    }

    private void fillUpWorkClientWithLastBadClient() {
        int currentRealSize = this.aliveConnections - this.clientMapData.size();
        ArrayList<HostInfo> pendingBadList = new ArrayList<HostInfo>();
        for (Map.Entry<HostInfo, AtomicLong> entry : this.lastBadHostMap.entrySet()) {
            if (pendingBadList.size() < currentRealSize) {
                pendingBadList.add(entry.getKey());
                continue;
            }
            for (int index = 0; index < pendingBadList.size(); ++index) {
                if (entry.getValue().get() >= this.lastBadHostMap.get(pendingBadList.get(index)).get()) continue;
                pendingBadList.set(index, entry.getKey());
            }
        }
        List<HostInfo> replaceHostLists = this.getRealHosts(pendingBadList, currentRealSize);
        if (replaceHostLists.size() > 0) {
            logger.info("replace bad connection, use last bad list, last bad list {}, client Map data {}", (Object)this.lastBadHostMap.size(), (Object)this.clientMapData.size());
        }
        for (HostInfo hostInfo : replaceHostLists) {
            boolean isSuccess = this.initConnection(hostInfo);
            if (!isSuccess) continue;
            this.lastBadHostMap.remove(hostInfo);
        }
    }

    private void fillUpWorkClientWithBadClient(List<HostInfo> badHostLists) {
        if (badHostLists.isEmpty()) {
            logger.warn("badHostLists is empty, current hostList size {}, dataClient size {}, hbClient size {}", new Object[]{this.proxyInfoList.size(), this.clientMapData.size(), this.clientMapHB.size()});
            return;
        }
        logger.info("all hosts are bad, dataClient is empty, reuse them, badHostLists size {}, proxyInfoList size {}", (Object)badHostLists.size(), (Object)this.proxyInfoList.size());
        List<HostInfo> replaceHostLists = this.getRealHosts(badHostLists, this.aliveConnections);
        boolean isSuccess = false;
        for (HostInfo hostInfo : replaceHostLists) {
            isSuccess = this.initConnection(hostInfo);
            if (!isSuccess) continue;
            badHostLists.remove(hostInfo);
        }
    }

    private void removeBadRealClient(List<HostInfo> badHostLists, List<HostInfo> normalHostLists) {
        for (HostInfo hostInfo : this.clientMapData.keySet()) {
            if (hostInfo == null) continue;
            NettyClient client = this.clientMapData.get(hostInfo);
            if (client == null || !client.isActive()) {
                logger.info("this host {} is bad! so remove it", (Object)hostInfo.getHostName());
                badHostLists.add(hostInfo);
                continue;
            }
            logger.info("this host {} is active! so keep it", (Object)hostInfo.getHostName());
            normalHostLists.add(hostInfo);
        }
    }

    private void removeBadHBClients(List<HostInfo> badHostLists, List<HostInfo> normalHostLists) {
        for (HostInfo hostInfo : this.clientMapHB.keySet()) {
            if (hostInfo == null) continue;
            NettyClient client = this.clientMapHB.get(hostInfo);
            if (client == null || !client.isActive()) {
                logger.info("this HBhost {} is bad! so remove it", (Object)hostInfo.getHostName());
                badHostLists.add(hostInfo);
                continue;
            }
            logger.info("this HBhost {} is active! so keep it", (Object)hostInfo.getHostName());
            normalHostLists.add(hostInfo);
        }
    }

    private void removeBadClients(List<HostInfo> badHostLists) {
        for (HostInfo hostInfo : badHostLists) {
            if (hostInfo == null) continue;
            NettyClient client = this.clientMapData.get(hostInfo);
            if (client != null) {
                this.sender.waitForAckForChannel(client.getChannel());
                client.close();
                this.clientMapData.remove(hostInfo);
                this.clientMap.remove(hostInfo);
                this.clientList.remove(client);
                this.channelLoadMapData.remove(hostInfo);
                logger.info("remove this client {}", (Object)hostInfo.getHostName());
            }
            if ((client = this.clientMapHB.get(hostInfo)) == null) continue;
            this.clientMapHB.get(hostInfo).close();
            this.clientMapHB.remove(hostInfo);
            this.clientMap.remove(hostInfo);
            this.channelLoadMapHB.remove(hostInfo);
            logger.info("remove this HBclient {}", (Object)hostInfo.getHostName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBadConnectionHB() {
        try {
            this.writeLock();
            ArrayList<HostInfo> badHostLists = new ArrayList<HostInfo>();
            ArrayList<HostInfo> normalHostLists = new ArrayList<HostInfo>();
            this.removeBadRealClient(badHostLists, normalHostLists);
            this.removeBadHBClients(badHostLists, normalHostLists);
            this.removeBadClients(badHostLists);
            if (badHostLists.size() == 0 && normalHostLists.size() != 0 && this.clientMapData.size() >= this.aliveConnections) {
                logger.info("hasn't bad host! so keep it");
                if (this.loadCycle >= 30) {
                    if (this.loadThreshold == 0) {
                        logger.info("the proxy cluster is being updated!");
                    } else if (this.clientMapHB.size() != 0 && this.clientMapData.size() != 0) {
                        this.notifyHBControl();
                    } else if (this.realSize != this.clientMap.size()) {
                        logger.info("make the amount of proxy to original value");
                        int realSize = this.realSize - this.clientMap.size();
                        if (realSize > 0) {
                            ArrayList<HostInfo> hostInfoList = new ArrayList<HostInfo>(this.proxyInfoList);
                            hostInfoList.removeAll(this.clientMap.keySet());
                            List<HostInfo> replaceHost = this.getRealHosts(hostInfoList, realSize);
                            for (HostInfo hostInfo : replaceHost) {
                                this.initConnection(hostInfo);
                            }
                        }
                    }
                    this.loadCycle = 0;
                    this.channelLoadMapData.clear();
                    this.channelLoadMapHB.clear();
                }
                return;
            }
            this.loadCycle = 0;
            this.channelLoadMapData.clear();
            this.channelLoadMapHB.clear();
            ArrayList<HostInfo> hostLists = new ArrayList<HostInfo>(this.proxyInfoList);
            hostLists.removeAll(badHostLists);
            hostLists.removeAll(this.lastBadHostMap.keySet());
            hostLists.removeAll(normalHostLists);
            int realSize = this.realSize - this.clientMap.size();
            if (realSize > hostLists.size()) {
                realSize = hostLists.size();
            }
            if (realSize != 0) {
                List<HostInfo> replaceHostLists = this.getRealHosts(hostLists, realSize);
                for (HostInfo hostInfo : replaceHostLists) {
                    this.initConnection(hostInfo);
                }
            }
            if (this.clientMapData.size() < this.aliveConnections) {
                this.fillUpWorkClientWithHBClient();
            }
            if (this.clientMapData.size() < this.aliveConnections) {
                this.fillUpWorkClientWithLastBadClient();
            }
            if (this.clientMapData.isEmpty()) {
                this.fillUpWorkClientWithBadClient(badHostLists);
            }
            for (HostInfo hostInfo : badHostLists) {
                AtomicLong tmpValue;
                AtomicLong hostValue = this.lastBadHostMap.putIfAbsent(hostInfo, tmpValue = new AtomicLong(0L));
                if (hostValue == null) {
                    hostValue = tmpValue;
                }
                hostValue.incrementAndGet();
            }
            for (HostInfo hostInfo : normalHostLists) {
                this.lastBadHostMap.remove(hostInfo);
            }
            logger.info("replace bad connection ,client map size {},client list size {}", (Object)this.clientMapData.size(), (Object)this.clientList.size());
        }
        catch (Exception e) {
            logger.error("replaceBadConnection exception {}, {}", (Object)e.toString(), (Object)e.getStackTrace());
        }
        finally {
            this.writeUnlock();
        }
    }

    private List<HostInfo> getRealHosts(List<HostInfo> hostList, int realSize) {
        if (realSize > hostList.size()) {
            return hostList;
        }
        Collections.shuffle(hostList);
        ArrayList<HostInfo> resultHosts = new ArrayList<HostInfo>(realSize);
        for (int i = 0; i < realSize; ++i) {
            resultHosts.add(hostList.get(i));
            logger.info("host={}", (Object)hostList.get(i));
        }
        return resultHosts;
    }

    public NettyClient getClient(LoadBalance loadBalance, EncodeObject encodeObject) {
        NettyClient client = null;
        switch (loadBalance) {
            case RANDOM: {
                client = this.getClientByRandom();
                break;
            }
            case CONSISTENCY_HASH: {
                client = this.getClientByConsistencyHash(encodeObject.getMessageId());
                break;
            }
            case ROBIN: {
                client = this.getClientByRoundRobin();
                break;
            }
            case WEIGHT_ROBIN: {
                client = this.getClientByWeightRoundRobin();
                break;
            }
            case WEIGHT_RANDOM: {
                client = this.getClientByWeightRandom();
            }
        }
        return client;
    }

    private class SendHBThread
    extends Thread {
        private final int[] random = new int[]{17, 19, 23, 31, 37};
        private boolean bShutDown = false;

        public void shutDown() {
            logger.info("begin to shut down SendHBThread!");
            this.bShutDown = true;
        }

        @Override
        public void run() {
            while (!this.bShutDown) {
                try {
                    ClientMgr.this.loadCycle++;
                    ClientMgr.this.sendHeartBeat();
                    ClientMgr.this.replaceBadConnectionHB();
                    try {
                        int index = (int)(Math.random() * (double)this.random.length);
                        Thread.sleep(this.random[index] * 1000);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.toString());
                    }
                }
                catch (Throwable e) {
                    logger.error("SendHBThread throw exception: ", e);
                }
            }
        }
    }
}

