/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.inlong.sdk.dataproxy.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.network.ClientMgr;
import org.apache.inlong.sdk.dataproxy.network.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHandler
extends SimpleChannelInboundHandler<EncodeObject> {
    private static final Logger logger = LoggerFactory.getLogger(ClientHandler.class);
    private final Sender sender;
    private final ClientMgr clientMgr;

    public ClientHandler(Sender sender, ClientMgr clientMgr) {
        this.sender = sender;
        this.clientMgr = clientMgr;
    }

    public void channelRead0(ChannelHandlerContext ctx, EncodeObject e) {
        try {
            EncodeObject encodeObject = e;
            logger.debug("Channel = {} , msgType = {}", (Object)ctx.channel(), (Object)encodeObject.getMsgtype());
            if (encodeObject.getMsgtype() != 8) {
                this.sender.notifyFeedback(ctx.channel(), encodeObject);
            } else {
                this.clientMgr.notifyHBAck(ctx.channel(), encodeObject.getLoad());
            }
        }
        catch (Exception ex) {
            logger.error("error :", (Throwable)ex);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        logger.error("this channel {} has error! , reason is {} ", (Object)ctx.channel(), (Object)e.getCause());
        try {
            this.clientMgr.setConnectionFrozen(ctx.channel());
        }
        catch (Exception e1) {
            logger.error("exceptionCaught error :", (Throwable)e1);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
        logger.info("ClientHandler channelDisconnected {}", (Object)ctx.channel());
        try {
            this.sender.notifyConnectionDisconnected(ctx.channel());
        }
        catch (Exception e1) {
            logger.error("exceptionCaught error {}", (Object)e1.getMessage());
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        logger.info("ClientHandler channelDisconnected {}", (Object)ctx.channel());
        try {
            this.sender.notifyConnectionDisconnected(ctx.channel());
        }
        catch (Exception e1) {
            logger.error("exceptionCaught error {}", (Object)e1.getMessage());
        }
    }
}

