/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.metric;

public class MessageRecord {
    private final String msgUUID;
    private final int msgCount;
    private final long startTime;
    private final long dt;
    private final String groupId;
    private final String streamId;
    private final String localIp;
    private final long packTime;

    public MessageRecord(String groupId, String streamId, String localIp, String msgId, long dt, long packTime, int msgCount) {
        this.groupId = groupId;
        this.streamId = streamId;
        this.localIp = localIp;
        this.msgUUID = msgId;
        this.msgCount = msgCount;
        this.packTime = packTime;
        this.dt = dt;
        this.startTime = System.currentTimeMillis();
    }

    public String getMsgUUID() {
        return this.msgUUID;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public long getMessageTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public long getPackTime() {
        return this.packTime;
    }

    public long getDt() {
        return this.dt;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getLocalIp() {
        return this.localIp;
    }
}

