/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.SendResult;
import org.apache.inlong.sdk.dataproxy.config.HostInfo;
import org.apache.inlong.sdk.dataproxy.network.HttpMessage;
import org.apache.inlong.sdk.dataproxy.network.Utils;
import org.apache.inlong.sdk.dataproxy.utils.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalHttpSender {
    private static final Logger logger = LoggerFactory.getLogger(InternalHttpSender.class);
    private final ProxyClientConfig proxyClientConfig;
    private final ConcurrentHashSet<HostInfo> hostList;
    private final LinkedBlockingQueue<HttpMessage> messageCache;
    private final ExecutorService workerServices = Executors.newCachedThreadPool();
    private CloseableHttpClient httpClient;
    private boolean bShutDown = false;

    public InternalHttpSender(ProxyClientConfig proxyClientConfig, ConcurrentHashSet<HostInfo> hostList, LinkedBlockingQueue<HttpMessage> messageCache) {
        this.proxyClientConfig = proxyClientConfig;
        this.hostList = hostList;
        this.messageCache = messageCache;
        this.submitWorkThread();
    }

    private void submitWorkThread() {
        for (int i = 0; i < this.proxyClientConfig.getAsyncWorkerNumber(); ++i) {
            this.workerServices.execute(new WorkerRunner());
        }
    }

    private ArrayList<BasicNameValuePair> getHeaders(List<String> bodies, String groupId, String streamId, long dt) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("groupId", groupId));
        params.add(new BasicNameValuePair("streamId", streamId));
        params.add(new BasicNameValuePair("dt", String.valueOf(dt)));
        params.add(new BasicNameValuePair("body", StringUtils.join(bodies, (String)"\n")));
        params.add(new BasicNameValuePair("cnt", String.valueOf(bodies.size())));
        return params;
    }

    private synchronized CloseableHttpClient constructHttpClient(long timeout, TimeUnit timeUnit) {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        long timeoutInMs = timeUnit.toMillis(timeout);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)timeoutInMs).setSocketTimeout((int)timeoutInMs).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        return httpClientBuilder.build();
    }

    public List<HostInfo> getRandomHostInfo() {
        ArrayList<HostInfo> tmpHostList = new ArrayList<HostInfo>(this.hostList);
        Collections.shuffle(tmpHostList);
        int maxIndex = Math.min(this.proxyClientConfig.getAliveConnections(), tmpHostList.size());
        return tmpHostList.subList(0, maxIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendResult sendByHttp(List<String> bodies, String groupId, String streamId, long dt, long timeout, TimeUnit timeUnit, HostInfo hostInfo) throws Exception {
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        try {
            if (this.httpClient == null) {
                this.httpClient = this.constructHttpClient(timeout, timeUnit);
            }
            String url = "http://" + hostInfo.getHostName() + ":" + hostInfo.getPortNumber() + "/dataproxy/message";
            httpPost = new HttpPost(url);
            httpPost.setHeader("Connection", "close");
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> contents = this.getHeaders(bodies, groupId, streamId, dt);
            String encodedContents = URLEncodedUtils.format(contents, (Charset)StandardCharsets.UTF_8);
            httpPost.setEntity((HttpEntity)new StringEntity(encodedContents));
            logger.info("begin to post request to {}, encoded content is: {}", (Object)url, (Object)encodedContents);
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
            int returnCode = response.getStatusLine().getStatusCode();
            if (Utils.isBlank(returnStr) || 200 != returnCode) {
                throw new Exception("get config from manager failed, result: " + returnStr + ", code: " + returnCode);
            }
            logger.debug("success to get config from manager, result str: " + returnStr);
            JsonObject jsonResponse = JsonParser.parseString((String)returnStr).getAsJsonObject();
            JsonElement codeElement = jsonResponse.get("code");
            if (codeElement != null) {
                if (DataProxyErrCode.SUCCESS.getErrCode() == codeElement.getAsInt()) {
                    SendResult sendResult = SendResult.OK;
                    return sendResult;
                }
                SendResult sendResult = SendResult.INVALID_DATA;
                return sendResult;
            }
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            if (response != null) {
                response.close();
            }
        }
        return SendResult.UNKOWN_ERROR;
    }

    public SendResult sendMessageWithHostInfo(List<String> bodies, String groupId, String streamId, long dt, long timeout, TimeUnit timeUnit) {
        List<HostInfo> randomHostList = this.getRandomHostInfo();
        Exception tmpException = null;
        for (HostInfo hostInfo : randomHostList) {
            try {
                return this.sendByHttp(bodies, groupId, streamId, dt, timeout, timeUnit, hostInfo);
            }
            catch (Exception exception) {
                tmpException = exception;
                logger.debug("error while sending data, resending it", (Throwable)exception);
            }
        }
        if (tmpException != null) {
            logger.error("error while sending data", tmpException);
        }
        return SendResult.UNKOWN_ERROR;
    }

    public void close() throws Exception {
        this.bShutDown = true;
        if (this.proxyClientConfig.isCleanHttpCacheWhenClosing()) {
            this.messageCache.clear();
        }
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        this.workerServices.shutdown();
    }

    private class WorkerRunner
    implements Runnable {
        private WorkerRunner() {
        }

        @Override
        public void run() {
            while (!InternalHttpSender.this.bShutDown || !InternalHttpSender.this.messageCache.isEmpty()) {
                try {
                    while (!InternalHttpSender.this.messageCache.isEmpty()) {
                        HttpMessage httpMessage = (HttpMessage)InternalHttpSender.this.messageCache.poll();
                        if (httpMessage == null) continue;
                        SendResult result = InternalHttpSender.this.sendMessageWithHostInfo(httpMessage.getBodies(), httpMessage.getGroupId(), httpMessage.getStreamId(), httpMessage.getDt(), httpMessage.getTimeout(), httpMessage.getTimeUnit());
                        httpMessage.getCallback().onMessageAck(result);
                    }
                    TimeUnit.MILLISECONDS.sleep(InternalHttpSender.this.proxyClientConfig.getAsyncWorkerInterval());
                }
                catch (Exception exception) {
                    logger.error("exception caught", (Throwable)exception);
                }
            }
        }
    }
}

