/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.List;
import org.apache.inlong.sdk.dataproxy.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.config.EncryptConfigEntry;
import org.apache.inlong.sdk.dataproxy.config.EncryptInfo;
import org.apache.inlong.sdk.dataproxy.network.Utils;
import org.apache.inlong.sdk.dataproxy.utils.EncryptUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class ProtocolEncoder
extends MessageToMessageEncoder<EncodeObject> {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolEncoder.class);

    protected void encode(ChannelHandlerContext ctx, EncodeObject message, List<Object> out) throws Exception {
        ByteBuf buf = null;
        try {
            EncodeObject object = message;
            if (object.getMsgtype() == 3) {
                buf = this.writeToBuf3(object);
            }
            if (object.getMsgtype() == 5) {
                buf = this.writeToBuf5(object);
            }
            if (object.getMsgtype() == 7) {
                buf = this.writeToBuf7(object);
            }
            if (object.getMsgtype() == 8) {
                buf = this.writeToBuf8(object);
            }
        }
        catch (Exception e) {
            logger.error("{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        if (buf != null) {
            out.add(buf);
        } else {
            logger.warn("write buf is null !");
        }
    }

    private ByteBuf writeToBuf8(EncodeObject object) {
        ByteBuf buf = null;
        try {
            String endAttr = object.getCommonattr();
            if (object.isAuth()) {
                if (Utils.isNotBlank(endAttr)) {
                    endAttr = endAttr + "&";
                }
                long timestamp = System.currentTimeMillis();
                int nonce = new SecureRandom(String.valueOf(timestamp).getBytes()).nextInt(Integer.MAX_VALUE);
                endAttr = endAttr + "_userName=" + object.getUserName() + "&_clientIP=" + Utils.getLocalIp() + "&_signature=" + Utils.generateSignature(object.getUserName(), timestamp, nonce, object.getSecretKey()) + "&_timeStamp=" + timestamp + "&_nonce=" + nonce;
            }
            if (Utils.isNotBlank(object.getMsgUUID())) {
                if (Utils.isNotBlank(endAttr)) {
                    endAttr = endAttr + "&";
                }
                endAttr = endAttr + "msgUUID=" + object.getMsgUUID();
            }
            int msgType = 8;
            if (object.isAuth()) {
                msgType |= 0x80;
            }
            int totalLength = 12 + endAttr.getBytes("utf8").length + 2;
            buf = ByteBufAllocator.DEFAULT.buffer(4 + totalLength);
            buf.writeInt(totalLength);
            buf.writeByte(msgType);
            buf.writeInt((int)object.getDt());
            buf.writeByte(1);
            buf.writeInt(0);
            buf.writeShort(endAttr.getBytes("utf8").length);
            if (endAttr.getBytes("utf8").length > 0) {
                buf.writeBytes(endAttr.getBytes("utf8"));
            }
            buf.writeShort(60929);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return buf;
    }

    private ByteBuf constructBody(byte[] body, EncodeObject object, int totalLength, int cnt) throws UnsupportedEncodingException {
        ByteBuf buf = null;
        if (body != null) {
            EncryptConfigEntry encryptEntry;
            if (object.isCompress()) {
                body = this.processCompress(body);
            }
            String endAttr = object.getCommonattr();
            if (object.isEncrypt() && (encryptEntry = object.getEncryptEntry()) != null) {
                if (Utils.isNotBlank(endAttr)) {
                    endAttr = endAttr + "&";
                }
                EncryptInfo encryptInfo = encryptEntry.getRsaEncryptInfo();
                endAttr = endAttr + "_userName=" + object.getUserName() + "&_encyVersion=" + encryptInfo.getVersion() + "&_encyAesKey=" + encryptInfo.getRsaEncryptedKey();
                body = EncryptUtil.aesEncrypt(body, encryptInfo.getAesKey());
            }
            if (!object.isGroupIdTransfer()) {
                if (Utils.isNotBlank(endAttr)) {
                    endAttr = endAttr + "&";
                }
                endAttr = endAttr + "groupId=" + object.getGroupId() + "&streamId=" + object.getStreamId();
            }
            if (Utils.isNotBlank(object.getMsgUUID())) {
                if (Utils.isNotBlank(endAttr)) {
                    endAttr = endAttr + "&";
                }
                endAttr = endAttr + "msgUUID=" + object.getMsgUUID();
            }
            int msgType = 7;
            if (object.isEncrypt()) {
                msgType |= 0x40;
            }
            if (object.isCompress()) {
                msgType |= 0x20;
            }
            totalLength = totalLength + body.length + endAttr.getBytes("utf8").length;
            buf = ByteBufAllocator.DEFAULT.buffer(4 + totalLength);
            buf.writeInt(totalLength);
            buf.writeByte(msgType);
            buf.writeShort(object.getGroupIdNum());
            buf.writeShort(object.getStreamIdNum());
            String bitStr = object.isSupportLF() ? "1" : "0";
            bitStr = bitStr + (object.getMessageKey().equals("minute") ? "1" : "0");
            bitStr = bitStr + (object.getMessageKey().equals("file") ? "1" : "0");
            bitStr = bitStr + (!object.isGroupIdTransfer() ? "1" : "0");
            bitStr = bitStr + (object.isReport() ? "1" : "0");
            bitStr = bitStr + "0";
            buf.writeShort(Integer.parseInt(bitStr, 2));
            buf.writeInt((int)object.getDt());
            buf.writeShort(cnt);
            buf.writeInt(Integer.valueOf(object.getMessageId()).intValue());
            buf.writeInt(body.length);
            buf.writeBytes(body);
            buf.writeShort(endAttr.getBytes("utf8").length);
            buf.writeBytes(endAttr.getBytes("utf8"));
            buf.writeShort(60929);
        }
        return buf;
    }

    private ByteBuf writeToBuf7(EncodeObject object) {
        ByteBuf buf = null;
        try {
            ByteArrayOutputStream out;
            int totalLength = 25;
            byte[] body = null;
            int cnt = 1;
            if (object.getBodylist() != null && object.getBodylist().size() != 0) {
                cnt = object.getCnt() > 0 ? object.getCnt() : object.getBodylist().size();
                out = new ByteArrayOutputStream();
                Iterator<byte[]> iter = object.getBodylist().iterator();
                if (object.isSupportLF()) {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    int len = object.getBodylist().size();
                    for (int i = 0; i < len - 1; ++i) {
                        data.write(object.getBodylist().get(i));
                        data.write("\n".getBytes("utf8"));
                    }
                    data.write(object.getBodylist().get(len - 1));
                    ByteBuffer databuffer = ByteBuffer.allocate(4);
                    databuffer.putInt(data.toByteArray().length);
                    out.write(databuffer.array());
                    out.write(data.toByteArray());
                } else {
                    while (iter.hasNext()) {
                        byte[] entry = iter.next();
                        ByteBuffer databuffer = ByteBuffer.allocate(4);
                        databuffer.putInt(entry.length);
                        out.write(databuffer.array());
                        out.write(entry);
                    }
                }
                body = out.toByteArray();
            }
            if (object.getBodyBytes() != null && object.getBodyBytes().length != 0) {
                out = new ByteArrayOutputStream();
                ByteBuffer databuffer = ByteBuffer.allocate(4);
                databuffer.putInt(object.getBodyBytes().length);
                out.write(databuffer.array());
                out.write(object.getBodyBytes());
                body = out.toByteArray();
            }
            buf = this.constructBody(body, object, totalLength, cnt);
        }
        catch (Exception e) {
            logger.error("writeToBuf7 has {}", (Throwable)e);
        }
        return buf;
    }

    private ByteBuf writeToBuf5(EncodeObject object) {
        ByteBuf buf = null;
        try {
            ByteArrayOutputStream out;
            int totalLength = 9;
            byte[] body = null;
            if (object.getBodylist() != null && object.getBodylist().size() != 0) {
                out = new ByteArrayOutputStream();
                for (byte[] entry : object.getBodylist()) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                    byteBuffer.putInt(entry.length);
                    out.write(byteBuffer.array());
                    out.write(entry);
                }
                body = out.toByteArray();
            }
            if (object.getBodyBytes() != null && object.getBodyBytes().length != 0) {
                out = new ByteArrayOutputStream();
                ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                byteBuffer.putInt(object.getBodyBytes().length);
                out.write(byteBuffer.array());
                out.write(object.getBodyBytes());
                body = out.toByteArray();
            }
            if (body != null) {
                EncryptConfigEntry encryptEntry;
                String msgAttrs = object.getAttributes();
                if (object.isCompress()) {
                    body = this.processCompress(body);
                }
                if (object.isEncrypt() && (encryptEntry = object.getEncryptEntry()) != null) {
                    if (Utils.isNotBlank(msgAttrs)) {
                        msgAttrs = msgAttrs + "&";
                    }
                    EncryptInfo encryptInfo = encryptEntry.getRsaEncryptInfo();
                    msgAttrs = msgAttrs + "_userName=" + object.getUserName() + "&_encyVersion=" + encryptInfo.getVersion() + "&_encyAesKey=" + encryptInfo.getRsaEncryptedKey();
                    body = EncryptUtil.aesEncrypt(body, encryptInfo.getAesKey());
                }
                if (Utils.isNotBlank(object.getMsgUUID())) {
                    if (Utils.isNotBlank(msgAttrs)) {
                        msgAttrs = msgAttrs + "&";
                    }
                    msgAttrs = msgAttrs + "msgUUID=" + object.getMsgUUID();
                }
                int msgType = 5;
                if (object.isEncrypt()) {
                    msgType |= 0x40;
                }
                totalLength = totalLength + body.length + msgAttrs.getBytes("utf8").length;
                buf = ByteBufAllocator.DEFAULT.buffer(4 + totalLength);
                buf.writeInt(totalLength);
                buf.writeByte(msgType);
                buf.writeInt(body.length);
                buf.writeBytes(body);
                buf.writeInt(msgAttrs.getBytes("utf8").length);
                buf.writeBytes(msgAttrs.getBytes("utf8"));
            }
        }
        catch (Exception e) {
            logger.error("{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return buf;
    }

    private ByteBuf writeToBuf3(EncodeObject object) {
        ByteBuf buf = null;
        try {
            int totalLength = 9;
            byte[] body = null;
            if (object.getBodylist() != null && object.getBodylist().size() != 0) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                for (byte[] entry : object.getBodylist()) {
                    out.write(entry);
                    out.write("\n".getBytes("utf8"));
                }
                body = out.toByteArray();
            }
            if (object.getBodyBytes() != null && object.getBodyBytes().length != 0) {
                body = object.getBodyBytes();
            }
            if (body != null) {
                EncryptConfigEntry encryptEntry;
                String msgAttrs = object.getAttributes();
                if (object.isCompress()) {
                    body = this.processCompress(body);
                }
                if (object.isEncrypt() && (encryptEntry = object.getEncryptEntry()) != null) {
                    if (Utils.isNotBlank(msgAttrs)) {
                        msgAttrs = msgAttrs + "&";
                    }
                    EncryptInfo encryptInfo = encryptEntry.getRsaEncryptInfo();
                    msgAttrs = msgAttrs + "_userName=" + object.getUserName() + "&_encyVersion=" + encryptInfo.getVersion() + "&_encyAesKey=" + encryptInfo.getRsaEncryptedKey();
                    body = EncryptUtil.aesEncrypt(body, encryptInfo.getAesKey());
                }
                if (Utils.isNotBlank(object.getMsgUUID())) {
                    if (Utils.isNotBlank(msgAttrs)) {
                        msgAttrs = msgAttrs + "&";
                    }
                    msgAttrs = msgAttrs + "msgUUID=" + object.getMsgUUID();
                }
                int msgType = 3;
                if (object.isEncrypt()) {
                    msgType |= 0x40;
                }
                totalLength = totalLength + body.length + msgAttrs.getBytes("utf8").length;
                buf = ByteBufAllocator.DEFAULT.buffer(4 + totalLength);
                buf.writeInt(totalLength);
                buf.writeByte(msgType);
                buf.writeInt(body.length);
                buf.writeBytes(body);
                buf.writeInt(msgAttrs.getBytes("utf8").length);
                buf.writeBytes(msgAttrs.getBytes("utf8"));
            }
        }
        catch (Exception e) {
            logger.error("{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return buf;
    }

    private byte[] processCompress(byte[] body) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(body);
            int guessLen = Snappy.maxCompressedLength((int)out.size());
            byte[] tmpData = new byte[guessLen];
            int len = Snappy.compress((byte[])out.toByteArray(), (int)0, (int)out.size(), (byte[])tmpData, (int)0);
            body = new byte[len];
            System.arraycopy(tmpData, 0, body, 0, len);
        }
        catch (IOException e) {
            logger.error("{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return body;
    }
}

