/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.codec;

import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.sdk.dataproxy.SendResult;
import org.apache.inlong.sdk.dataproxy.config.EncryptConfigEntry;

public class EncodeObject {
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)"&").trimResults().withKeyValueSeparator("=");
    private byte[] bodyBytes;
    private String attributes;
    private String messageId;
    private int msgtype;
    private List<byte[]> bodylist;
    private String commonattr = "";
    private String messageKey = "data";
    private String proxyIp = "";
    private long dt;
    private long packageTime = System.currentTimeMillis();
    private int cnt = -1;
    private boolean isReport = false;
    private boolean isGroupIdTransfer = false;
    private boolean isSupportLF = false;
    private boolean isAuth = false;
    private boolean isEncrypt = false;
    private boolean isCompress = true;
    private int groupIdNum;
    private int streamIdNum;
    private String groupId;
    private String streamId;
    private short load;
    private String userName = "";
    private String secretKey = "";
    private String msgUUID = null;
    private EncryptConfigEntry encryptEntry = null;
    private SendResult sendResult = SendResult.OK;
    private String errMsg;
    private String dpIp;

    public EncodeObject(String attributes) {
        this.handleAttr(attributes);
    }

    public EncodeObject(byte[] bodyBytes, String attributes) {
        this.bodyBytes = bodyBytes;
        this.attributes = attributes;
        this.handleAttr(attributes);
    }

    public EncodeObject(byte[] bodyBytes, String attributes, String messageId) {
        this.bodyBytes = bodyBytes;
        this.messageId = messageId;
        this.attributes = attributes + "&messageId=" + messageId;
        this.addRTMS(MsgType.MSG_COMMON_SERVICE.getValue());
    }

    public EncodeObject(byte[] bodyBytes, String attributes, String messageId, int msgtype, boolean isCompress, String groupId) {
        this.bodyBytes = bodyBytes;
        this.messageId = messageId;
        this.attributes = attributes + "&messageId=" + messageId;
        this.msgtype = msgtype;
        this.groupId = groupId;
        this.isCompress = isCompress;
        this.addRTMS(msgtype);
    }

    public EncodeObject(List<byte[]> bodyList, String attributes, String messageId, int msgtype, boolean isCompress, String groupId) {
        this.bodylist = bodyList;
        this.messageId = messageId;
        this.attributes = attributes + "&messageId=" + messageId;
        this.msgtype = msgtype;
        this.groupId = groupId;
        this.isCompress = isCompress;
        this.addRTMS(msgtype);
    }

    public EncodeObject(byte[] bodyBytes, int msgtype, boolean isCompress, boolean isReport, boolean isGroupIdTransfer, long dt, long seqId, String groupId, String streamId, String commonattr) {
        this.bodyBytes = bodyBytes;
        this.msgtype = msgtype;
        this.isCompress = isCompress;
        this.isReport = isReport;
        this.dt = dt;
        this.isGroupIdTransfer = isGroupIdTransfer;
        this.commonattr = commonattr;
        this.messageId = String.valueOf(seqId);
        this.groupId = groupId;
        this.streamId = streamId;
        this.addRTMS(msgtype);
    }

    public EncodeObject(List<byte[]> bodyList, int msgtype, boolean isCompress, boolean isReport, boolean isGroupIdTransfer, long dt, long seqId, String groupId, String streamId, String commonattr) {
        this.bodylist = bodyList;
        this.msgtype = msgtype;
        this.isCompress = isCompress;
        this.isReport = isReport;
        this.dt = dt;
        this.isGroupIdTransfer = isGroupIdTransfer;
        this.commonattr = commonattr;
        this.messageId = String.valueOf(seqId);
        this.groupId = groupId;
        this.streamId = streamId;
        this.addRTMS(msgtype);
    }

    public EncodeObject(byte[] bodyBytes, int msgtype, boolean isCompress, boolean isReport, boolean isGroupIdTransfer, long dt, long seqId, String groupId, String streamId, String commonattr, String messageKey, String proxyIp) {
        this.bodyBytes = bodyBytes;
        this.msgtype = msgtype;
        this.isCompress = isCompress;
        this.isReport = isReport;
        this.dt = dt;
        this.isGroupIdTransfer = isGroupIdTransfer;
        this.commonattr = commonattr;
        this.messageId = String.valueOf(seqId);
        this.groupId = groupId;
        this.streamId = streamId;
        this.messageKey = messageKey;
        this.proxyIp = proxyIp;
        this.addRTMS(msgtype);
    }

    public EncodeObject(List<byte[]> bodyList, int msgtype, boolean isCompress, boolean isReport, boolean isGroupIdTransfer, long dt, long seqId, String groupId, String streamId, String commonattr, String messageKey, String proxyIp) {
        this.bodylist = bodyList;
        this.msgtype = msgtype;
        this.isCompress = isCompress;
        this.isReport = isReport;
        this.dt = dt;
        this.isGroupIdTransfer = isGroupIdTransfer;
        this.commonattr = commonattr;
        this.messageId = String.valueOf(seqId);
        this.groupId = groupId;
        this.streamId = streamId;
        this.messageKey = messageKey;
        this.proxyIp = proxyIp;
        this.addRTMS(msgtype);
    }

    private void handleAttr(String attributes) {
        if (StringUtils.isBlank((CharSequence)attributes)) {
            return;
        }
        HashMap backAttrs = new HashMap(MAP_SPLITTER.split((CharSequence)attributes));
        if (backAttrs.containsKey("messageId")) {
            this.messageId = (String)backAttrs.get("messageId");
        }
        this.dpIp = (String)backAttrs.get("dpIP");
        String errCode = (String)backAttrs.get("errCode");
        if (StringUtils.isBlank((CharSequence)errCode) || Integer.parseInt(errCode) == 0) {
            this.sendResult = SendResult.OK;
        } else {
            this.errMsg = (String)backAttrs.get("errMsg");
            if (StringUtils.isBlank((CharSequence)this.errMsg)) {
                this.errMsg = DataProxyErrCode.valueOf((int)Integer.parseInt(errCode)).getErrMsg();
            }
            this.sendResult = this.convertToSendResult(Integer.parseInt(errCode));
        }
    }

    private void addRTMS(int msgtype) {
        if (msgtype == MsgType.MSG_BIN_MULTI_BODY.getValue() || msgtype == MsgType.MSG_BIN_HEARTBEAT.getValue()) {
            this.commonattr = StringUtils.isBlank((CharSequence)this.commonattr) ? "rtms=" + System.currentTimeMillis() : this.commonattr + "&rtms=" + System.currentTimeMillis();
        } else {
            this.attributes = StringUtils.isBlank((CharSequence)this.attributes) ? "rtms=" + System.currentTimeMillis() : this.attributes + "&rtms=" + System.currentTimeMillis();
        }
    }

    private SendResult convertToSendResult(int errCode) {
        DataProxyErrCode dpErrCode = DataProxyErrCode.valueOf((int)errCode);
        switch (dpErrCode) {
            case SINK_SERVICE_UNREADY: {
                return SendResult.SINK_SERVICE_UNREADY;
            }
            case MISS_REQUIRED_GROUPID_ARGUMENT: 
            case MISS_REQUIRED_STREAMID_ARGUMENT: 
            case MISS_REQUIRED_DT_ARGUMENT: 
            case UNSUPPORTED_EXTEND_FIELD_VALUE: {
                return SendResult.INVALID_ATTRIBUTES;
            }
            case MISS_REQUIRED_BODY_ARGUMENT: 
            case EMPTY_MSG: {
                return SendResult.INVALID_DATA;
            }
            case BODY_EXCEED_MAX_LEN: {
                return SendResult.BODY_EXCEED_MAX_LEN;
            }
            case UNCONFIGURED_GROUPID_OR_STREAMID: {
                return SendResult.UNCONFIGURED_GROUPID_OR_STREAMID;
            }
            case PUT_EVENT_TO_CHANNEL_FAILURE: 
            case NO_AVAILABLE_PRODUCER: 
            case PRODUCER_IS_NULL: 
            case SEND_REQUEST_TO_MQ_FAILURE: 
            case MQ_RETURN_ERROR: 
            case DUPLICATED_MESSAGE: {
                return SendResult.DATAPROXY_FAIL_TO_RECEIVE;
            }
        }
        return SendResult.UNKOWN_ERROR;
    }

    public String getMsgUUID() {
        return this.msgUUID;
    }

    public void setMsgUUID(String msgUUID) {
        this.msgUUID = msgUUID;
    }

    public boolean isGroupIdTransfer() {
        return this.isGroupIdTransfer;
    }

    public void setGroupIdTransfer(boolean isGroupIdTransfer) {
        this.isGroupIdTransfer = isGroupIdTransfer;
    }

    public short getLoad() {
        return this.load;
    }

    public void setLoad(short load) {
        this.load = load;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public boolean isReport() {
        return this.isReport;
    }

    public void setReport(boolean isReport) {
        this.isReport = isReport;
    }

    public boolean isAuth() {
        return this.isAuth;
    }

    public void setAuth(boolean auth, String userName, String secretKey) {
        this.isAuth = auth;
        this.userName = userName;
        this.secretKey = secretKey;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isEncrypt() {
        return this.isEncrypt;
    }

    public EncryptConfigEntry getEncryptEntry() {
        return this.encryptEntry;
    }

    public void setEncryptEntry(boolean isEncrypt, String userName, EncryptConfigEntry encryptEntry) {
        this.isEncrypt = isEncrypt;
        if (userName != null) {
            this.userName = userName;
        }
        this.encryptEntry = encryptEntry;
    }

    public int getGroupIdNum() {
        return this.groupIdNum;
    }

    public void setGroupIdNum(int groupIdNum) {
        this.groupIdNum = groupIdNum;
    }

    public int getStreamIdNum() {
        return this.streamIdNum;
    }

    public void setStreamIdNum(int streamIdNum) {
        this.streamIdNum = streamIdNum;
    }

    public long getDt() {
        return this.dt;
    }

    public void setDt(long dt) {
        this.dt = dt;
    }

    public long getPackageTime() {
        return this.packageTime;
    }

    public void setPackageTime(long packageTime) {
        this.packageTime = packageTime;
    }

    public String getCommonattr() {
        return this.commonattr;
    }

    public void setCommonattr(String commonattr) {
        this.commonattr = commonattr;
    }

    public boolean isCompress() {
        return this.isCompress;
    }

    public List<byte[]> getBodylist() {
        return this.bodylist;
    }

    public int getMsgtype() {
        return this.msgtype;
    }

    public void setMsgtype(int msgtype) {
        this.msgtype = msgtype;
    }

    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    public void setBodyBytes(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public void setProxyIp(String proxyIp) {
        this.proxyIp = proxyIp;
    }

    public boolean isSupportLF() {
        return this.isSupportLF;
    }

    public void setSupportLF(boolean supportLF) {
        this.isSupportLF = supportLF;
    }

    public int getCnt() {
        return this.cnt;
    }

    public void setCnt(int cnt) {
        this.cnt = cnt;
    }

    public int getRealCnt() {
        if (this.bodylist != null) {
            return this.bodylist.size();
        }
        return 1;
    }

    public String getDpIp() {
        return this.dpIp;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public SendResult getSendResult() {
        return this.sendResult;
    }
}

