/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy;

import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.ConfigConstants;
import org.apache.inlong.sdk.dataproxy.LoadBalance;
import org.apache.inlong.sdk.dataproxy.network.ProxysdkException;
import org.apache.inlong.sdk.dataproxy.network.Utils;

public class ProxyClientConfig {
    private int aliveConnections;
    private int syncThreadPoolSize;
    private int asyncCallbackSize;
    private int managerPort = 8099;
    private String managerIP = "";
    private String managerIpLocalPath = System.getProperty("user.dir") + "/.inlong/.managerIps";
    private String proxyIPServiceURL = "";
    private int proxyUpdateIntervalMinutes;
    private int proxyUpdateMaxRetry;
    private String netTag;
    private String groupId;
    private boolean isFile = false;
    private boolean isLocalVisit = true;
    private boolean isNeedDataEncry = false;
    private boolean needAuthentication = false;
    private String userName = "";
    private String secretKey = "";
    private String rsaPubKeyUrl = "";
    private String confStoreBasePath = System.getProperty("user.dir") + "/.inlong/";
    private boolean needVerServer = false;
    private String tlsServerCertFilePathAndName;
    private String tlsServerKey;
    private int maxTimeoutCnt = 3;
    private String authSecretId;
    private String authSecretKey;
    private String protocolType;
    private boolean enableSaveManagerVIps = true;
    private boolean enableSlaMetric = false;
    private int managerConnectionTimeout = 10000;
    private boolean readProxyIPFromLocal = false;
    private long connectTimeoutMillis;
    private long requestTimeoutMillis;
    private int managerSocketTimeout = 30000;
    private boolean discardOldMessage = false;
    private int proxyHttpUpdateIntervalMinutes;
    private int asyncWorkerNumber = 3;
    private int asyncWorkerInterval = 500;
    private boolean cleanHttpCacheWhenClosing = false;
    private boolean useGroupIdAsKey = true;
    private boolean useStreamIdAsKey = true;
    private boolean useLocalIpAsKey = true;
    private int metricIntervalInMs = 60000;
    private long maxProxyCacheTimeInMs = 1800000L;
    private String metricGroupId = "inlong_sla_metric";
    private int ioThreadNum = Runtime.getRuntime().availableProcessors();
    private boolean enableBusyWait = false;
    private int virtualNode;
    private LoadBalance loadBalance;
    private int maxRetry;

    public ProxyClientConfig(String localHost, boolean isLocalVisit, String managerIp, int managerPort, String groupId, String netTag, String authSecretId, String authSecretKey, LoadBalance loadBalance, int virtualNode, int maxRetry) throws ProxysdkException {
        if (Utils.isBlank(localHost)) {
            throw new ProxysdkException("localHost is blank!");
        }
        if (Utils.isBlank(managerIp)) {
            throw new IllegalArgumentException("managerIp is Blank!");
        }
        if (Utils.isBlank(groupId)) {
            throw new ProxysdkException("groupId is blank!");
        }
        this.proxyIPServiceURL = "http://" + managerIp + ":" + managerPort + "/inlong/manager/openapi/dataproxy/getIpList/" + groupId;
        this.groupId = groupId;
        this.netTag = netTag;
        this.isLocalVisit = isLocalVisit;
        this.managerPort = managerPort;
        this.managerIP = managerIp;
        Utils.validLocalIp(localHost);
        this.aliveConnections = 3;
        this.syncThreadPoolSize = 5;
        this.asyncCallbackSize = 50000;
        this.proxyUpdateIntervalMinutes = 5;
        this.proxyHttpUpdateIntervalMinutes = 60;
        this.proxyUpdateMaxRetry = 10;
        this.connectTimeoutMillis = ConfigConstants.DEFAULT_CONNECT_TIMEOUT_MILLIS;
        this.setRequestTimeoutMillis(ConfigConstants.DEFAULT_REQUEST_TIMEOUT_MILLIS);
        this.authSecretId = authSecretId;
        this.authSecretKey = authSecretKey;
        this.loadBalance = loadBalance;
        this.virtualNode = virtualNode;
        this.maxRetry = maxRetry;
    }

    public ProxyClientConfig(String localHost, boolean isLocalVisit, String managerIp, int managerPort, String groupId, String netTag, String authSecretId, String authSecretKey) throws ProxysdkException {
        this(localHost, isLocalVisit, managerIp, managerPort, groupId, netTag, authSecretId, authSecretKey, ConfigConstants.DEFAULT_LOAD_BALANCE, ConfigConstants.DEFAULT_VIRTUAL_NODE, ConfigConstants.DEFAULT_RANDOM_MAX_RETRY);
    }

    public String getTlsServerCertFilePathAndName() {
        return this.tlsServerCertFilePathAndName;
    }

    public String getTlsServerKey() {
        return this.tlsServerKey;
    }

    public boolean isLocalVisit() {
        return this.isLocalVisit;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void setFile(boolean file) {
        this.isFile = file;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public int getManagerPort() {
        return this.managerPort;
    }

    public String getManagerIP() {
        return this.managerIP;
    }

    public String getManagerIpLocalPath() {
        return this.managerIpLocalPath;
    }

    public void setManagerIpLocalPath(String managerIpLocalPath) throws ProxysdkException {
        if (StringUtils.isEmpty((CharSequence)managerIpLocalPath)) {
            throw new ProxysdkException("managerIpLocalPath is empty.");
        }
        if (managerIpLocalPath.charAt(managerIpLocalPath.length() - 1) == '/') {
            managerIpLocalPath = managerIpLocalPath.substring(0, managerIpLocalPath.length() - 1);
        }
        this.managerIpLocalPath = managerIpLocalPath + "/.managerIps";
    }

    public boolean isEnableSaveManagerVIps() {
        return this.enableSaveManagerVIps;
    }

    public void setEnableSaveManagerVIps(boolean enable) {
        this.enableSaveManagerVIps = enable;
    }

    public String getConfStoreBasePath() {
        return this.confStoreBasePath;
    }

    public void setConfStoreBasePath(String confStoreBasePath) {
        this.confStoreBasePath = confStoreBasePath;
    }

    public int getAliveConnections() {
        return this.aliveConnections;
    }

    public void setAliveConnections(int aliveConnections) {
        this.aliveConnections = aliveConnections;
    }

    public int getSyncThreadPoolSize() {
        return this.syncThreadPoolSize;
    }

    public void setSyncThreadPoolSize(int syncThreadPoolSize) {
        if (syncThreadPoolSize > 10) {
            throw new IllegalArgumentException("");
        }
        this.syncThreadPoolSize = syncThreadPoolSize;
    }

    public int getTotalAsyncCallbackSize() {
        return this.asyncCallbackSize;
    }

    public void setTotalAsyncCallbackSize(int asyncCallbackSize) {
        this.asyncCallbackSize = asyncCallbackSize;
    }

    public String getProxyIPServiceURL() {
        return this.proxyIPServiceURL;
    }

    public int getMaxTimeoutCnt() {
        return this.maxTimeoutCnt;
    }

    public void setMaxTimeoutCnt(int maxTimeoutCnt) {
        if (maxTimeoutCnt < 0) {
            throw new IllegalArgumentException("maxTimeoutCnt must bigger than 0");
        }
        this.maxTimeoutCnt = maxTimeoutCnt;
    }

    public int getProxyUpdateIntervalMinutes() {
        return this.proxyUpdateIntervalMinutes;
    }

    public void setProxyUpdateIntervalMinutes(int proxyUpdateIntervalMinutes) {
        this.proxyUpdateIntervalMinutes = proxyUpdateIntervalMinutes;
    }

    public int getProxyUpdateMaxRetry() {
        return this.proxyUpdateMaxRetry;
    }

    public void setProxyUpdateMaxRetry(int proxyUpdateMaxRetry) {
        this.proxyUpdateMaxRetry = proxyUpdateMaxRetry;
    }

    public long getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public void setConnectTimeoutMillis(long connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public boolean isNeedVerServer() {
        return this.needVerServer;
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public void setRequestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = requestTimeoutMillis;
    }

    public String getNetTag() {
        return this.netTag;
    }

    public String getRsaPubKeyUrl() {
        return this.rsaPubKeyUrl;
    }

    public boolean isNeedDataEncry() {
        return this.isNeedDataEncry;
    }

    public boolean isNeedAuthentication() {
        return this.needAuthentication;
    }

    public void setAuthenticationInfo(boolean needAuthentication, boolean needDataEncry, String userName, String secretKey) {
        this.needAuthentication = needAuthentication;
        this.isNeedDataEncry = needDataEncry;
        if (this.needAuthentication || this.isNeedDataEncry) {
            if (Utils.isBlank(userName)) {
                throw new IllegalArgumentException("userName is Blank!");
            }
            if (Utils.isBlank(secretKey)) {
                throw new IllegalArgumentException("secretKey is Blank!");
            }
        }
        this.userName = userName.trim();
        this.secretKey = secretKey.trim();
    }

    public void setHttpsInfo(String tlsServerCertFilePathAndName, String tlsServerKey) {
        if (Utils.isBlank(tlsServerCertFilePathAndName)) {
            throw new IllegalArgumentException("tlsServerCertFilePathAndName is Blank!");
        }
        if (Utils.isBlank(tlsServerKey)) {
            throw new IllegalArgumentException("tlsServerKey is Blank!");
        }
        this.needVerServer = true;
        this.tlsServerKey = tlsServerKey;
        this.tlsServerCertFilePathAndName = tlsServerCertFilePathAndName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isReadProxyIPFromLocal() {
        return this.readProxyIPFromLocal;
    }

    public void setReadProxyIPFromLocal(boolean readProxyIPFromLocal) {
        this.readProxyIPFromLocal = readProxyIPFromLocal;
    }

    public int getProxyHttpUpdateIntervalMinutes() {
        return this.proxyHttpUpdateIntervalMinutes;
    }

    public void setProxyHttpUpdateIntervalMinutes(int proxyHttpUpdateIntervalMinutes) {
        this.proxyHttpUpdateIntervalMinutes = proxyHttpUpdateIntervalMinutes;
    }

    public boolean isDiscardOldMessage() {
        return this.discardOldMessage;
    }

    public void setDiscardOldMessage(boolean discardOldMessage) {
        this.discardOldMessage = discardOldMessage;
    }

    public int getAsyncWorkerNumber() {
        return this.asyncWorkerNumber;
    }

    public void setAsyncWorkerNumber(int asyncWorkerNumber) {
        this.asyncWorkerNumber = asyncWorkerNumber;
    }

    public int getAsyncWorkerInterval() {
        return this.asyncWorkerInterval;
    }

    public void setAsyncWorkerInterval(int asyncWorkerInterval) {
        this.asyncWorkerInterval = asyncWorkerInterval;
    }

    public int getManagerSocketTimeout() {
        return this.managerSocketTimeout;
    }

    public void setManagerSocketTimeout(int managerSocketTimeout) {
        this.managerSocketTimeout = managerSocketTimeout;
    }

    public boolean isCleanHttpCacheWhenClosing() {
        return this.cleanHttpCacheWhenClosing;
    }

    public void setCleanHttpCacheWhenClosing(boolean cleanHttpCacheWhenClosing) {
        this.cleanHttpCacheWhenClosing = cleanHttpCacheWhenClosing;
    }

    public boolean isUseGroupIdAsKey() {
        return this.useGroupIdAsKey;
    }

    public void setUseGroupIdAsKey(boolean useGroupIdAsKey) {
        this.useGroupIdAsKey = useGroupIdAsKey;
    }

    public boolean isUseStreamIdAsKey() {
        return this.useStreamIdAsKey;
    }

    public void setUseStreamIdAsKey(boolean useStreamIdAsKey) {
        this.useStreamIdAsKey = useStreamIdAsKey;
    }

    public boolean isUseLocalIpAsKey() {
        return this.useLocalIpAsKey;
    }

    public void setUseLocalIpAsKey(boolean useLocalIpAsKey) {
        this.useLocalIpAsKey = useLocalIpAsKey;
    }

    public int getMetricIntervalInMs() {
        return this.metricIntervalInMs;
    }

    public void setMetricIntervalInMs(int metricIntervalInMs) {
        this.metricIntervalInMs = metricIntervalInMs;
    }

    public String getMetricGroupId() {
        return this.metricGroupId;
    }

    public void setMetricGroupId(String metricGroupId) {
        this.metricGroupId = metricGroupId;
    }

    public long getMaxProxyCacheTimeInMs() {
        return this.maxProxyCacheTimeInMs;
    }

    public void setMaxProxyCacheTimeInMs(long maxProxyCacheTimeInMs) {
        this.maxProxyCacheTimeInMs = maxProxyCacheTimeInMs;
    }

    public int getManagerConnectionTimeout() {
        return this.managerConnectionTimeout;
    }

    public void setManagerConnectionTimeout(int managerConnectionTimeout) {
        this.managerConnectionTimeout = managerConnectionTimeout;
    }

    public boolean isEnableSlaMetric() {
        return this.enableSlaMetric;
    }

    public void setEnableSlaMetric(boolean enableSlaMetric) {
        this.enableSlaMetric = enableSlaMetric;
    }

    public int getIoThreadNum() {
        return this.ioThreadNum;
    }

    public void setIoThreadNum(int ioThreadNum) {
        this.ioThreadNum = ioThreadNum;
    }

    public boolean isEnableBusyWait() {
        return this.enableBusyWait;
    }

    public void setEnableBusyWait(boolean enableBusyWait) {
        this.enableBusyWait = enableBusyWait;
    }

    public int getVirtualNode() {
        return this.virtualNode;
    }

    public void setVirtualNode(int virtualNode) {
        this.virtualNode = virtualNode;
    }

    public LoadBalance getLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalance(LoadBalance loadBalance) {
        this.loadBalance = loadBalance;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public int getAsyncCallbackSize() {
        return this.asyncCallbackSize;
    }

    public String getAuthSecretId() {
        return this.authSecretId;
    }

    public String getAuthSecretKey() {
        return this.authSecretKey;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public void setAsyncCallbackSize(int asyncCallbackSize) {
        this.asyncCallbackSize = asyncCallbackSize;
    }

    public void setManagerPort(int managerPort) {
        this.managerPort = managerPort;
    }

    public void setManagerIP(String managerIP) {
        this.managerIP = managerIP;
    }

    public void setProxyIPServiceURL(String proxyIPServiceURL) {
        this.proxyIPServiceURL = proxyIPServiceURL;
    }

    public void setNetTag(String netTag) {
        this.netTag = netTag;
    }

    public void setLocalVisit(boolean isLocalVisit) {
        this.isLocalVisit = isLocalVisit;
    }

    public void setNeedDataEncry(boolean isNeedDataEncry) {
        this.isNeedDataEncry = isNeedDataEncry;
    }

    public void setNeedAuthentication(boolean needAuthentication) {
        this.needAuthentication = needAuthentication;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setRsaPubKeyUrl(String rsaPubKeyUrl) {
        this.rsaPubKeyUrl = rsaPubKeyUrl;
    }

    public void setNeedVerServer(boolean needVerServer) {
        this.needVerServer = needVerServer;
    }

    public void setTlsServerCertFilePathAndName(String tlsServerCertFilePathAndName) {
        this.tlsServerCertFilePathAndName = tlsServerCertFilePathAndName;
    }

    public void setTlsServerKey(String tlsServerKey) {
        this.tlsServerKey = tlsServerKey;
    }

    public void setAuthSecretId(String authSecretId) {
        this.authSecretId = authSecretId;
    }

    public void setAuthSecretKey(String authSecretKey) {
        this.authSecretKey = authSecretKey;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyClientConfig)) {
            return false;
        }
        ProxyClientConfig other = (ProxyClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAliveConnections() != other.getAliveConnections()) {
            return false;
        }
        if (this.getSyncThreadPoolSize() != other.getSyncThreadPoolSize()) {
            return false;
        }
        if (this.getAsyncCallbackSize() != other.getAsyncCallbackSize()) {
            return false;
        }
        if (this.getManagerPort() != other.getManagerPort()) {
            return false;
        }
        if (this.getProxyUpdateIntervalMinutes() != other.getProxyUpdateIntervalMinutes()) {
            return false;
        }
        if (this.getProxyUpdateMaxRetry() != other.getProxyUpdateMaxRetry()) {
            return false;
        }
        if (this.isFile() != other.isFile()) {
            return false;
        }
        if (this.isLocalVisit() != other.isLocalVisit()) {
            return false;
        }
        if (this.isNeedDataEncry() != other.isNeedDataEncry()) {
            return false;
        }
        if (this.isNeedAuthentication() != other.isNeedAuthentication()) {
            return false;
        }
        if (this.isNeedVerServer() != other.isNeedVerServer()) {
            return false;
        }
        if (this.getMaxTimeoutCnt() != other.getMaxTimeoutCnt()) {
            return false;
        }
        if (this.isEnableSaveManagerVIps() != other.isEnableSaveManagerVIps()) {
            return false;
        }
        if (this.isEnableSlaMetric() != other.isEnableSlaMetric()) {
            return false;
        }
        if (this.getManagerConnectionTimeout() != other.getManagerConnectionTimeout()) {
            return false;
        }
        if (this.isReadProxyIPFromLocal() != other.isReadProxyIPFromLocal()) {
            return false;
        }
        if (this.getConnectTimeoutMillis() != other.getConnectTimeoutMillis()) {
            return false;
        }
        if (this.getRequestTimeoutMillis() != other.getRequestTimeoutMillis()) {
            return false;
        }
        if (this.getManagerSocketTimeout() != other.getManagerSocketTimeout()) {
            return false;
        }
        if (this.isDiscardOldMessage() != other.isDiscardOldMessage()) {
            return false;
        }
        if (this.getProxyHttpUpdateIntervalMinutes() != other.getProxyHttpUpdateIntervalMinutes()) {
            return false;
        }
        if (this.getAsyncWorkerNumber() != other.getAsyncWorkerNumber()) {
            return false;
        }
        if (this.getAsyncWorkerInterval() != other.getAsyncWorkerInterval()) {
            return false;
        }
        if (this.isCleanHttpCacheWhenClosing() != other.isCleanHttpCacheWhenClosing()) {
            return false;
        }
        if (this.isUseGroupIdAsKey() != other.isUseGroupIdAsKey()) {
            return false;
        }
        if (this.isUseStreamIdAsKey() != other.isUseStreamIdAsKey()) {
            return false;
        }
        if (this.isUseLocalIpAsKey() != other.isUseLocalIpAsKey()) {
            return false;
        }
        if (this.getMetricIntervalInMs() != other.getMetricIntervalInMs()) {
            return false;
        }
        if (this.getMaxProxyCacheTimeInMs() != other.getMaxProxyCacheTimeInMs()) {
            return false;
        }
        if (this.getIoThreadNum() != other.getIoThreadNum()) {
            return false;
        }
        if (this.isEnableBusyWait() != other.isEnableBusyWait()) {
            return false;
        }
        if (this.getVirtualNode() != other.getVirtualNode()) {
            return false;
        }
        if (this.getMaxRetry() != other.getMaxRetry()) {
            return false;
        }
        String this$managerIP = this.getManagerIP();
        String other$managerIP = other.getManagerIP();
        if (this$managerIP == null ? other$managerIP != null : !this$managerIP.equals(other$managerIP)) {
            return false;
        }
        String this$managerIpLocalPath = this.getManagerIpLocalPath();
        String other$managerIpLocalPath = other.getManagerIpLocalPath();
        if (this$managerIpLocalPath == null ? other$managerIpLocalPath != null : !this$managerIpLocalPath.equals(other$managerIpLocalPath)) {
            return false;
        }
        String this$proxyIPServiceURL = this.getProxyIPServiceURL();
        String other$proxyIPServiceURL = other.getProxyIPServiceURL();
        if (this$proxyIPServiceURL == null ? other$proxyIPServiceURL != null : !this$proxyIPServiceURL.equals(other$proxyIPServiceURL)) {
            return false;
        }
        String this$netTag = this.getNetTag();
        String other$netTag = other.getNetTag();
        if (this$netTag == null ? other$netTag != null : !this$netTag.equals(other$netTag)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$rsaPubKeyUrl = this.getRsaPubKeyUrl();
        String other$rsaPubKeyUrl = other.getRsaPubKeyUrl();
        if (this$rsaPubKeyUrl == null ? other$rsaPubKeyUrl != null : !this$rsaPubKeyUrl.equals(other$rsaPubKeyUrl)) {
            return false;
        }
        String this$confStoreBasePath = this.getConfStoreBasePath();
        String other$confStoreBasePath = other.getConfStoreBasePath();
        if (this$confStoreBasePath == null ? other$confStoreBasePath != null : !this$confStoreBasePath.equals(other$confStoreBasePath)) {
            return false;
        }
        String this$tlsServerCertFilePathAndName = this.getTlsServerCertFilePathAndName();
        String other$tlsServerCertFilePathAndName = other.getTlsServerCertFilePathAndName();
        if (this$tlsServerCertFilePathAndName == null ? other$tlsServerCertFilePathAndName != null : !this$tlsServerCertFilePathAndName.equals(other$tlsServerCertFilePathAndName)) {
            return false;
        }
        String this$tlsServerKey = this.getTlsServerKey();
        String other$tlsServerKey = other.getTlsServerKey();
        if (this$tlsServerKey == null ? other$tlsServerKey != null : !this$tlsServerKey.equals(other$tlsServerKey)) {
            return false;
        }
        String this$authSecretId = this.getAuthSecretId();
        String other$authSecretId = other.getAuthSecretId();
        if (this$authSecretId == null ? other$authSecretId != null : !this$authSecretId.equals(other$authSecretId)) {
            return false;
        }
        String this$authSecretKey = this.getAuthSecretKey();
        String other$authSecretKey = other.getAuthSecretKey();
        if (this$authSecretKey == null ? other$authSecretKey != null : !this$authSecretKey.equals(other$authSecretKey)) {
            return false;
        }
        String this$protocolType = this.getProtocolType();
        String other$protocolType = other.getProtocolType();
        if (this$protocolType == null ? other$protocolType != null : !this$protocolType.equals(other$protocolType)) {
            return false;
        }
        String this$metricGroupId = this.getMetricGroupId();
        String other$metricGroupId = other.getMetricGroupId();
        if (this$metricGroupId == null ? other$metricGroupId != null : !this$metricGroupId.equals(other$metricGroupId)) {
            return false;
        }
        LoadBalance this$loadBalance = this.getLoadBalance();
        LoadBalance other$loadBalance = other.getLoadBalance();
        return !(this$loadBalance == null ? other$loadBalance != null : !((Object)((Object)this$loadBalance)).equals((Object)other$loadBalance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAliveConnections();
        result = result * 59 + this.getSyncThreadPoolSize();
        result = result * 59 + this.getAsyncCallbackSize();
        result = result * 59 + this.getManagerPort();
        result = result * 59 + this.getProxyUpdateIntervalMinutes();
        result = result * 59 + this.getProxyUpdateMaxRetry();
        result = result * 59 + (this.isFile() ? 79 : 97);
        result = result * 59 + (this.isLocalVisit() ? 79 : 97);
        result = result * 59 + (this.isNeedDataEncry() ? 79 : 97);
        result = result * 59 + (this.isNeedAuthentication() ? 79 : 97);
        result = result * 59 + (this.isNeedVerServer() ? 79 : 97);
        result = result * 59 + this.getMaxTimeoutCnt();
        result = result * 59 + (this.isEnableSaveManagerVIps() ? 79 : 97);
        result = result * 59 + (this.isEnableSlaMetric() ? 79 : 97);
        result = result * 59 + this.getManagerConnectionTimeout();
        result = result * 59 + (this.isReadProxyIPFromLocal() ? 79 : 97);
        long $connectTimeoutMillis = this.getConnectTimeoutMillis();
        result = result * 59 + (int)($connectTimeoutMillis >>> 32 ^ $connectTimeoutMillis);
        long $requestTimeoutMillis = this.getRequestTimeoutMillis();
        result = result * 59 + (int)($requestTimeoutMillis >>> 32 ^ $requestTimeoutMillis);
        result = result * 59 + this.getManagerSocketTimeout();
        result = result * 59 + (this.isDiscardOldMessage() ? 79 : 97);
        result = result * 59 + this.getProxyHttpUpdateIntervalMinutes();
        result = result * 59 + this.getAsyncWorkerNumber();
        result = result * 59 + this.getAsyncWorkerInterval();
        result = result * 59 + (this.isCleanHttpCacheWhenClosing() ? 79 : 97);
        result = result * 59 + (this.isUseGroupIdAsKey() ? 79 : 97);
        result = result * 59 + (this.isUseStreamIdAsKey() ? 79 : 97);
        result = result * 59 + (this.isUseLocalIpAsKey() ? 79 : 97);
        result = result * 59 + this.getMetricIntervalInMs();
        long $maxProxyCacheTimeInMs = this.getMaxProxyCacheTimeInMs();
        result = result * 59 + (int)($maxProxyCacheTimeInMs >>> 32 ^ $maxProxyCacheTimeInMs);
        result = result * 59 + this.getIoThreadNum();
        result = result * 59 + (this.isEnableBusyWait() ? 79 : 97);
        result = result * 59 + this.getVirtualNode();
        result = result * 59 + this.getMaxRetry();
        String $managerIP = this.getManagerIP();
        result = result * 59 + ($managerIP == null ? 43 : $managerIP.hashCode());
        String $managerIpLocalPath = this.getManagerIpLocalPath();
        result = result * 59 + ($managerIpLocalPath == null ? 43 : $managerIpLocalPath.hashCode());
        String $proxyIPServiceURL = this.getProxyIPServiceURL();
        result = result * 59 + ($proxyIPServiceURL == null ? 43 : $proxyIPServiceURL.hashCode());
        String $netTag = this.getNetTag();
        result = result * 59 + ($netTag == null ? 43 : $netTag.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $rsaPubKeyUrl = this.getRsaPubKeyUrl();
        result = result * 59 + ($rsaPubKeyUrl == null ? 43 : $rsaPubKeyUrl.hashCode());
        String $confStoreBasePath = this.getConfStoreBasePath();
        result = result * 59 + ($confStoreBasePath == null ? 43 : $confStoreBasePath.hashCode());
        String $tlsServerCertFilePathAndName = this.getTlsServerCertFilePathAndName();
        result = result * 59 + ($tlsServerCertFilePathAndName == null ? 43 : $tlsServerCertFilePathAndName.hashCode());
        String $tlsServerKey = this.getTlsServerKey();
        result = result * 59 + ($tlsServerKey == null ? 43 : $tlsServerKey.hashCode());
        String $authSecretId = this.getAuthSecretId();
        result = result * 59 + ($authSecretId == null ? 43 : $authSecretId.hashCode());
        String $authSecretKey = this.getAuthSecretKey();
        result = result * 59 + ($authSecretKey == null ? 43 : $authSecretKey.hashCode());
        String $protocolType = this.getProtocolType();
        result = result * 59 + ($protocolType == null ? 43 : $protocolType.hashCode());
        String $metricGroupId = this.getMetricGroupId();
        result = result * 59 + ($metricGroupId == null ? 43 : $metricGroupId.hashCode());
        LoadBalance $loadBalance = this.getLoadBalance();
        result = result * 59 + ($loadBalance == null ? 43 : ((Object)((Object)$loadBalance)).hashCode());
        return result;
    }

    public String toString() {
        return "ProxyClientConfig(aliveConnections=" + this.getAliveConnections() + ", syncThreadPoolSize=" + this.getSyncThreadPoolSize() + ", asyncCallbackSize=" + this.getAsyncCallbackSize() + ", managerPort=" + this.getManagerPort() + ", managerIP=" + this.getManagerIP() + ", managerIpLocalPath=" + this.getManagerIpLocalPath() + ", proxyIPServiceURL=" + this.getProxyIPServiceURL() + ", proxyUpdateIntervalMinutes=" + this.getProxyUpdateIntervalMinutes() + ", proxyUpdateMaxRetry=" + this.getProxyUpdateMaxRetry() + ", netTag=" + this.getNetTag() + ", groupId=" + this.getGroupId() + ", isFile=" + this.isFile() + ", isLocalVisit=" + this.isLocalVisit() + ", isNeedDataEncry=" + this.isNeedDataEncry() + ", needAuthentication=" + this.isNeedAuthentication() + ", userName=" + this.getUserName() + ", secretKey=" + this.getSecretKey() + ", rsaPubKeyUrl=" + this.getRsaPubKeyUrl() + ", confStoreBasePath=" + this.getConfStoreBasePath() + ", needVerServer=" + this.isNeedVerServer() + ", tlsServerCertFilePathAndName=" + this.getTlsServerCertFilePathAndName() + ", tlsServerKey=" + this.getTlsServerKey() + ", maxTimeoutCnt=" + this.getMaxTimeoutCnt() + ", authSecretId=" + this.getAuthSecretId() + ", authSecretKey=" + this.getAuthSecretKey() + ", protocolType=" + this.getProtocolType() + ", enableSaveManagerVIps=" + this.isEnableSaveManagerVIps() + ", enableSlaMetric=" + this.isEnableSlaMetric() + ", managerConnectionTimeout=" + this.getManagerConnectionTimeout() + ", readProxyIPFromLocal=" + this.isReadProxyIPFromLocal() + ", connectTimeoutMillis=" + this.getConnectTimeoutMillis() + ", requestTimeoutMillis=" + this.getRequestTimeoutMillis() + ", managerSocketTimeout=" + this.getManagerSocketTimeout() + ", discardOldMessage=" + this.isDiscardOldMessage() + ", proxyHttpUpdateIntervalMinutes=" + this.getProxyHttpUpdateIntervalMinutes() + ", asyncWorkerNumber=" + this.getAsyncWorkerNumber() + ", asyncWorkerInterval=" + this.getAsyncWorkerInterval() + ", cleanHttpCacheWhenClosing=" + this.isCleanHttpCacheWhenClosing() + ", useGroupIdAsKey=" + this.isUseGroupIdAsKey() + ", useStreamIdAsKey=" + this.isUseStreamIdAsKey() + ", useLocalIpAsKey=" + this.isUseLocalIpAsKey() + ", metricIntervalInMs=" + this.getMetricIntervalInMs() + ", maxProxyCacheTimeInMs=" + this.getMaxProxyCacheTimeInMs() + ", metricGroupId=" + this.getMetricGroupId() + ", ioThreadNum=" + this.getIoThreadNum() + ", enableBusyWait=" + this.isEnableBusyWait() + ", virtualNode=" + this.getVirtualNode() + ", loadBalance=" + (Object)((Object)this.getLoadBalance()) + ", maxRetry=" + this.getMaxRetry() + ")";
    }
}

