/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.common.util.MessageUtils;
import org.apache.inlong.sdk.dataproxy.FileCallback;
import org.apache.inlong.sdk.dataproxy.MessageSender;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.SendMessageCallback;
import org.apache.inlong.sdk.dataproxy.SendResult;
import org.apache.inlong.sdk.dataproxy.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigEntry;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigManager;
import org.apache.inlong.sdk.dataproxy.network.ProxysdkException;
import org.apache.inlong.sdk.dataproxy.network.Sender;
import org.apache.inlong.sdk.dataproxy.network.SequentialID;
import org.apache.inlong.sdk.dataproxy.network.Utils;
import org.apache.inlong.sdk.dataproxy.threads.IndexCollectThread;
import org.apache.inlong.sdk.dataproxy.threads.ManagerFetcherThread;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageSender
implements MessageSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageSender.class);
    private static final long DEFAULT_SEND_TIMEOUT = 100L;
    private static final TimeUnit DEFAULT_SEND_TIMEUNIT = TimeUnit.MILLISECONDS;
    private static final ConcurrentHashMap<Integer, DefaultMessageSender> CACHE_SENDER = new ConcurrentHashMap();
    private static final AtomicBoolean MANAGER_FETCHER_THREAD_STARTED = new AtomicBoolean(false);
    private static ManagerFetcherThread managerFetcherThread;
    private static final SequentialID idGenerator;
    private final Sender sender;
    private final IndexCollectThread indexCol;
    private final Map<String, Long> storeIndex = new ConcurrentHashMap<String, Long>();
    private String groupId;
    private int msgtype = 7;
    private boolean isCompress = true;
    private boolean isGroupIdTransfer = false;
    private boolean isReport = false;
    private boolean isSupportLF = false;
    private int cpsSize = 120;

    public DefaultMessageSender(ProxyClientConfig configure) throws Exception {
        this(configure, null);
    }

    public DefaultMessageSender(ProxyClientConfig configure, ThreadFactory selfDefineFactory) throws Exception {
        ProxyUtils.validClientConfig(configure);
        this.sender = new Sender(configure, selfDefineFactory);
        this.groupId = configure.getGroupId();
        this.indexCol = new IndexCollectThread(this.storeIndex);
        this.indexCol.start();
        if (configure.isEnableSaveManagerVIps() && configure.isLocalVisit() && MANAGER_FETCHER_THREAD_STARTED.compareAndSet(false, true)) {
            managerFetcherThread = new ManagerFetcherThread(configure);
            managerFetcherThread.start();
        }
    }

    public static DefaultMessageSender generateSenderByClusterId(ProxyClientConfig configure) throws Exception {
        return DefaultMessageSender.generateSenderByClusterId(configure, null);
    }

    public static DefaultMessageSender generateSenderByClusterId(ProxyClientConfig configure, ThreadFactory selfDefineFactory) throws Exception {
        if (!"TCP".equals(configure.getProtocolType())) {
            configure.setProtocolType("TCP");
        }
        LOGGER.info("Initial tcp sender, configure is {}", (Object)configure);
        ProxyConfigManager proxyConfigManager = new ProxyConfigManager(configure, Utils.getLocalIp(), null);
        proxyConfigManager.setGroupId(configure.getGroupId());
        ProxyConfigEntry entry = proxyConfigManager.getGroupIdConfigure();
        DefaultMessageSender sender = CACHE_SENDER.get(entry.getClusterId());
        if (sender != null) {
            return sender;
        }
        DefaultMessageSender tmpMessageSender = new DefaultMessageSender(configure, selfDefineFactory);
        CACHE_SENDER.put(entry.getClusterId(), tmpMessageSender);
        return tmpMessageSender;
    }

    public static void finallyCleanup() {
        for (DefaultMessageSender sender : CACHE_SENDER.values()) {
            sender.close();
        }
        CACHE_SENDER.clear();
    }

    public boolean isSupportLF() {
        return this.isSupportLF;
    }

    public void setSupportLF(boolean supportLF) {
        this.isSupportLF = supportLF;
    }

    public boolean isGroupIdTransfer() {
        return this.isGroupIdTransfer;
    }

    public void setGroupIdTransfer(boolean isGroupIdTransfer) {
        this.isGroupIdTransfer = isGroupIdTransfer;
    }

    public boolean isReport() {
        return this.isReport;
    }

    public void setReport(boolean isReport) {
        this.isReport = isReport;
    }

    public int getCpsSize() {
        return this.cpsSize;
    }

    public void setCpsSize(int cpsSize) {
        this.cpsSize = cpsSize;
    }

    public int getMsgtype() {
        return this.msgtype;
    }

    public void setMsgtype(int msgtype) {
        this.msgtype = msgtype;
    }

    public boolean isCompress() {
        return this.isCompress;
    }

    public void setCompress(boolean isCompress) {
        this.isCompress = isCompress;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getSDKVersion() {
        return "1.2.11";
    }

    @Override
    @Deprecated
    public SendResult sendMessage(byte[] body, String attributes, String msgUUID, long timeout, TimeUnit timeUnit) {
        return this.sender.syncSendMessage(new EncodeObject(body, attributes, idGenerator.getNextId()), msgUUID, timeout, timeUnit);
    }

    @Override
    public SendResult sendMessage(byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit) {
        return this.sendMessage(body, groupId, streamId, dt, msgUUID, timeout, timeUnit, false);
    }

    public SendResult sendMessage(byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, boolean isProxySend) {
        boolean isCompressEnd;
        dt = ProxyUtils.covertZeroDt(dt);
        if (!ProxyUtils.isBodyValid(body) || !ProxyUtils.isDtValid(dt)) {
            return SendResult.INVALID_ATTRIBUTES;
        }
        this.addIndexCnt(groupId, streamId, 1L);
        String proxySend = "";
        if (isProxySend) {
            proxySend = "proxySend=true";
        }
        boolean bl = isCompressEnd = this.isCompress && body.length > this.cpsSize;
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(body, this.msgtype, isCompressEnd, this.isReport, this.isGroupIdTransfer, dt / 1000L, idGenerator.getNextInt(), groupId, streamId, proxySend);
            encodeObject.setSupportLF(this.isSupportLF);
            return this.sender.syncSendMessage(encodeObject, msgUUID, timeout, timeUnit);
        }
        if (this.msgtype == 3 || this.msgtype == 5) {
            if (isProxySend) {
                proxySend = "&" + proxySend;
            }
            if (isCompressEnd) {
                return this.sender.syncSendMessage(new EncodeObject(body, "groupId=" + groupId + "&streamId=" + streamId + "&dt=" + dt + "&cp=snappy" + proxySend, idGenerator.getNextId(), this.getMsgtype(), true, groupId), msgUUID, timeout, timeUnit);
            }
            return this.sender.syncSendMessage(new EncodeObject(body, "groupId=" + groupId + "&streamId=" + streamId + "&dt=" + dt + proxySend, idGenerator.getNextId(), this.getMsgtype(), false, groupId), msgUUID, timeout, timeUnit);
        }
        return null;
    }

    @Override
    public SendResult sendMessage(byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap) {
        return this.sendMessage(body, groupId, streamId, dt, msgUUID, timeout, timeUnit, extraAttrMap, false);
    }

    public SendResult sendMessage(byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap, boolean isProxySend) {
        boolean isCompressEnd;
        dt = ProxyUtils.covertZeroDt(dt);
        if (!(ProxyUtils.isBodyValid(body) && ProxyUtils.isDtValid(dt) && ProxyUtils.isAttrKeysValid(extraAttrMap))) {
            return SendResult.INVALID_ATTRIBUTES;
        }
        this.addIndexCnt(groupId, streamId, 1L);
        if (isProxySend) {
            extraAttrMap.put("proxySend", "true");
        }
        StringBuilder attrs = MessageUtils.convertAttrToStr(extraAttrMap);
        boolean bl = isCompressEnd = this.isCompress && body.length > this.cpsSize;
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(body, this.msgtype, isCompressEnd, this.isReport, this.isGroupIdTransfer, dt / 1000L, idGenerator.getNextInt(), groupId, streamId, attrs.toString());
            encodeObject.setSupportLF(this.isSupportLF);
            return this.sender.syncSendMessage(encodeObject, msgUUID, timeout, timeUnit);
        }
        if (this.msgtype == 3 || this.msgtype == 5) {
            attrs.append("&groupId=").append(groupId).append("&streamId=").append(streamId).append("&dt=").append(dt);
            if (isCompressEnd) {
                attrs.append("&cp=snappy");
                return this.sender.syncSendMessage(new EncodeObject(body, attrs.toString(), idGenerator.getNextId(), this.getMsgtype(), true, groupId), msgUUID, timeout, timeUnit);
            }
            return this.sender.syncSendMessage(new EncodeObject(body, attrs.toString(), idGenerator.getNextId(), this.getMsgtype(), false, groupId), msgUUID, timeout, timeUnit);
        }
        return null;
    }

    @Override
    public SendResult sendMessage(List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit) {
        return this.sendMessage(bodyList, groupId, streamId, dt, msgUUID, timeout, timeUnit, false);
    }

    public SendResult sendMessage(List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, boolean isProxySend) {
        dt = ProxyUtils.covertZeroDt(dt);
        if (!ProxyUtils.isBodyValid(bodyList) || !ProxyUtils.isDtValid(dt)) {
            return SendResult.INVALID_ATTRIBUTES;
        }
        this.addIndexCnt(groupId, streamId, bodyList.size());
        String proxySend = "";
        if (isProxySend) {
            proxySend = "syncSend=true";
        }
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(bodyList, this.msgtype, this.isCompress, this.isReport, this.isGroupIdTransfer, dt / 1000L, idGenerator.getNextInt(), groupId, streamId, proxySend);
            encodeObject.setSupportLF(this.isSupportLF);
            return this.sender.syncSendMessage(encodeObject, msgUUID, timeout, timeUnit);
        }
        if (this.msgtype == 3 || this.msgtype == 5) {
            if (isProxySend) {
                proxySend = "&" + proxySend;
            }
            if (this.isCompress) {
                return this.sender.syncSendMessage(new EncodeObject(bodyList, "groupId=" + groupId + "&streamId=" + streamId + "&dt=" + dt + "&cp=snappy&cnt=" + bodyList.size() + proxySend, idGenerator.getNextId(), this.getMsgtype(), true, groupId), msgUUID, timeout, timeUnit);
            }
            return this.sender.syncSendMessage(new EncodeObject(bodyList, "groupId=" + groupId + "&streamId=" + streamId + "&dt=" + dt + "&cnt=" + bodyList.size() + proxySend, idGenerator.getNextId(), this.getMsgtype(), false, groupId), msgUUID, timeout, timeUnit);
        }
        return null;
    }

    @Override
    public SendResult sendMessage(List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap) {
        return this.sendMessage(bodyList, groupId, streamId, dt, msgUUID, timeout, timeUnit, extraAttrMap, false);
    }

    public SendResult sendMessage(List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap, boolean isProxySend) {
        dt = ProxyUtils.covertZeroDt(dt);
        if (!(ProxyUtils.isBodyValid(bodyList) && ProxyUtils.isDtValid(dt) && ProxyUtils.isAttrKeysValid(extraAttrMap))) {
            return SendResult.INVALID_ATTRIBUTES;
        }
        this.addIndexCnt(groupId, streamId, bodyList.size());
        if (isProxySend) {
            extraAttrMap.put("proxySend", "true");
        }
        StringBuilder attrs = MessageUtils.convertAttrToStr(extraAttrMap);
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(bodyList, this.msgtype, this.isCompress, this.isReport, this.isGroupIdTransfer, dt / 1000L, idGenerator.getNextInt(), groupId, streamId, attrs.toString());
            encodeObject.setSupportLF(this.isSupportLF);
            return this.sender.syncSendMessage(encodeObject, msgUUID, timeout, timeUnit);
        }
        if (this.msgtype == 3 || this.msgtype == 5) {
            attrs.append("&groupId=").append(groupId).append("&streamId=").append(streamId).append("&dt=").append(dt).append("&cnt=").append(bodyList.size());
            if (this.isCompress) {
                attrs.append("&cp=snappy");
                return this.sender.syncSendMessage(new EncodeObject(bodyList, attrs.toString(), idGenerator.getNextId(), this.getMsgtype(), true, groupId), msgUUID, timeout, timeUnit);
            }
            return this.sender.syncSendMessage(new EncodeObject(bodyList, attrs.toString(), idGenerator.getNextId(), this.getMsgtype(), false, groupId), msgUUID, timeout, timeUnit);
        }
        return null;
    }

    @Override
    @Deprecated
    public void asyncSendMessage(SendMessageCallback callback, byte[] body, String attributes, String msgUUID, long timeout, TimeUnit timeUnit) throws ProxysdkException {
        this.sender.asyncSendMessage(new EncodeObject(body, attributes, idGenerator.getNextId()), callback, msgUUID, timeout, timeUnit);
    }

    @Override
    public void asyncSendMessage(SendMessageCallback callback, byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit) throws ProxysdkException {
        this.asyncSendMessage(callback, body, groupId, streamId, dt, msgUUID, timeout, timeUnit, false);
    }

    public void asyncSendMessage(SendMessageCallback callback, byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, boolean isProxySend) throws ProxysdkException {
        boolean isCompressEnd;
        dt = ProxyUtils.covertZeroDt(dt);
        if (!ProxyUtils.isBodyValid(body) || !ProxyUtils.isDtValid(dt)) {
            throw new ProxysdkException(SendResult.INVALID_ATTRIBUTES.toString());
        }
        this.addIndexCnt(groupId, streamId, 1L);
        String proxySend = "";
        if (isProxySend) {
            proxySend = "proxySend=true";
        }
        boolean bl = isCompressEnd = this.isCompress && body.length > this.cpsSize;
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(body, this.getMsgtype(), isCompressEnd, this.isReport, this.isGroupIdTransfer, dt / 1000L, idGenerator.getNextInt(), groupId, streamId, proxySend);
            encodeObject.setSupportLF(this.isSupportLF);
            this.sender.asyncSendMessage(encodeObject, callback, msgUUID, timeout, timeUnit);
        } else if (this.msgtype == 3 || this.msgtype == 5) {
            if (isCompressEnd) {
                if (isProxySend) {
                    proxySend = "&" + proxySend;
                }
                this.sender.asyncSendMessage(new EncodeObject(body, "groupId=" + groupId + "&streamId=" + streamId + "&dt=" + dt + "&cp=snappy" + proxySend, idGenerator.getNextId(), this.getMsgtype(), true, groupId), callback, msgUUID, timeout, timeUnit);
            } else {
                this.sender.asyncSendMessage(new EncodeObject(body, "groupId=" + groupId + "&streamId=" + streamId + "&dt=" + dt + proxySend, idGenerator.getNextId(), this.getMsgtype(), false, groupId), callback, msgUUID, timeout, timeUnit);
            }
        }
    }

    @Override
    public void asyncSendMessage(SendMessageCallback callback, byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap) throws ProxysdkException {
        this.asyncSendMessage(callback, body, groupId, streamId, dt, msgUUID, timeout, timeUnit, extraAttrMap, false);
    }

    public void asyncSendMessage(SendMessageCallback callback, byte[] body, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap, boolean isProxySend) throws ProxysdkException {
        boolean isCompressEnd;
        dt = ProxyUtils.covertZeroDt(dt);
        if (!(ProxyUtils.isBodyValid(body) && ProxyUtils.isDtValid(dt) && ProxyUtils.isAttrKeysValid(extraAttrMap))) {
            throw new ProxysdkException(SendResult.INVALID_ATTRIBUTES.toString());
        }
        this.addIndexCnt(groupId, streamId, 1L);
        if (isProxySend) {
            extraAttrMap.put("proxySend", "true");
        }
        StringBuilder attrs = MessageUtils.convertAttrToStr(extraAttrMap);
        boolean bl = isCompressEnd = this.isCompress && body.length > this.cpsSize;
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(body, this.getMsgtype(), isCompressEnd, this.isReport, this.isGroupIdTransfer, dt / 1000L, idGenerator.getNextInt(), groupId, streamId, attrs.toString());
            encodeObject.setSupportLF(this.isSupportLF);
            this.sender.asyncSendMessage(encodeObject, callback, msgUUID, timeout, timeUnit);
        } else if (this.msgtype == 3 || this.msgtype == 5) {
            attrs.append("&groupId=").append(groupId).append("&streamId=").append(streamId).append("&dt=").append(dt);
            if (isCompressEnd) {
                attrs.append("&cp=snappy");
                this.sender.asyncSendMessage(new EncodeObject(body, attrs.toString(), idGenerator.getNextId(), this.getMsgtype(), true, groupId), callback, msgUUID, timeout, timeUnit);
            } else {
                this.sender.asyncSendMessage(new EncodeObject(body, attrs.toString(), idGenerator.getNextId(), this.getMsgtype(), false, groupId), callback, msgUUID, timeout, timeUnit);
            }
        }
    }

    @Override
    public void asyncSendMessage(SendMessageCallback callback, List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit) throws ProxysdkException {
        this.asyncSendMessage(callback, bodyList, groupId, streamId, dt, msgUUID, timeout, timeUnit, false);
    }

    public void asyncSendMessage(SendMessageCallback callback, List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, boolean isProxySend) throws ProxysdkException {
        dt = ProxyUtils.covertZeroDt(dt);
        if (!ProxyUtils.isBodyValid(bodyList) || !ProxyUtils.isDtValid(dt)) {
            throw new ProxysdkException(SendResult.INVALID_ATTRIBUTES.toString());
        }
        this.addIndexCnt(groupId, streamId, bodyList.size());
        String proxySend = "";
        if (isProxySend) {
            proxySend = "proxySend=true";
        }
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(bodyList, this.getMsgtype(), this.isCompress, this.isReport, this.isGroupIdTransfer, dt / 1000L, idGenerator.getNextInt(), groupId, streamId, proxySend);
            encodeObject.setSupportLF(this.isSupportLF);
            this.sender.asyncSendMessage(encodeObject, callback, msgUUID, timeout, timeUnit);
        } else if (this.msgtype == 3 || this.msgtype == 5) {
            if (isProxySend) {
                proxySend = "&" + proxySend;
            }
            if (this.isCompress) {
                this.sender.asyncSendMessage(new EncodeObject(bodyList, "groupId=" + groupId + "&streamId=" + streamId + "&dt=" + dt + "&cp=snappy&cnt=" + bodyList.size() + proxySend, idGenerator.getNextId(), this.getMsgtype(), true, groupId), callback, msgUUID, timeout, timeUnit);
            } else {
                this.sender.asyncSendMessage(new EncodeObject(bodyList, "groupId=" + groupId + "&streamId=" + streamId + "&dt=" + dt + "&cnt=" + bodyList.size() + proxySend, idGenerator.getNextId(), this.getMsgtype(), false, groupId), callback, msgUUID, timeout, timeUnit);
            }
        }
    }

    @Override
    public void asyncSendMessage(SendMessageCallback callback, List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap) throws ProxysdkException {
        this.asyncSendMessage(callback, bodyList, groupId, streamId, dt, msgUUID, timeout, timeUnit, extraAttrMap, false);
    }

    public void asyncSendMessage(SendMessageCallback callback, List<byte[]> bodyList, String groupId, String streamId, long dt, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap, boolean isProxySend) throws ProxysdkException {
        dt = ProxyUtils.covertZeroDt(dt);
        if (!(ProxyUtils.isBodyValid(bodyList) && ProxyUtils.isDtValid(dt) && ProxyUtils.isAttrKeysValid(extraAttrMap))) {
            throw new ProxysdkException(SendResult.INVALID_ATTRIBUTES.toString());
        }
        this.addIndexCnt(groupId, streamId, bodyList.size());
        if (isProxySend) {
            extraAttrMap.put("proxySend", "true");
        }
        StringBuilder attrs = MessageUtils.convertAttrToStr(extraAttrMap);
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(bodyList, this.getMsgtype(), this.isCompress, this.isReport, this.isGroupIdTransfer, dt / 1000L, idGenerator.getNextInt(), groupId, streamId, attrs.toString());
            encodeObject.setSupportLF(this.isSupportLF);
            this.sender.asyncSendMessage(encodeObject, callback, msgUUID, timeout, timeUnit);
        } else if (this.msgtype == 3 || this.msgtype == 5) {
            attrs.append("&groupId=").append(groupId).append("&streamId=").append(streamId).append("&dt=").append(dt).append("&cnt=").append(bodyList.size());
            if (this.isCompress) {
                attrs.append("&cp=snappy");
                this.sender.asyncSendMessage(new EncodeObject(bodyList, attrs.toString(), idGenerator.getNextId(), this.getMsgtype(), true, groupId), callback, msgUUID, timeout, timeUnit);
            } else {
                this.sender.asyncSendMessage(new EncodeObject(bodyList, attrs.toString(), idGenerator.getNextId(), this.getMsgtype(), false, groupId), callback, msgUUID, timeout, timeUnit);
            }
        }
    }

    @Override
    public void asyncSendMessage(String inlongGroupId, String inlongStreamId, byte[] body, SendMessageCallback callback) throws ProxysdkException {
        this.asyncSendMessage(callback, body, inlongGroupId, inlongStreamId, System.currentTimeMillis(), idGenerator.getNextId(), 100L, DEFAULT_SEND_TIMEUNIT);
    }

    public void asyncSendMessage(String inlongGroupId, String inlongStreamId, byte[] body, SendMessageCallback callback, boolean isProxySend) throws ProxysdkException {
        this.asyncSendMessage(callback, body, inlongGroupId, inlongStreamId, System.currentTimeMillis(), idGenerator.getNextId(), 100L, DEFAULT_SEND_TIMEUNIT, isProxySend);
    }

    @Override
    public void asyncSendMessage(String inlongGroupId, String inlongStreamId, List<byte[]> bodyList, SendMessageCallback callback) throws ProxysdkException {
        this.asyncSendMessage(callback, bodyList, inlongGroupId, inlongStreamId, System.currentTimeMillis(), idGenerator.getNextId(), 100L, DEFAULT_SEND_TIMEUNIT);
    }

    public void asyncSendMessage(String inlongGroupId, String inlongStreamId, List<byte[]> bodyList, SendMessageCallback callback, boolean isProxySend) throws ProxysdkException {
        this.asyncSendMessage(callback, bodyList, inlongGroupId, inlongStreamId, System.currentTimeMillis(), idGenerator.getNextId(), 100L, DEFAULT_SEND_TIMEUNIT, isProxySend);
    }

    private void addIndexCnt(String groupId, String streamId, long cnt) {
        try {
            String key = groupId + "|" + streamId;
            if (this.storeIndex.containsKey(key)) {
                long sum = this.storeIndex.get(key);
                this.storeIndex.put(key, sum + cnt);
            } else {
                this.storeIndex.put(key, cnt);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    @Deprecated
    public void asyncsendMessageData(FileCallback callback, List<byte[]> bodyList, String groupId, String streamId, long dt, int sid, boolean isSupportLF, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap) throws ProxysdkException {
        dt = ProxyUtils.covertZeroDt(dt);
        if (!(ProxyUtils.isBodyValid(bodyList) && ProxyUtils.isDtValid(dt) && ProxyUtils.isAttrKeysValid(extraAttrMap))) {
            throw new ProxysdkException(SendResult.INVALID_ATTRIBUTES.toString());
        }
        this.addIndexCnt(groupId, streamId, bodyList.size());
        StringBuilder attrs = MessageUtils.convertAttrToStr(extraAttrMap);
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(bodyList, this.msgtype, this.isCompress, this.isReport, this.isGroupIdTransfer, dt / 1000L, (long)sid, groupId, streamId, attrs.toString(), "data", "");
            encodeObject.setSupportLF(isSupportLF);
            this.sender.asyncSendMessageIndex(encodeObject, callback, msgUUID, timeout, timeUnit);
        }
    }

    @Deprecated
    private void asyncSendMetric(FileCallback callback, byte[] body, String groupId, String streamId, long dt, int sid, String ip, String msgUUID, long timeout, TimeUnit timeUnit, String messageKey) throws ProxysdkException {
        dt = ProxyUtils.covertZeroDt(dt);
        if (!ProxyUtils.isBodyValid(body) || !ProxyUtils.isDtValid(dt)) {
            throw new ProxysdkException(SendResult.INVALID_ATTRIBUTES.toString());
        }
        boolean isCompressEnd = false;
        if (this.msgtype == 7 || this.msgtype == 8) {
            this.sender.asyncSendMessageIndex(new EncodeObject(body, this.msgtype, isCompressEnd, this.isReport, this.isGroupIdTransfer, dt / 1000L, (long)sid, groupId, streamId, "", messageKey, ip), callback, msgUUID, timeout, timeUnit);
        }
    }

    @Deprecated
    public void asyncsendMessageProxy(FileCallback callback, byte[] body, String groupId, String streamId, long dt, int sid, String ip, String msgUUID, long timeout, TimeUnit timeUnit) throws ProxysdkException {
        this.asyncSendMetric(callback, body, groupId, streamId, dt, sid, ip, msgUUID, timeout, timeUnit, "minute");
    }

    @Deprecated
    public void asyncsendMessageFile(FileCallback callback, byte[] body, String groupId, String streamId, long dt, int sid, String msgUUID, long timeout, TimeUnit timeUnit) throws ProxysdkException {
        this.asyncSendMetric(callback, body, groupId, streamId, dt, sid, "", msgUUID, timeout, timeUnit, "file");
    }

    @Deprecated
    public String sendMessageData(List<byte[]> bodyList, String groupId, String streamId, long dt, int sid, boolean isSupportLF, String msgUUID, long timeout, TimeUnit timeUnit, Map<String, String> extraAttrMap) {
        dt = ProxyUtils.covertZeroDt(dt);
        if (!(ProxyUtils.isBodyValid(bodyList) && ProxyUtils.isDtValid(dt) && ProxyUtils.isAttrKeysValid(extraAttrMap))) {
            return SendResult.INVALID_ATTRIBUTES.toString();
        }
        this.addIndexCnt(groupId, streamId, bodyList.size());
        StringBuilder attrs = MessageUtils.convertAttrToStr(extraAttrMap);
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(bodyList, this.msgtype, this.isCompress, this.isReport, this.isGroupIdTransfer, dt / 1000L, (long)sid, groupId, streamId, attrs.toString(), "data", "");
            encodeObject.setSupportLF(isSupportLF);
            return this.sender.syncSendMessageIndex(encodeObject, msgUUID, timeout, timeUnit);
        }
        return null;
    }

    @Deprecated
    private String sendMetric(byte[] body, String groupId, String streamId, long dt, int sid, String ip, String msgUUID, long timeout, TimeUnit timeUnit, String messageKey) {
        dt = ProxyUtils.covertZeroDt(dt);
        if (!ProxyUtils.isBodyValid(body) || !ProxyUtils.isDtValid(dt)) {
            return SendResult.INVALID_ATTRIBUTES.toString();
        }
        if (this.msgtype == 7 || this.msgtype == 8) {
            EncodeObject encodeObject = new EncodeObject(body, this.msgtype, false, this.isReport, this.isGroupIdTransfer, dt / 1000L, (long)sid, groupId, streamId, "", messageKey, ip);
            return this.sender.syncSendMessageIndex(encodeObject, msgUUID, timeout, timeUnit);
        }
        return null;
    }

    @Deprecated
    public String sendMessageProxy(byte[] body, String groupId, String streamId, long dt, int sid, String ip, String msgUUID, long timeout, TimeUnit timeUnit) {
        return this.sendMetric(body, groupId, streamId, dt, sid, ip, msgUUID, timeout, timeUnit, "minute");
    }

    @Deprecated
    public String sendMessageFile(byte[] body, String groupId, String streamId, long dt, int sid, String msgUUID, long timeout, TimeUnit timeUnit) {
        return this.sendMetric(body, groupId, streamId, dt, sid, "", msgUUID, timeout, timeUnit, "file");
    }

    private void shutdownInternalThreads() {
        this.indexCol.shutDown();
        managerFetcherThread.shutdown();
        MANAGER_FETCHER_THREAD_STARTED.set(false);
    }

    @Override
    public void close() {
        LOGGER.info("ready to close resources, may need five minutes !");
        if (this.sender.getClusterId() != -1) {
            CACHE_SENDER.remove(this.sender.getClusterId());
        }
        this.sender.close();
        this.shutdownInternalThreads();
    }

    static {
        idGenerator = new SequentialID(Utils.getLocalIp());
    }
}

