/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flume.Event;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.enums.DataProxyMsgEncType;
import org.apache.inlong.common.monitor.LogCounter;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.common.util.NetworkUtils;
import org.apache.inlong.dataproxy.base.SinkRspEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtils {
    private static final LogCounter logCounter = new LogCounter(10, 100000, 30000);
    private static final Logger logger = LoggerFactory.getLogger(MessageUtils.class);

    public static boolean isSyncSendForOrder(Event event) {
        String syncSend = (String)event.getHeaders().get("syncSend");
        return StringUtils.isNotEmpty((CharSequence)syncSend) && "true".equalsIgnoreCase(syncSend);
    }

    public static boolean isSinkRspType(Event event) {
        return MessageUtils.isSinkRspType(event.getHeaders());
    }

    public static boolean isSinkRspType(Map<String, String> attrMap) {
        String proxySend = attrMap.get("proxySend");
        String syncSend = attrMap.get("syncSend");
        return StringUtils.isNotEmpty((CharSequence)proxySend) && "true".equalsIgnoreCase(proxySend) || StringUtils.isNotEmpty((CharSequence)syncSend) && "true".equalsIgnoreCase(syncSend);
    }

    public static Pair<Boolean, String> getEventProcType(Event event) {
        String syncSend = (String)event.getHeaders().get("syncSend");
        String proxySend = (String)event.getHeaders().get("proxySend");
        return MessageUtils.getEventProcType(syncSend, proxySend);
    }

    public static Pair<Boolean, String> getEventProcType(String syncSend, String proxySend) {
        boolean isOrderOrProxy = false;
        String msgProcType = "b2b";
        if (StringUtils.isNotEmpty((CharSequence)syncSend) && "true".equalsIgnoreCase(syncSend)) {
            isOrderOrProxy = true;
            msgProcType = "order";
        }
        if (StringUtils.isNotEmpty((CharSequence)proxySend) && "true".equalsIgnoreCase(proxySend)) {
            isOrderOrProxy = true;
            msgProcType = "proxy";
        }
        return Pair.of((Object)isOrderOrProxy, (Object)msgProcType);
    }

    public static void sourceReturnRspPackage(Map<String, String> commonAttrMap, Map<String, Object> resultMap, Channel remoteChannel, MsgType msgType) throws Exception {
        ByteBuf binBuffer;
        String origAttrs = null;
        StringBuilder strBuff = new StringBuilder(512);
        if (remoteChannel == null || MsgType.MSG_UNKNOWN.equals((Object)msgType)) {
            if (logCounter.shouldPrint()) {
                if (remoteChannel == null) {
                    logger.warn("remoteChannel == null, discard it!", (Object)remoteChannel);
                } else {
                    logger.warn("Unknown msgType message from {}, discard it!", (Object)remoteChannel);
                }
            }
            return;
        }
        if (MsgType.MSG_HEARTBEAT.equals((Object)msgType)) {
            binBuffer = MessageUtils.buildHeartBeatMsgRspPackage();
        } else {
            String isAck = commonAttrMap.get("isAck");
            if ("false".equalsIgnoreCase(isAck)) {
                return;
            }
            origAttrs = (String)resultMap.get("attrs");
            if (!remoteChannel.isWritable()) {
                strBuff.append("Send buffer is full1 by channel ").append(remoteChannel).append(", attr is ").append(origAttrs);
                if (logCounter.shouldPrint()) {
                    logger.warn(strBuff.toString());
                }
                throw new Exception(strBuff.toString());
            }
            strBuff.append("dpIp").append("=").append(NetworkUtils.getLocalIp());
            String errCode = commonAttrMap.get("errCode");
            if (StringUtils.isNotEmpty((CharSequence)errCode)) {
                strBuff.append("&").append("errCode").append("=").append(errCode);
                String errMsg = commonAttrMap.get("errMsg");
                if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                    strBuff.append("&").append("errMsg").append("=").append(errMsg);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)origAttrs)) {
                strBuff.append("&").append(origAttrs);
            }
            String destAttrs = strBuff.toString();
            binBuffer = MsgType.MSG_BIN_MULTI_BODY.equals((Object)msgType) ? MessageUtils.buildBinMsgRspPackage(destAttrs, commonAttrMap.get("uniq")) : (MsgType.MSG_BIN_HEARTBEAT.equals((Object)msgType) ? MessageUtils.buildHBRspPackage(destAttrs, (Byte)resultMap.get("version"), 0) : MessageUtils.buildDefMsgRspPackage(msgType, destAttrs));
        }
        if (!remoteChannel.isWritable()) {
            binBuffer.release();
            strBuff.delete(0, strBuff.length());
            strBuff.append("Send buffer is full2 by channel ").append(remoteChannel).append(", attr is ").append(origAttrs);
            if (logCounter.shouldPrint()) {
                logger.warn(strBuff.toString());
            }
            throw new Exception(strBuff.toString());
        }
        remoteChannel.writeAndFlush((Object)binBuffer);
    }

    public static void sinkReturnRspPackage(SinkRspEvent event, DataProxyErrCode errCode, String errMsg) {
        block13: {
            StringBuilder strBuff = new StringBuilder(512);
            Channel remoteChannel = event.getChannel();
            if (remoteChannel == null || !remoteChannel.isActive()) {
                return;
            }
            MsgType msgType = event.getMsgType();
            if (MsgType.MSG_UNKNOWN.equals((Object)msgType) || MsgType.MSG_ACK_SERVICE.equals((Object)msgType) || MsgType.MSG_HEARTBEAT.equals((Object)msgType) || MsgType.MSG_BIN_HEARTBEAT.equals((Object)msgType)) {
                return;
            }
            Map<String, String> attrMap = event.getHeaders();
            String isAck = attrMap.get("isAck");
            if ("false".equalsIgnoreCase(isAck)) {
                return;
            }
            String origAttrs = attrMap.get("attrs");
            if (!remoteChannel.isWritable()) {
                if (logCounter.shouldPrint()) {
                    logger.warn(strBuff.append("Send buffer is full3 by channel ").append(remoteChannel).append(", attr is ").append(origAttrs).toString());
                }
                return;
            }
            strBuff.append("dpIp").append("=").append(NetworkUtils.getLocalIp());
            if (DataProxyErrCode.SUCCESS != errCode) {
                strBuff.append("&").append("errCode").append("=").append(errCode.getErrCode());
                if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                    strBuff.append("&").append("errMsg").append("=").append(errMsg);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)origAttrs)) {
                strBuff.append("&").append(origAttrs);
            }
            String destAttrs = strBuff.toString();
            ByteBuf binBuffer = MsgType.MSG_BIN_MULTI_BODY.equals((Object)msgType) ? MessageUtils.buildBinMsgRspPackage(destAttrs, attrMap.get("uniq")) : MessageUtils.buildDefMsgRspPackage(msgType, destAttrs);
            try {
                if (remoteChannel.isWritable()) {
                    remoteChannel.writeAndFlush((Object)binBuffer);
                } else {
                    binBuffer.release();
                    if (logCounter.shouldPrint()) {
                        strBuff.delete(0, strBuff.length());
                        logger.warn(strBuff.append("Send buffer is full4 by channel ").append(remoteChannel).append(", attr is ").append(origAttrs).toString());
                    }
                }
            }
            catch (Throwable e) {
                if (!logCounter.shouldPrint()) break block13;
                strBuff.delete(0, strBuff.length());
                logger.error(strBuff.append("Write data to channel exception, channel=").append(remoteChannel).append(", attr is ").append(origAttrs).toString());
            }
        }
    }

    private static ByteBuf buildHeartBeatMsgRspPackage() {
        ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer(5);
        buffer.writeBytes(new byte[]{0, 0, 0, 1, 1});
        return buffer;
    }

    private static ByteBuf buildDefMsgRspPackage(MsgType msgType, String attrs) {
        int attrsLen = 0;
        int bodyLen = 0;
        if (attrs != null) {
            attrsLen = attrs.length();
        }
        int backTotalLen = 5 + bodyLen + 4 + attrsLen;
        ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer(4 + backTotalLen);
        buffer.writeInt(backTotalLen);
        buffer.writeByte(msgType.getValue());
        buffer.writeInt(bodyLen);
        buffer.writeInt(attrsLen);
        if (attrsLen > 0) {
            buffer.writeBytes(attrs.getBytes(StandardCharsets.UTF_8));
        }
        return buffer;
    }

    private static ByteBuf buildBinMsgRspPackage(String attrs, String sequenceId) {
        int binTotalLen = 9;
        if (null != attrs) {
            binTotalLen += attrs.length();
        }
        ByteBuf binBuffer = ByteBufAllocator.DEFAULT.buffer(4 + binTotalLen);
        binBuffer.writeInt(binTotalLen);
        binBuffer.writeByte(MsgType.MSG_BIN_MULTI_BODY.getValue());
        long uniqVal = Long.parseLong(sequenceId);
        byte[] uniq = new byte[]{(byte)(uniqVal >> 24 & 0xFFL), (byte)(uniqVal >> 16 & 0xFFL), (byte)(uniqVal >> 8 & 0xFFL), (byte)(uniqVal & 0xFFL)};
        binBuffer.writeBytes(uniq);
        if (null != attrs) {
            binBuffer.writeShort(attrs.length());
            binBuffer.writeBytes(attrs.getBytes(StandardCharsets.UTF_8));
        } else {
            binBuffer.writeShort(0);
        }
        binBuffer.writeShort(60929);
        return binBuffer;
    }

    private static ByteBuf buildHBRspPackage(String attrs, byte version, int loadValue) {
        int binTotalLen = 16;
        if (null != attrs) {
            binTotalLen += attrs.length();
        }
        if (loadValue == 0 || loadValue == -1) {
            loadValue = 65535;
        }
        ByteBuf binBuffer = ByteBufAllocator.DEFAULT.buffer(4 + binTotalLen);
        binBuffer.writeInt(binTotalLen);
        binBuffer.writeByte(MsgType.MSG_BIN_HEARTBEAT.getValue());
        binBuffer.writeInt((int)(System.currentTimeMillis() / 1000L));
        binBuffer.writeByte((int)version);
        binBuffer.writeInt(2);
        binBuffer.writeShort(loadValue);
        if (null != attrs) {
            binBuffer.writeShort(attrs.length());
            binBuffer.writeBytes(attrs.getBytes(StandardCharsets.UTF_8));
        } else {
            binBuffer.writeShort(0);
        }
        binBuffer.writeShort(60929);
        return binBuffer;
    }

    public static Map<String, String> getXfsAttrs(Map<String, String> headers, String pkgVersion) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("msgEnType", pkgVersion);
        if (DataProxyMsgEncType.MSG_ENCODE_TYPE_PB.getStrId().equalsIgnoreCase(pkgVersion)) {
            attrs.put("dataproxyip", NetworkUtils.getLocalIp());
            attrs.put("inlongGroupId", headers.get("inlongGroupId"));
            attrs.put("inlongStreamId", headers.get("inlongStreamId"));
            attrs.put("topic", headers.get("topic"));
            attrs.put("msgTime", headers.get("msgTime"));
            attrs.put("sourceIp", headers.get("sourceIp"));
        } else {
            attrs.put("inlongGroupId", headers.get("groupId"));
            attrs.put("inlongStreamId", headers.get("streamId"));
            attrs.put("topic", headers.get("topic"));
            attrs.put("msgTime", headers.get("dt"));
            attrs.put("sourceIp", headers.get("srcIp"));
            attrs.put("sourceTime", headers.get("rt"));
            attrs.put("dpIp", NetworkUtils.getLocalIp());
        }
        return attrs;
    }
}

