/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.source.v0msg;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Event;
import org.apache.flume.event.EventBuilder;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.msg.InLongMsg;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.source.BaseSource;
import org.apache.inlong.dataproxy.source.v0msg.AbsV0MsgCodec;
import org.xerial.snappy.Snappy;

public class CodecTextMsg
extends AbsV0MsgCodec {
    public CodecTextMsg(int totalDataLen, int msgTypeValue, long msgRcvTime, String strRemoteIP) {
        super(totalDataLen, msgTypeValue, msgRcvTime, strRemoteIP);
    }

    @Override
    public boolean descMsg(BaseSource source, ByteBuf cb) throws Exception {
        int attrLen;
        int msgHeadPos = cb.readerIndex() - 5;
        int bodyLen = cb.getInt(msgHeadPos + 5);
        if (bodyLen <= 0) {
            if (bodyLen == 0) {
                source.fileMetricIncSumStats("msg.body.zero");
                this.errCode = DataProxyErrCode.BODY_LENGTH_ZERO;
            } else {
                source.fileMetricIncSumStats("msg.body.negative");
                this.errCode = DataProxyErrCode.BODY_LENGTH_LESS_ZERO;
            }
            return false;
        }
        if (bodyLen + 13 > this.totalDataLen + 4) {
            source.fileMetricIncSumStats("msg.txt.len.malformed");
            this.errCode = DataProxyErrCode.BODY_EXCEED_MAX_LEN;
            this.errMsg = String.format("Error msg, bodyLen(%d) + fixedLength(%d) > totalDataLen(%d) + 4", bodyLen, 13, this.totalDataLen);
            return false;
        }
        this.bodyData = new byte[bodyLen];
        cb.getBytes(msgHeadPos + 9, this.bodyData, 0, bodyLen);
        if (MsgType.MSG_ORIGINAL_RETURN.equals((Object)MsgType.valueOf((int)this.msgType))) {
            this.origBody = new byte[bodyLen];
            System.arraycopy(this.bodyData, 0, this.origBody, 0, bodyLen);
        }
        if ((attrLen = cb.getInt(msgHeadPos + 9 + bodyLen)) < 0) {
            source.fileMetricIncSumStats("msg.attr.negative");
            this.errCode = DataProxyErrCode.ATTR_LENGTH_LESS_ZERO;
            return false;
        }
        if (this.totalDataLen + 4 != 13 + bodyLen + attrLen) {
            source.fileMetricIncSumStats("msg.txt.len.malformed");
            this.errCode = DataProxyErrCode.BODY_EXCEED_MAX_LEN;
            this.errMsg = String.format("Error msg, totalDataLen(%d) + 4 != fixedLength(%d) + bodyLen(%d) + attrLen(%d)", this.totalDataLen, 13, bodyLen, attrLen);
            return false;
        }
        if (!this.decAttrInfo(source, cb, attrLen, msgHeadPos + 13 + bodyLen)) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.attrMap.get("cp")))) {
            byte[] unCompressedData;
            try {
                int uncompressedLen = Snappy.uncompressedLength((byte[])this.bodyData, (int)0, (int)this.bodyData.length);
                unCompressedData = new byte[uncompressedLen];
                Snappy.uncompress((byte[])this.bodyData, (int)0, (int)this.bodyData.length, (byte[])unCompressedData, (int)0);
            }
            catch (IOException e) {
                source.fileMetricIncSumStats("msg.body.unpress.exp");
                this.errCode = DataProxyErrCode.UNCOMPRESS_DATA_ERROR;
                this.errMsg = String.format("Error to uncompress msg, compress type(%s), attr: (%s), error: (%s)", this.attrMap.get("cp"), this.origAttr, e.getCause());
                return false;
            }
            if (unCompressedData.length == 0) {
                source.fileMetricIncSumStats("msg.body.unpress.exp");
                this.errCode = DataProxyErrCode.UNCOMPRESS_DATA_ERROR;
                this.errMsg = String.format("Error to uncompress msg, compress type(%s), attr: (%s), error: 2", this.attrMap.get("cp"), this.origAttr);
                return false;
            }
            this.bodyData = unCompressedData;
        }
        if (MsgType.MSG_MULTI_BODY.equals((Object)MsgType.valueOf((int)this.msgType))) {
            int singleMsgLen;
            int readPos = 0;
            ByteBuffer bodyBuffer = ByteBuffer.wrap(this.bodyData);
            for (int remaining = bodyBuffer.remaining(); remaining > 0; remaining -= 4 + singleMsgLen) {
                singleMsgLen = bodyBuffer.getInt(readPos);
                if (singleMsgLen <= 0 || singleMsgLen > remaining) {
                    source.fileMetricIncSumStats("msg.item.len.malformed");
                    this.errCode = DataProxyErrCode.BODY_EXCEED_MAX_LEN;
                    this.errMsg = String.format("Malformed data len, singleMsgLen(%d), buffer remaining(%d), attr: (%s)", singleMsgLen, remaining, this.origAttr);
                    return false;
                }
                readPos += 4 + singleMsgLen;
            }
        }
        return true;
    }

    @Override
    public boolean validAndFillFields(BaseSource source, StringBuilder strBuff) {
        String tmpGroupId = (String)this.attrMap.get("groupId");
        String tmpStreamId = (String)this.attrMap.get("streamId");
        if (StringUtils.isBlank((CharSequence)tmpGroupId)) {
            source.fileMetricIncSumStats("msg.groupid.missing");
            this.errCode = DataProxyErrCode.MISS_REQUIRED_GROUPID_ARGUMENT;
            return false;
        }
        String tmpTopicName = ConfigManager.getInstance().getTopicName(tmpGroupId, tmpStreamId);
        if (StringUtils.isBlank((CharSequence)tmpTopicName)) {
            source.fileMetricIncSumStats("config.topic.missing");
            this.errCode = DataProxyErrCode.TOPIC_IS_BLANK;
            this.errMsg = String.format("Topic not configured for groupId=(%s), streamId=(%s)", tmpGroupId, tmpStreamId);
            return false;
        }
        this.groupId = tmpGroupId;
        this.topicName = tmpTopicName;
        if (StringUtils.isNotBlank((CharSequence)tmpStreamId)) {
            this.streamId = tmpStreamId;
        }
        this.msgCount = 1;
        String cntStr = (String)this.attrMap.get("cnt");
        if (StringUtils.isBlank((CharSequence)cntStr)) {
            this.attrMap.put("cnt", String.valueOf(this.msgCount));
        } else {
            try {
                this.msgCount = Integer.parseInt(cntStr);
            }
            catch (Throwable e) {
                this.attrMap.put("cnt", String.valueOf(this.msgCount));
            }
        }
        this.dataTimeMs = this.msgRcvTime;
        String strDataTime = (String)this.attrMap.get("dt");
        if (StringUtils.isBlank((CharSequence)strDataTime)) {
            this.attrMap.put("dt", String.valueOf(this.dataTimeMs));
        } else {
            try {
                this.dataTimeMs = Long.parseLong(strDataTime);
            }
            catch (Throwable e) {
                this.attrMap.put("dt", String.valueOf(this.dataTimeMs));
            }
        }
        String sequenceId = (String)this.attrMap.get("sid");
        if (StringUtils.isNotBlank((CharSequence)sequenceId)) {
            strBuff.append(this.groupId).append("&").append(this.streamId).append("&").append(sequenceId).append("#").append(this.strRemoteIP);
            this.msgSeqId = strBuff.toString();
            strBuff.delete(0, strBuff.length());
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.attrMap.get("rt")))) {
            strBuff.append("rt").append("=").append(this.msgRcvTime);
            this.attrMap.put("rt", String.valueOf(this.msgRcvTime));
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.attrMap.get("rtms")))) {
            if (strBuff.length() > 0) {
                strBuff.append("&");
            }
            strBuff.append("rtms").append("=").append(this.msgRcvTime);
            this.attrMap.put("rtms", String.valueOf(this.msgRcvTime));
        }
        if (strBuff.length() > 0) {
            if (StringUtils.isNotBlank((CharSequence)this.origAttr)) {
                strBuff.append("&").append(this.origAttr);
            }
            this.totalDataLen += strBuff.length() - this.origAttr.length();
            this.origAttr = strBuff.toString();
            strBuff.delete(0, strBuff.length());
        }
        return true;
    }

    @Override
    public Event encEventPackage(BaseSource source, Channel channel) {
        int inLongMsgVer = 1;
        if (MsgType.MSG_MULTI_BODY_ATTR.equals((Object)MsgType.valueOf((int)this.msgType))) {
            inLongMsgVer = 3;
        }
        InLongMsg inLongMsg = InLongMsg.newInLongMsg((boolean)source.isCompressed(), (int)inLongMsgVer);
        if (MsgType.MSG_MULTI_BODY.equals((Object)MsgType.valueOf((int)this.msgType))) {
            int singleMsgLen;
            int calcCnt = 0;
            ByteBuffer bodyBuffer = ByteBuffer.wrap(this.bodyData);
            this.attrMap.put("cnt", String.valueOf(1));
            while (bodyBuffer.remaining() > 0 && (singleMsgLen = bodyBuffer.getInt()) > 0 && singleMsgLen <= bodyBuffer.remaining()) {
                byte[] record = new byte[singleMsgLen];
                bodyBuffer.get(record);
                inLongMsg.addMsg(mapJoiner.join(this.attrMap), bodyBuffer);
                ++calcCnt;
            }
            this.attrMap.put("cnt", String.valueOf(calcCnt));
            this.msgCount = calcCnt;
        } else if (MsgType.MSG_MULTI_BODY_ATTR.equals((Object)MsgType.valueOf((int)this.msgType))) {
            this.attrMap.put("cnt", String.valueOf(1));
            inLongMsg.addMsg(mapJoiner.join(this.attrMap), this.bodyData);
            this.attrMap.put("cnt", String.valueOf(this.msgCount));
        } else {
            if (!"pb".equals(this.attrMap.get("mt")) && this.bodyData[this.bodyData.length - 1] == 10) {
                int tripDataLen = this.bodyData.length - 1;
                if (this.bodyData[this.bodyData.length - 2] == 13) {
                    tripDataLen = this.bodyData.length - 2;
                }
                byte[] tripData = new byte[tripDataLen];
                System.arraycopy(this.bodyData, 0, tripData, 0, tripDataLen);
                this.bodyData = tripData;
                source.fileMetricIncSumStats("msg.body.trip");
            }
            inLongMsg.addMsg(mapJoiner.join(this.attrMap), this.bodyData);
        }
        byte[] inlongMsgData = inLongMsg.buildArray();
        Event event = EventBuilder.withBody((byte[])inlongMsgData, this.buildEventHeaders(inLongMsg.getCreatetime()));
        inLongMsg.reset();
        return event;
    }
}

