/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.source.httpMsg;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flume.Event;
import org.apache.flume.event.EventBuilder;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.enums.DataProxyMsgEncType;
import org.apache.inlong.common.monitor.LogCounter;
import org.apache.inlong.common.msg.InLongMsg;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.source.BaseSource;
import org.apache.inlong.dataproxy.utils.AddressUtils;
import org.apache.inlong.dataproxy.utils.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HttpMessageHandler.class);
    private static final LogCounter logCounter = new LogCounter(10, 100000, 30000);
    private final BaseSource source;

    public HttpMessageHandler(BaseSource source) {
        this.source = source;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        String cntType;
        String cntLengthStr;
        if (HttpUtil.is100ContinueExpected((HttpMessage)req)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        long msgRcvTime = System.currentTimeMillis();
        String clientIp = AddressUtils.getChannelRemoteIP(ctx.channel());
        if (!req.decoderResult().isSuccess()) {
            this.source.fileMetricIncSumStats("msg.decode.failure");
            this.sendErrorMsg(ctx, DataProxyErrCode.HTTP_DECODE_REQ_FAILURE);
            return;
        }
        if (this.source.isRejectService()) {
            this.source.fileMetricIncSumStats("service.closed");
            this.sendErrorMsg(ctx, DataProxyErrCode.SERVICE_CLOSED);
            return;
        }
        if (!ConfigManager.getInstance().isMqClusterReady()) {
            this.source.fileMetricIncSumStats("service.sink.unready");
            this.sendErrorMsg(ctx, DataProxyErrCode.SINK_SERVICE_UNREADY);
            return;
        }
        if (req.method() != HttpMethod.GET && req.method() != HttpMethod.POST) {
            this.source.fileMetricIncSumStats("msg.method.invalid");
            this.sendErrorMsg(ctx, DataProxyErrCode.HTTP_UNSUPPORTED_METHOD, "Only support [" + HttpMethod.GET.name() + ", " + HttpMethod.POST.name() + "] methods");
            return;
        }
        QueryStringDecoder uriDecoder = new QueryStringDecoder(req.uri(), Charsets.toCharset((String)"UTF-8"));
        if (!"/dataproxy/heartbeat".equals(uriDecoder.path()) && !"/dataproxy/message".equals(uriDecoder.path())) {
            if (!"/favicon.ico".equals(uriDecoder.path())) {
                this.source.fileMetricIncSumStats("msg.path.invalid");
                this.sendErrorMsg(ctx, DataProxyErrCode.HTTP_UNSUPPORTED_SERVICE_URI, "Only support [/dataproxy/heartbeat, /dataproxy/message] paths!");
            }
            return;
        }
        boolean closeConnection = this.isCloseConnection(req);
        if ("/dataproxy/heartbeat".equals(uriDecoder.path())) {
            this.source.fileMetricIncSumStats("msg.hb.success");
            this.sendResponse(ctx, closeConnection);
            return;
        }
        HashMap<String, String> reqAttrs = new HashMap<String, String>();
        this.getAttrsFromDecoder(uriDecoder, reqAttrs);
        if (req.method() == HttpMethod.POST && StringUtils.isNotBlank((CharSequence)(cntLengthStr = req.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH))) && NumberUtils.toInt((String)cntLengthStr, (int)0) > 0 && StringUtils.isNotBlank((CharSequence)(cntType = req.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)))) {
            if (!(cntType = cntType.trim()).equalsIgnoreCase(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString())) {
                this.source.fileMetricIncSumStats("msg.content.invalid");
                this.sendErrorMsg(ctx, DataProxyErrCode.HTTP_UNSUPPORTED_CONTENT_TYPE, "Only support [" + HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED + "] content type!");
                return;
            }
            String cntStr = req.content().toString(Charsets.toCharset((String)"UTF-8"));
            QueryStringDecoder cntDecoder = new QueryStringDecoder(cntStr, false);
            this.getAttrsFromDecoder(cntDecoder, reqAttrs);
        }
        this.processMessage(ctx, reqAttrs, msgRcvTime, clientIp, closeConnection);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String strRemoteIp;
        this.source.fileMetricIncSumStats("visit.linkin");
        if (ConfigManager.getInstance().needChkIllegalIP() && (strRemoteIp = AddressUtils.getChannelRemoteIP(ctx.channel())) != null && ConfigManager.getInstance().isIllegalIP(strRemoteIp)) {
            this.source.fileMetricIncSumStats("visit.illegal");
            ctx.channel().disconnect();
            ctx.channel().close();
            if (logCounter.shouldPrint()) {
                logger.error(strRemoteIp + " is Illegal IP, so refuse it !");
            }
            return;
        }
        if (this.source.getAllChannels().size() >= this.source.getMaxConnections()) {
            this.source.fileMetricIncSumStats("visit.overmax");
            ctx.channel().disconnect();
            ctx.channel().close();
            if (logCounter.shouldPrint()) {
                logger.warn("{} refuse to connect = {} , connections = {}, maxConnections = {}", new Object[]{this.source.getName(), ctx.channel(), this.source.getAllChannels().size(), this.source.getMaxConnections()});
            }
            return;
        }
        this.source.getAllChannels().add((Object)ctx.channel());
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.source.fileMetricIncSumStats("visit.linkout");
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.source.fileMetricIncSumStats("visit.exception");
        if (logCounter.shouldPrint()) {
            logger.warn("{} received an exception from channel {}", new Object[]{this.source.getName(), ctx.channel(), cause});
        }
        if (cause instanceof IOException) {
            ctx.close();
        } else {
            this.sendErrorMsg(ctx, DataProxyErrCode.UNKNOWN_ERROR, "Process message failure: " + cause.getMessage());
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.class.isAssignableFrom(evt.getClass())) {
            ctx.close();
        }
    }

    private boolean processMessage(ChannelHandlerContext ctx, Map<String, String> reqAttrs, long msgRcvTime, String clientIp, boolean isCloseCon) throws Exception {
        String body;
        StringBuilder strBuff = new StringBuilder(512);
        String groupId = reqAttrs.get("groupId");
        if (StringUtils.isBlank((CharSequence)groupId)) {
            this.source.fileMetricIncSumStats("msg.groupid.missing");
            this.sendResponse(ctx, DataProxyErrCode.MISS_REQUIRED_GROUPID_ARGUMENT.getErrCode(), strBuff.append("Field ").append("groupId").append(" must exist and not blank!").toString(), isCloseCon);
            return false;
        }
        String streamId = reqAttrs.get("streamId");
        if (StringUtils.isBlank((CharSequence)streamId)) {
            this.source.fileMetricIncSumStats("msg.streamid.missing");
            this.sendResponse(ctx, DataProxyErrCode.MISS_REQUIRED_STREAMID_ARGUMENT.getErrCode(), strBuff.append("Field ").append("streamId").append(" must exist and not blank!").toString(), isCloseCon);
            return false;
        }
        String topicName = ConfigManager.getInstance().getTopicName(groupId, streamId);
        if (StringUtils.isBlank((CharSequence)topicName)) {
            this.source.fileMetricIncSumStats("config.topic.missing");
            this.sendResponse(ctx, DataProxyErrCode.TOPIC_IS_BLANK.getErrCode(), strBuff.append("Topic not configured for ").append("groupId").append("(").append(groupId).append("),").append("streamId").append("(,").append(streamId).append(")").toString(), isCloseCon);
            return false;
        }
        long dataTime = msgRcvTime;
        String dt = reqAttrs.get("dt");
        if (StringUtils.isNotEmpty((CharSequence)dt)) {
            try {
                dataTime = Long.parseLong(dt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)(body = reqAttrs.get("body")))) {
            if (body == null) {
                this.source.fileMetricIncSumStats("msg.body.missing");
                this.sendResponse(ctx, DataProxyErrCode.MISS_REQUIRED_BODY_ARGUMENT.getErrCode(), strBuff.append("Field ").append("body").append(" is not exist!").toString(), isCloseCon);
            } else {
                this.source.fileMetricIncSumStats("msg.body.blank");
                this.sendResponse(ctx, DataProxyErrCode.EMPTY_MSG.getErrCode(), strBuff.append("Field ").append("body").append(" is Blank!").toString(), isCloseCon);
            }
            return false;
        }
        if (body.length() > this.source.getMaxMsgLength()) {
            this.source.fileMetricIncSumStats("msg.body.overmax");
            this.sendResponse(ctx, DataProxyErrCode.BODY_EXCEED_MAX_LEN.getErrCode(), strBuff.append("Error msg, the ").append("body").append(" length(").append(body.length()).append(") is bigger than allowed length(").append(this.source.getMaxMsgLength()).append(")").toString(), isCloseCon);
            return false;
        }
        int intMsgCnt = NumberUtils.toInt((String)reqAttrs.get("cnt"), (int)1);
        String strMsgCount = String.valueOf(intMsgCnt);
        InLongMsg inLongMsg = InLongMsg.newInLongMsg((boolean)this.source.isCompressed());
        strBuff.append("groupId=").append(groupId).append("&streamId=").append(streamId).append("&dt=").append(dataTime).append("&clientIp=").append(clientIp).append("&cnt=").append(strMsgCount).append("&rt=").append(msgRcvTime).append("&").append("rtms").append("=").append(msgRcvTime);
        inLongMsg.addMsg(strBuff.toString(), body.getBytes("UTF-8"));
        byte[] inlongMsgData = inLongMsg.buildArray();
        long pkgTime = inLongMsg.getCreatetime();
        inLongMsg.reset();
        strBuff.delete(0, strBuff.length());
        HashMap<String, String> eventHeaders = new HashMap<String, String>();
        eventHeaders.put("groupId", groupId);
        eventHeaders.put("streamId", streamId);
        eventHeaders.put("topic", topicName);
        eventHeaders.put("dt", String.valueOf(dataTime));
        eventHeaders.put("srcIp", clientIp);
        eventHeaders.put("msgcnt", strMsgCount);
        eventHeaders.put("msgEnType", DataProxyMsgEncType.MSG_ENCODE_TYPE_INLONGMSG.getStrId());
        eventHeaders.put("version", DataProxyMsgEncType.MSG_ENCODE_TYPE_INLONGMSG.getStrId());
        eventHeaders.put("rt", String.valueOf(msgRcvTime));
        eventHeaders.put("msg.pkg.time", DateTimeUtils.ms2yyyyMMddHHmm(pkgTime));
        Event event = EventBuilder.withBody((byte[])inlongMsgData, eventHeaders);
        dataTime = dataTime / 1000L / 60L / 10L;
        dataTime = dataTime * 1000L * 60L * 10L;
        String statsKey = strBuff.append(this.source.getProtocolName()).append("#").append(groupId).append("#").append(streamId).append("#").append(clientIp).append("#").append(this.source.getSrcHost()).append("#").append("b2b").append("#").append(DateTimeUtils.ms2yyyyMMddHHmm(dataTime)).append("#").append(DateTimeUtils.ms2yyyyMMddHHmm(msgRcvTime)).toString();
        strBuff.delete(0, strBuff.length());
        try {
            this.source.getChannelProcessor().processEvent(event);
            this.source.fileMetricIncSumStats("msg.post.v0.success");
            this.source.fileMetricAddSuccCnt(statsKey, intMsgCnt, 1, event.getBody().length);
            this.source.addMetric(true, event.getBody().length, event);
            this.sendResponse(ctx, isCloseCon);
            return true;
        }
        catch (Throwable ex) {
            this.source.fileMetricIncSumStats("msg.post.v0.failure");
            this.source.fileMetricAddFailCnt(statsKey, 1);
            this.source.addMetric(false, event.getBody().length, event);
            this.sendErrorMsg(ctx, DataProxyErrCode.PUT_EVENT_TO_CHANNEL_FAILURE, strBuff.append("Put event to channel failure: ").append(ex.getMessage()).toString());
            if (logCounter.shouldPrint()) {
                logger.error("Error writing HTTP event to channel failure.", ex);
            }
            return false;
        }
    }

    private void getAttrsFromDecoder(QueryStringDecoder decoder, Map<String, String> reqAttrs) {
        for (Map.Entry attr : decoder.parameters().entrySet()) {
            if (attr == null || attr.getKey() == null || attr.getValue() == null || ((List)attr.getValue()).isEmpty()) continue;
            reqAttrs.put((String)attr.getKey(), (String)((List)attr.getValue()).get(0));
        }
    }

    private boolean isCloseConnection(FullHttpRequest req) {
        String connStatus = req.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
        if (connStatus == null) {
            return false;
        }
        connStatus = connStatus.trim();
        return connStatus.equalsIgnoreCase(HttpHeaderValues.CLOSE.toString());
    }

    private void sendErrorMsg(ChannelHandlerContext ctx, DataProxyErrCode errCodeObj) {
        this.sendResponse(ctx, errCodeObj.getErrCode(), errCodeObj.getErrMsg(), true);
    }

    private void sendErrorMsg(ChannelHandlerContext ctx, DataProxyErrCode errCodeObj, String errMsg) {
        this.sendResponse(ctx, errCodeObj.getErrCode(), errMsg, true);
    }

    private void sendResponse(ChannelHandlerContext ctx, boolean isClose) {
        this.sendResponse(ctx, DataProxyErrCode.SUCCESS.getErrCode(), DataProxyErrCode.SUCCESS.getErrMsg(), isClose);
    }

    private void sendResponse(ChannelHandlerContext ctx, int errCode, String errMsg, boolean isClose) {
        if (ctx == null || ctx.channel() == null) {
            return;
        }
        if (!ctx.channel().isWritable()) {
            this.source.fileMetricIncSumStats("socket.unwritable");
            if (logCounter.shouldPrint()) {
                logger.warn("Send msg but channel full, channel={}", (Object)ctx.channel());
            }
            return;
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json;charset=utf-8");
        StringBuilder builder = new StringBuilder().append("{\"code\":\"").append(errCode).append("\",\"msg\":\"").append(errMsg).append("\"}");
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)builder.toString(), (Charset)CharsetUtil.UTF_8);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)buffer.readableBytes());
        response.content().writeBytes(buffer);
        buffer.release();
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)new SendResultListener(isClose));
    }

    private class SendResultListener
    implements ChannelFutureListener {
        private final boolean isClose;

        public SendResultListener(boolean isClose) {
            this.isClose = isClose;
        }

        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            if (!channelFuture.isSuccess()) {
                Throwable throwable = channelFuture.cause();
                String clientIp = AddressUtils.getChannelRemoteIP(channelFuture.channel());
                if (logCounter.shouldPrint()) {
                    logger.error("Http return response to client {} failed, exception:{}, errmsg:{}", new Object[]{clientIp, throwable, throwable.getLocalizedMessage()});
                }
                channelFuture.channel().close();
            }
            if (this.isClose) {
                channelFuture.channel().close();
            }
        }
    }
}

