/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.source;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import org.apache.flume.Context;
import org.apache.flume.conf.Configurable;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.source.BaseSource;
import org.apache.inlong.dataproxy.utils.ConfStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpSource
extends BaseSource
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(SimpleHttpSource.class);
    private ServerBootstrap bootstrap;
    private boolean tcpNoDelay;
    private int highWaterMark;

    public SimpleHttpSource() {
        ConfigManager.getInstance().regIPVisitConfigChgCallback(this);
    }

    @Override
    public void configure(Context context) {
        logger.info("Source {} context is {}", (Object)this.getName(), (Object)context);
        super.configure(context);
        this.tcpNoDelay = context.getBoolean("tcpNoDelay", Boolean.valueOf(true));
        this.highWaterMark = ConfStringUtils.getIntValue(context, "highWaterMark", 65536);
        Preconditions.checkArgument((this.highWaterMark >= 0 ? 1 : 0) != 0, (Object)"65536 must be >= 0");
    }

    @Override
    public synchronized void startSource() {
        logger.info("start " + this.getName());
        this.acceptorGroup = new NioEventLoopGroup(this.maxAcceptThreads, (ThreadFactory)new DefaultThreadFactory(this.getName() + "-boss-group"));
        this.workerGroup = new NioEventLoopGroup(this.maxWorkerThreads, (ThreadFactory)new DefaultThreadFactory(this.getName() + "-worker-group"));
        this.bootstrap = new ServerBootstrap();
        if (this.conLinger >= 0) {
            this.bootstrap.option(ChannelOption.SO_LINGER, (Object)this.conLinger);
        }
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.conBacklog);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.reuseAddress);
        this.bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)ByteBufAllocator.DEFAULT);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay);
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.maxRcvBufferSize);
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.maxSendBufferSize);
        this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)this.highWaterMark);
        this.bootstrap.channel(NioServerSocketChannel.class);
        this.bootstrap.group(this.acceptorGroup, this.workerGroup);
        this.bootstrap.childHandler((ChannelHandler)this.getChannelInitializerFactory());
        try {
            this.channelFuture = this.srcHost == null ? this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.srcPort)).sync() : this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.srcHost, this.srcPort)).sync();
        }
        catch (Exception e) {
            logger.error("Source {} bind ({}:{}) error, program will exit! e = {}", new Object[]{this.getName(), this.srcHost, this.srcPort, e});
            System.exit(-1);
        }
        ConfigManager.getInstance().addSourceReportInfo(this.srcHost, String.valueOf(this.srcPort), this.getProtocolName().toUpperCase());
        logger.info("Source {} started at ({}:{})!", new Object[]{this.getName(), this.srcHost, this.srcPort});
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    @Override
    public String getProtocolName() {
        return "http";
    }
}

