/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.source;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.ChannelSelector;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.Configurable;
import org.apache.flume.source.AbstractSource;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.apache.inlong.dataproxy.admin.ProxyServiceMBean;
import org.apache.inlong.dataproxy.channel.FailoverChannelProcessor;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.config.holder.ConfigUpdateCallback;
import org.apache.inlong.dataproxy.metrics.DataProxyMetricItem;
import org.apache.inlong.dataproxy.metrics.DataProxyMetricItemSet;
import org.apache.inlong.dataproxy.metrics.audit.AuditUtils;
import org.apache.inlong.dataproxy.metrics.stats.MonitorIndex;
import org.apache.inlong.dataproxy.metrics.stats.MonitorStats;
import org.apache.inlong.dataproxy.source.ServerMessageFactory;
import org.apache.inlong.dataproxy.source.ServerMessageHandler;
import org.apache.inlong.dataproxy.source.SourceConstants;
import org.apache.inlong.dataproxy.source.httpMsg.HttpMessageHandler;
import org.apache.inlong.dataproxy.utils.AddressUtils;
import org.apache.inlong.dataproxy.utils.ConfStringUtils;
import org.apache.inlong.dataproxy.utils.FailoverChannelProcessorHolder;
import org.apache.inlong.sdk.commons.admin.AdminServiceRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSource
extends AbstractSource
implements ConfigUpdateCallback,
ProxyServiceMBean,
EventDrivenSource,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(BaseSource.class);
    protected Context context;
    protected volatile boolean isRejectService = false;
    protected String srcHost;
    protected int srcPort;
    protected String strPort;
    protected String msgFactoryName;
    protected String messageHandlerName;
    protected String defAttr = "";
    protected int maxMsgLength;
    protected boolean isCompressed;
    protected boolean filterEmptyMsg;
    protected boolean customProcessor;
    protected int maxWorkerThreads;
    protected int maxAcceptThreads;
    protected long maxReadIdleTimeMs;
    protected int maxConnections;
    protected boolean reuseAddress;
    protected int conBacklog;
    protected int conLinger = -1;
    protected EventLoopGroup acceptorGroup;
    protected EventLoopGroup workerGroup;
    protected ChannelGroup allChannels = new DefaultChannelGroup("DefaultChannelGroup", (EventExecutor)GlobalEventExecutor.INSTANCE);
    protected ChannelFuture channelFuture;
    protected int maxRcvBufferSize;
    protected int maxSendBufferSize;
    private MonitorIndex monitorIndex = null;
    private MonitorStats monitorStats = null;
    private DataProxyMetricItemSet metricItemSet;

    public void configure(Context context) {
        logger.info("{} start to configure context:{}.", (Object)this.getName(), (Object)context.toString());
        this.context = context;
        this.srcHost = this.getHostIp(context);
        this.srcPort = this.getHostPort(context);
        this.strPort = String.valueOf(this.srcPort);
        String tmpVal = context.getString("msg-factory-name", ServerMessageFactory.class.getName()).trim();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tmpVal), (Object)"msg-factory-name config is blank");
        this.msgFactoryName = tmpVal.trim();
        tmpVal = context.getString("message-handler-name");
        if (StringUtils.isBlank((CharSequence)tmpVal)) {
            tmpVal = "http".equalsIgnoreCase(this.getProtocolName()) ? HttpMessageHandler.class.getName() : ServerMessageHandler.class.getName();
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tmpVal), (Object)"message-handler-name config is blank");
        this.messageHandlerName = tmpVal;
        tmpVal = context.getString("attr");
        if (StringUtils.isNotBlank((CharSequence)tmpVal)) {
            this.defAttr = tmpVal.trim();
        }
        this.maxMsgLength = ConfStringUtils.getIntValue(context, "max-msg-length", 65536);
        Preconditions.checkArgument((this.maxMsgLength >= 5 && this.maxMsgLength <= 0x1400000 ? 1 : 0) != 0, (Object)"max-msg-length must be in [5, 20971520]");
        this.isCompressed = context.getBoolean("msg-compressed", Boolean.valueOf(true));
        this.filterEmptyMsg = context.getBoolean("filter-empty-msg", Boolean.valueOf(false));
        this.customProcessor = context.getBoolean("custom-cp", Boolean.valueOf(false));
        this.maxAcceptThreads = ConfStringUtils.getIntValue(context, "max-accept-threads", 1);
        Preconditions.checkArgument((this.maxAcceptThreads >= 1 && this.maxAcceptThreads <= 10 ? 1 : 0) != 0, (Object)"max-accept-threads must be in [1, 10]");
        this.maxWorkerThreads = ConfStringUtils.getIntValue(context, "max-threads", SourceConstants.VAL_DEF_WORKER_THREADS);
        Preconditions.checkArgument((this.maxWorkerThreads >= 1 ? 1 : 0) != 0, (Object)"max-threads must be >= 1");
        this.maxReadIdleTimeMs = ConfStringUtils.getLongValue(context, "maxReadIdleTime", 180000L);
        Preconditions.checkArgument((this.maxReadIdleTimeMs >= 60000L && this.maxReadIdleTimeMs <= 4200000L ? 1 : 0) != 0, (Object)"maxReadIdleTime must be in [60000, 4200000]");
        this.maxConnections = ConfStringUtils.getIntValue(context, "connections", 5000);
        Preconditions.checkArgument((this.maxConnections >= 0 ? 1 : 0) != 0, (Object)"connections must be >= 0");
        this.conBacklog = ConfStringUtils.getIntValue(context, "con-backlog", 128);
        Preconditions.checkArgument((this.conBacklog >= 0 ? 1 : 0) != 0, (Object)"con-backlog must be >= 0");
        Integer tmpValue = context.getInteger("con-linger");
        if (tmpValue != null && tmpValue >= 0) {
            this.conLinger = tmpValue;
        }
        this.reuseAddress = context.getBoolean("reuse-address", Boolean.valueOf(true));
        this.customProcessor = context.getBoolean("custom-cp", Boolean.valueOf(false));
        this.maxRcvBufferSize = ConfStringUtils.getIntValue(context, "receiveBufferSize", 65536);
        Preconditions.checkArgument((this.maxRcvBufferSize >= 0 ? 1 : 0) != 0, (Object)"receiveBufferSize must be >= 0");
        this.maxSendBufferSize = ConfStringUtils.getIntValue(context, "sendBufferSize", 65536);
        Preconditions.checkArgument((this.maxSendBufferSize >= 0 ? 1 : 0) != 0, (Object)"sendBufferSize must be >= 0");
    }

    public synchronized void start() {
        if (this.customProcessor) {
            ChannelSelector selector = this.getChannelProcessor().getSelector();
            FailoverChannelProcessor newProcessor = new FailoverChannelProcessor(selector);
            newProcessor.configure(this.context);
            this.setChannelProcessor(newProcessor);
            FailoverChannelProcessorHolder.setChannelProcessor(newProcessor);
        }
        super.start();
        this.metricItemSet = new DataProxyMetricItemSet(CommonConfigHolder.getInstance().getClusterName(), this.getName(), String.valueOf(this.srcPort));
        MetricRegister.register((MetricItemSet)this.metricItemSet);
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            this.monitorIndex = new MonitorIndex(CommonConfigHolder.getInstance().getFileMetricSourceOutName(), (long)CommonConfigHolder.getInstance().getFileMetricStatInvlSec() * 1000L, CommonConfigHolder.getInstance().getFileMetricStatCacheCnt());
            this.monitorIndex.start();
            this.monitorStats = new MonitorStats(CommonConfigHolder.getInstance().getFileMetricEventOutName() + "#" + this.getProtocolName(), (long)CommonConfigHolder.getInstance().getFileMetricStatInvlSec() * 1000L, CommonConfigHolder.getInstance().getFileMetricStatCacheCnt());
            this.monitorStats.start();
        }
        this.startSource();
        AdminServiceRegister.register((String)"ProxyService", (String)this.getName(), (Object)this);
    }

    public synchronized void stop() {
        logger.info("[STOP {} SOURCE]{} stopping...", (Object)this.getProtocolName(), (Object)this.getName());
        if (!this.allChannels.isEmpty()) {
            try {
                this.allChannels.close().awaitUninterruptibly();
            }
            catch (Exception e) {
                logger.warn("Close {} netty channels throw exception", (Object)this.getName(), (Object)e);
            }
            finally {
                this.allChannels.clear();
            }
        }
        if (this.channelFuture != null) {
            try {
                this.channelFuture.channel().closeFuture().sync();
            }
            catch (InterruptedException e) {
                logger.warn("Close {} channel future throw exception", (Object)this.getName(), (Object)e);
            }
        }
        super.stop();
        if (this.acceptorGroup != null) {
            this.acceptorGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            if (this.monitorIndex != null) {
                this.monitorIndex.stop();
            }
            if (this.monitorStats != null) {
                this.monitorStats.stop();
            }
        }
        logger.info("[STOP {} SOURCE]{} stopped", (Object)this.getProtocolName(), (Object)this.getName());
    }

    @Override
    public void update() {
        if (ConfigManager.getInstance().needChkIllegalIP()) {
            int cnt = 0;
            long startTime = System.currentTimeMillis();
            for (Channel channel : this.allChannels) {
                String strRemoteIP = AddressUtils.getChannelRemoteIP(channel);
                if (strRemoteIP == null || !ConfigManager.getInstance().isIllegalIP(strRemoteIP)) continue;
                channel.disconnect();
                channel.close();
                this.allChannels.remove((Object)channel);
                ++cnt;
                logger.error(strRemoteIP + " is Illegal IP, so disconnect it !");
            }
            logger.info("Source {} channel check, disconnects {} Illegal channels, waist {} ms", new Object[]{this.getName(), cnt, System.currentTimeMillis() - startTime});
        }
    }

    public DataProxyMetricItemSet getMetricItemSet() {
        return this.metricItemSet;
    }

    public Context getContext() {
        return this.context;
    }

    public String getSrcHost() {
        return this.srcHost;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public String getStrPort() {
        return this.strPort;
    }

    public String getDefAttr() {
        return this.defAttr;
    }

    public int getMaxMsgLength() {
        return this.maxMsgLength;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public boolean isFilterEmptyMsg() {
        return this.filterEmptyMsg;
    }

    public boolean isCustomProcessor() {
        return this.customProcessor;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public ChannelGroup getAllChannels() {
        return this.allChannels;
    }

    public long getMaxReadIdleTimeMs() {
        return this.maxReadIdleTimeMs;
    }

    public String getMessageHandlerName() {
        return this.messageHandlerName;
    }

    public int getMaxWorkerThreads() {
        return this.maxWorkerThreads;
    }

    public void fileMetricIncSumStats(String eventKey) {
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            this.monitorStats.incSumStats(eventKey);
        }
    }

    public void fileMetricIncDetailStats(String eventKey) {
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            this.monitorStats.incDetailStats(eventKey);
        }
    }

    public void fileMetricAddSuccCnt(String key, int cnt, int packCnt, long packSize) {
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            this.monitorIndex.addSuccStats(key, cnt, packCnt, packSize);
        }
    }

    public void fileMetricAddFailCnt(String key, int failCnt) {
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            this.monitorIndex.addFailStats(key, failCnt);
        }
    }

    public void addMetric(boolean result, long size, Event event) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("clusterId", CommonConfigHolder.getInstance().getClusterName());
        dimensions.put("sourceId", this.getName());
        dimensions.put("sourceDataId", this.getStrPort());
        DataProxyMetricItem.fillInlongId(event, dimensions);
        DataProxyMetricItem.fillAuditFormatTime(event, dimensions);
        DataProxyMetricItem metricItem = (DataProxyMetricItem)this.metricItemSet.findMetricItem(dimensions);
        if (result) {
            metricItem.readSuccessCount.incrementAndGet();
            metricItem.readSuccessSize.addAndGet(size);
            AuditUtils.add(5, event);
        } else {
            metricItem.readFailCount.incrementAndGet();
            metricItem.readFailSize.addAndGet(size);
        }
    }

    public ChannelInitializer getChannelInitializerFactory() {
        ChannelInitializer fac = null;
        logger.info(this.getName() + " load msgFactory=" + this.msgFactoryName);
        try {
            Class<?> clazz = Class.forName(this.msgFactoryName);
            Constructor<?> ctor = clazz.getConstructor(BaseSource.class);
            logger.info("Using channel processor:{}", (Object)this.getChannelProcessor().getClass().getName());
            fac = (ChannelInitializer)ctor.newInstance(this);
        }
        catch (Exception e) {
            logger.error("{} start error, fail to construct ChannelPipelineFactory with name {}", new Object[]{this.getName(), this.msgFactoryName, e});
            this.stop();
            throw new FlumeException(e.getMessage());
        }
        return fac;
    }

    public abstract String getProtocolName();

    public abstract void startSource();

    @Override
    public void stopService() {
        this.isRejectService = true;
    }

    @Override
    public void recoverService() {
        this.isRejectService = false;
    }

    public boolean isRejectService() {
        return this.isRejectService;
    }

    private String getHostIp(Context context) {
        Map<String, String> envMap;
        String result = null;
        String tmpVal = context.getString("host");
        if (StringUtils.isNotBlank((CharSequence)tmpVal)) {
            tmpVal = tmpVal.trim();
            Preconditions.checkArgument((boolean)ConfStringUtils.isValidIp(tmpVal), (Object)("host(" + tmpVal + ") config in conf not valid"));
            result = tmpVal;
        }
        if ((envMap = System.getenv()).containsKey("inlongHostIp")) {
            tmpVal = envMap.get("inlongHostIp");
            Preconditions.checkArgument((boolean)ConfStringUtils.isValidIp(tmpVal), (Object)("inlongHostIp(" + tmpVal + ") config in system env not valid"));
            result = tmpVal.trim();
        }
        if (StringUtils.isBlank(result)) {
            result = "0.0.0.0";
        }
        return result;
    }

    private int getHostPort(Context context) {
        Map<String, String> envMap;
        Integer result = null;
        String tmpVal = context.getString("port");
        if (StringUtils.isNotBlank((CharSequence)tmpVal)) {
            tmpVal = tmpVal.trim();
            try {
                result = Integer.parseInt(tmpVal);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("inlongHostPort(" + tmpVal + ") config in conf not integer");
            }
        }
        if (result != null) {
            Preconditions.checkArgument((boolean)ConfStringUtils.isValidPort(result), (Object)("port(" + result + ") config in conf not valid"));
        }
        if ((envMap = System.getenv()).containsKey("inlongHostPort") && StringUtils.isNotBlank((CharSequence)(tmpVal = envMap.get("inlongHostPort")))) {
            tmpVal = tmpVal.trim();
            try {
                result = Integer.parseInt(tmpVal);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("inlongHostPort(" + tmpVal + ") config in system env not integer");
            }
            Preconditions.checkArgument((boolean)ConfStringUtils.isValidPort(result), (Object)("inlongHostPort(" + tmpVal + ") config in system env not valid"));
        }
        if (result == null) {
            throw new IllegalArgumentException("Required parameter port must exist and may not be null");
        }
        return result;
    }
}

