/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq.pulsar;

import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Context;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.monitor.LogCounter;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.config.pojo.IdTopicConfig;
import org.apache.inlong.dataproxy.sink.common.EventHandler;
import org.apache.inlong.dataproxy.sink.mq.BatchPackProfile;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueHandler;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneSinkContext;
import org.apache.inlong.dataproxy.sink.mq.PackProfile;
import org.apache.inlong.dataproxy.sink.mq.SimplePackProfile;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SizeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarHandler
implements MessageQueueHandler {
    private static final Logger logger = LoggerFactory.getLogger(PulsarHandler.class);
    private static final LogCounter logCounter = new LogCounter(10, 100000, 30000);
    public static final String KEY_TENANT = "tenant";
    public static final String KEY_NAMESPACE = "namespace";
    public static final String KEY_SERVICE_URL = "serviceUrl";
    public static final String KEY_AUTHENTICATION = "authentication";
    public static final String KEY_ENABLEBATCHING = "enableBatching";
    public static final String KEY_BATCHINGMAXBYTES = "batchingMaxBytes";
    public static final String KEY_BATCHINGMAXMESSAGES = "batchingMaxMessages";
    public static final String KEY_BATCHINGMAXPUBLISHDELAY = "batchingMaxPublishDelay";
    public static final String KEY_MAXPENDINGMESSAGES = "maxPendingMessages";
    public static final String KEY_MAXPENDINGMESSAGESACROSSPARTITIONS = "maxPendingMessagesAcrossPartitions";
    public static final String KEY_SENDTIMEOUT = "sendTimeout";
    public static final String KEY_COMPRESSIONTYPE = "compressionType";
    public static final String KEY_BLOCKIFQUEUEFULL = "blockIfQueueFull";
    public static final String KEY_ROUNDROBINROUTERBATCHINGPARTITIONSWITCHFREQUENCY = "roundRobinRouterBatchingPartitionSwitchFrequency";
    public static final String KEY_IOTHREADS = "ioThreads";
    public static final String KEY_MEMORYLIMIT = "memoryLimit";
    public static final String KEY_CONNECTIONSPERBROKER = "connectionsPerBroker";
    private CacheClusterConfig config;
    private String clusterName;
    private MessageQueueZoneSinkContext sinkContext;
    private String tenant;
    private String namespace;
    private final ThreadLocal<EventHandler> handlerLocal = new ThreadLocal();
    private PulsarClient client;
    private ProducerBuilder<byte[]> baseBuilder;
    private final ConcurrentHashMap<String, Producer<byte[]>> producerMap = new ConcurrentHashMap();

    @Override
    public void init(CacheClusterConfig config, MessageQueueZoneSinkContext sinkContext) {
        this.config = config;
        this.clusterName = config.getClusterName();
        this.sinkContext = sinkContext;
        this.tenant = config.getParams().get(KEY_TENANT);
        this.namespace = config.getParams().get(KEY_NAMESPACE);
    }

    @Override
    public void start() {
        try {
            String serviceUrl = this.config.getParams().get(KEY_SERVICE_URL);
            String authentication = this.config.getParams().get(KEY_AUTHENTICATION);
            if (StringUtils.isEmpty((CharSequence)authentication)) {
                authentication = this.config.getToken();
            }
            Context context = this.sinkContext.getProducerContext();
            ClientBuilder builder = PulsarClient.builder();
            if (StringUtils.isNotEmpty((CharSequence)authentication)) {
                builder.authentication(AuthenticationFactory.token((String)authentication));
            }
            this.client = builder.serviceUrl(serviceUrl).ioThreads(context.getInteger(KEY_IOTHREADS, Integer.valueOf(1)).intValue()).memoryLimit(context.getLong(KEY_MEMORYLIMIT, Long.valueOf(0x40000000L)).longValue(), SizeUnit.BYTES).connectionsPerBroker(context.getInteger(KEY_CONNECTIONSPERBROKER, Integer.valueOf(10)).intValue()).statsInterval(NumberUtils.toLong((String)this.config.getParams().get("statsIntervalSeconds"), (long)-1L), TimeUnit.SECONDS).build();
            this.baseBuilder = this.client.newProducer();
            this.baseBuilder.sendTimeout(context.getInteger(KEY_SENDTIMEOUT, Integer.valueOf(0)).intValue(), TimeUnit.MILLISECONDS).maxPendingMessages(context.getInteger(KEY_MAXPENDINGMESSAGES, Integer.valueOf(500)).intValue()).maxPendingMessagesAcrossPartitions(context.getInteger(KEY_MAXPENDINGMESSAGESACROSSPARTITIONS, Integer.valueOf(60000)).intValue());
            this.baseBuilder.batchingMaxMessages(context.getInteger(KEY_BATCHINGMAXMESSAGES, Integer.valueOf(500)).intValue()).batchingMaxPublishDelay((long)context.getInteger(KEY_BATCHINGMAXPUBLISHDELAY, Integer.valueOf(100)).intValue(), TimeUnit.MILLISECONDS).batchingMaxBytes(context.getInteger(KEY_BATCHINGMAXBYTES, Integer.valueOf(131072)).intValue());
            this.baseBuilder.accessMode(ProducerAccessMode.Shared).messageRoutingMode(MessageRoutingMode.RoundRobinPartition).blockIfQueueFull(context.getBoolean(KEY_BLOCKIFQUEUEFULL, Boolean.valueOf(true)).booleanValue());
            this.baseBuilder.roundRobinRouterBatchingPartitionSwitchFrequency(context.getInteger(KEY_ROUNDROBINROUTERBATCHINGPARTITIONSWITCHFREQUENCY, Integer.valueOf(60)).intValue()).enableBatching(context.getBoolean(KEY_ENABLEBATCHING, Boolean.valueOf(true)).booleanValue()).compressionType(this.getPulsarCompressionType());
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        logger.info("pulsar handler started");
    }

    @Override
    public void stop() {
        for (Map.Entry<String, Producer<byte[]>> entry : this.producerMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (PulsarClientException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.client.close();
        }
        catch (PulsarClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("pulsar handler stopped");
    }

    @Override
    public void publishTopic(Set<String> topicSet) {
    }

    @Override
    public boolean send(PackProfile profile) {
        String producerTopic = null;
        try {
            IdTopicConfig idConfig = ConfigManager.getInstance().getIdTopicConfig(profile.getInlongGroupId(), profile.getInlongStreamId());
            if (idConfig == null) {
                if (!CommonConfigHolder.getInstance().isEnableUnConfigTopicAccept()) {
                    this.sinkContext.fileMetricIncWithDetailStats("sink.topic.missing", profile.getUid());
                    this.sinkContext.addSendResultMetric(profile, this.clusterName, profile.getUid(), false, 0L);
                    this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(profile);
                    profile.fail(DataProxyErrCode.GROUPID_OR_STREAMID_NOT_CONFIGURE, "");
                    return false;
                }
                producerTopic = CommonConfigHolder.getInstance().getRandDefTopics();
                if (StringUtils.isEmpty((CharSequence)producerTopic)) {
                    this.sinkContext.fileMetricIncSumStats("default.topic.empty");
                    this.sinkContext.addSendResultMetric(profile, this.clusterName, profile.getUid(), false, 0L);
                    this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(profile);
                    profile.fail(DataProxyErrCode.GROUPID_OR_STREAMID_NOT_CONFIGURE, "");
                    return false;
                }
                this.sinkContext.fileMetricIncSumStats("default.topic.used");
            } else {
                producerTopic = idConfig.getPulsarTopicName(this.tenant, this.namespace);
            }
            Producer<byte[]> producer = this.producerMap.get(producerTopic);
            if (producer == null) {
                try {
                    logger.info("try to new a object for topic " + producerTopic);
                    SecureRandom secureRandom = new SecureRandom((producerTopic + System.currentTimeMillis()).getBytes());
                    String producerName = producerTopic + "-" + secureRandom.nextLong();
                    producer = this.baseBuilder.clone().topic(producerTopic).producerName(producerName).create();
                    logger.info("create new producer success:{}", (Object)producer.getProducerName());
                    Producer<byte[]> oldProducer = this.producerMap.putIfAbsent(producerTopic, producer);
                    if (oldProducer != null) {
                        producer.close();
                        logger.info("close producer success:{}", (Object)producer.getProducerName());
                        producer = oldProducer;
                    }
                }
                catch (Throwable ex) {
                    logger.error("create new producer failed", ex);
                }
            }
            if (producer == null) {
                this.sinkContext.fileMetricIncWithDetailStats("sink.producer.null", producerTopic);
                this.sinkContext.processSendFail(profile, this.clusterName, producerTopic, 0L, DataProxyErrCode.PRODUCER_IS_NULL, "");
                return false;
            }
            if (profile instanceof SimplePackProfile) {
                this.sendSimplePackProfile((SimplePackProfile)profile, idConfig, producer, producerTopic);
            } else {
                this.sendBatchPackProfile((BatchPackProfile)profile, idConfig, producer, producerTopic);
            }
            return true;
        }
        catch (Exception ex) {
            this.sinkContext.fileMetricIncWithDetailStats("sink.send.exception", producerTopic);
            this.sinkContext.processSendFail(profile, this.clusterName, profile.getUid(), 0L, DataProxyErrCode.SEND_REQUEST_TO_MQ_FAILURE, ex.getMessage());
            if (logCounter.shouldPrint()) {
                logger.error("Send Message to Pulsar failure", (Throwable)ex);
            }
            return false;
        }
    }

    private CompressionType getPulsarCompressionType() {
        String type;
        Context context = this.sinkContext.getProducerContext();
        switch (type = context.getString(KEY_COMPRESSIONTYPE, CompressionType.SNAPPY.name())) {
            case "LZ4": {
                return CompressionType.LZ4;
            }
            case "ZLIB": {
                return CompressionType.ZLIB;
            }
            case "ZSTD": {
                return CompressionType.ZSTD;
            }
            case "SNAPPY": {
                return CompressionType.SNAPPY;
            }
        }
        return CompressionType.NONE;
    }

    private void sendBatchPackProfile(BatchPackProfile batchProfile, IdTopicConfig idConfig, Producer<byte[]> producer, String producerTopic) throws Exception {
        EventHandler handler = this.handlerLocal.get();
        if (handler == null) {
            handler = this.sinkContext.createEventHandler();
            this.handlerLocal.set(handler);
        }
        Map<String, String> headers = handler.parseHeader(idConfig, batchProfile, this.sinkContext.getNodeId(), this.sinkContext.getCompressType());
        byte[] bodyBytes = handler.parseBody(idConfig, batchProfile, this.sinkContext.getCompressType());
        this.sinkContext.addSendMetric(batchProfile, this.clusterName, producerTopic, bodyBytes.length);
        long sendTime = System.currentTimeMillis();
        CompletableFuture future = producer.newMessage().properties(headers).value((Object)bodyBytes).sendAsync();
        future.whenCompleteAsync((msgId, ex) -> {
            if (ex != null) {
                this.sinkContext.fileMetricIncSumStats("sink.failure");
                this.sinkContext.processSendFail(batchProfile, this.clusterName, producerTopic, sendTime, DataProxyErrCode.MQ_RETURN_ERROR, ex.getMessage());
                if (logCounter.shouldPrint()) {
                    logger.error("Send ProfileV1 to Pulsar failure", ex);
                }
            } else {
                this.sinkContext.fileMetricIncSumStats("sink.success");
                this.sinkContext.addSendResultMetric(batchProfile, this.clusterName, producerTopic, true, sendTime);
                this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(batchProfile);
                batchProfile.ack();
            }
        });
    }

    private void sendSimplePackProfile(SimplePackProfile simpleProfile, IdTopicConfig idConfig, Producer<byte[]> producer, String producerTopic) throws Exception {
        Map<String, String> headers = simpleProfile.getPropsToMQ();
        byte[] bodyBytes = simpleProfile.getEvent().getBody();
        this.sinkContext.addSendMetric(simpleProfile, this.clusterName, producerTopic, bodyBytes.length);
        long sendTime = System.currentTimeMillis();
        CompletableFuture future = producer.newMessage().properties(headers).value((Object)bodyBytes).sendAsync();
        future.whenCompleteAsync((msgId, ex) -> {
            if (ex != null) {
                this.sinkContext.fileMetricIncWithDetailStats("sink.failure", producerTopic);
                this.sinkContext.fileMetricAddFailCnt(simpleProfile, producerTopic, msgId.toString());
                this.sinkContext.processSendFail(simpleProfile, this.clusterName, producerTopic, sendTime, DataProxyErrCode.MQ_RETURN_ERROR, ex.getMessage());
                if (logCounter.shouldPrint()) {
                    logger.error("Send SimpleProfileV0 to Pulsar failure", ex);
                }
            } else {
                this.sinkContext.fileMetricAddSuccCnt(simpleProfile, producerTopic, msgId.toString());
                this.sinkContext.fileMetricIncSumStats("sink.success");
                this.sinkContext.addSendResultMetric(simpleProfile, this.clusterName, producerTopic, true, sendTime);
                this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(simpleProfile);
                simpleProfile.ack();
            }
        });
    }
}

