/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq.kafka;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Context;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.monitor.LogCounter;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.config.pojo.IdTopicConfig;
import org.apache.inlong.dataproxy.sink.common.EventHandler;
import org.apache.inlong.dataproxy.sink.mq.BatchPackProfile;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueHandler;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneSinkContext;
import org.apache.inlong.dataproxy.sink.mq.PackProfile;
import org.apache.inlong.dataproxy.sink.mq.SimplePackProfile;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaHandler
implements MessageQueueHandler {
    private static final Logger logger = LoggerFactory.getLogger(KafkaHandler.class);
    private static final LogCounter logCounter = new LogCounter(10, 100000, 30000);
    private CacheClusterConfig config;
    private String clusterName;
    private MessageQueueZoneSinkContext sinkContext;
    private KafkaProducer<String, byte[]> producer;
    private final ThreadLocal<EventHandler> handlerLocal = new ThreadLocal();

    @Override
    public void init(CacheClusterConfig config, MessageQueueZoneSinkContext sinkContext) {
        this.config = config;
        this.clusterName = config.getClusterName();
        this.sinkContext = sinkContext;
    }

    @Override
    public void start() {
        try {
            Properties props = new Properties();
            Context context = this.sinkContext.getProducerContext();
            props.putAll((Map<?, ?>)context.getParameters());
            props.putAll(this.config.getParams());
            logger.info("try to create kafka client:{}", (Object)props);
            this.producer = new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new ByteArraySerializer());
            logger.info("create new producer success:{}", this.producer);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void publishTopic(Set<String> topicSet) {
    }

    @Override
    public void stop() {
        this.producer.close();
        logger.info("kafka handler stopped");
    }

    @Override
    public boolean send(PackProfile profile) {
        String topic = null;
        try {
            IdTopicConfig idConfig = ConfigManager.getInstance().getIdTopicConfig(profile.getInlongGroupId(), profile.getInlongStreamId());
            if (idConfig == null) {
                if (!CommonConfigHolder.getInstance().isEnableUnConfigTopicAccept()) {
                    this.sinkContext.fileMetricIncWithDetailStats("sink.topic.missing", profile.getUid());
                    this.sinkContext.addSendResultMetric(profile, this.clusterName, profile.getUid(), false, 0L);
                    this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(profile);
                    profile.fail(DataProxyErrCode.GROUPID_OR_STREAMID_NOT_CONFIGURE, "");
                    return false;
                }
                topic = CommonConfigHolder.getInstance().getRandDefTopics();
                if (StringUtils.isEmpty((CharSequence)topic)) {
                    this.sinkContext.fileMetricIncSumStats("default.topic.empty");
                    this.sinkContext.addSendResultMetric(profile, this.clusterName, profile.getUid(), false, 0L);
                    this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(profile);
                    profile.fail(DataProxyErrCode.GROUPID_OR_STREAMID_NOT_CONFIGURE, "");
                    return false;
                }
                this.sinkContext.fileMetricIncSumStats("default.topic.used");
            } else {
                topic = idConfig.getTopicName();
            }
            if (this.producer == null) {
                this.sinkContext.fileMetricIncWithDetailStats("sink.producer.null", topic);
                this.sinkContext.processSendFail(profile, this.clusterName, topic, 0L, DataProxyErrCode.PRODUCER_IS_NULL, "");
                return false;
            }
            if (profile instanceof SimplePackProfile) {
                this.sendSimplePackProfile((SimplePackProfile)profile, idConfig, topic);
            } else {
                this.sendBatchPackProfile((BatchPackProfile)profile, idConfig, topic);
            }
            return true;
        }
        catch (Exception ex) {
            this.sinkContext.fileMetricIncWithDetailStats("sink.send.exception", topic);
            this.sinkContext.processSendFail(profile, this.clusterName, profile.getUid(), 0L, DataProxyErrCode.SEND_REQUEST_TO_MQ_FAILURE, ex.getMessage());
            if (logCounter.shouldPrint()) {
                logger.error("Send Message to Kafka failure", (Throwable)ex);
            }
            return false;
        }
    }

    private void sendBatchPackProfile(final BatchPackProfile batchProfile, IdTopicConfig idConfig, final String topic) throws Exception {
        EventHandler handler = this.handlerLocal.get();
        if (handler == null) {
            handler = this.sinkContext.createEventHandler();
            this.handlerLocal.set(handler);
        }
        Map<String, String> headers = handler.parseHeader(idConfig, batchProfile, this.sinkContext.getNodeId(), this.sinkContext.getCompressType());
        byte[] bodyBytes = handler.parseBody(idConfig, batchProfile, this.sinkContext.getCompressType());
        this.sinkContext.addSendMetric(batchProfile, this.clusterName, topic, bodyBytes.length);
        final long sendTime = System.currentTimeMillis();
        ProducerRecord producerRecord = new ProducerRecord(topic, (Object)bodyBytes);
        headers.forEach((key, value) -> producerRecord.headers().add(key, value.getBytes()));
        Callback callback = new Callback(){

            public void onCompletion(RecordMetadata arg0, Exception ex) {
                if (ex != null) {
                    KafkaHandler.this.sinkContext.fileMetricIncSumStats("sink.failure");
                    KafkaHandler.this.sinkContext.processSendFail(batchProfile, KafkaHandler.this.clusterName, topic, sendTime, DataProxyErrCode.MQ_RETURN_ERROR, ex.getMessage());
                    if (logCounter.shouldPrint()) {
                        logger.error("Send BatchPackProfile to Kafka failure", (Throwable)ex);
                    }
                } else {
                    KafkaHandler.this.sinkContext.fileMetricIncSumStats("sink.success");
                    KafkaHandler.this.sinkContext.addSendResultMetric(batchProfile, KafkaHandler.this.clusterName, topic, true, sendTime);
                    KafkaHandler.this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(batchProfile);
                    batchProfile.ack();
                }
            }
        };
        this.producer.send(producerRecord, callback);
    }

    private void sendSimplePackProfile(final SimplePackProfile simpleProfile, IdTopicConfig idConfig, final String topic) throws Exception {
        Map<String, String> headers = simpleProfile.getPropsToMQ();
        byte[] bodyBytes = simpleProfile.getEvent().getBody();
        this.sinkContext.addSendMetric(simpleProfile, this.clusterName, topic, bodyBytes.length);
        final long sendTime = System.currentTimeMillis();
        ProducerRecord producerRecord = new ProducerRecord(topic, (Object)bodyBytes);
        headers.forEach((key, value) -> producerRecord.headers().add(key, value.getBytes()));
        Callback callback = new Callback(){

            public void onCompletion(RecordMetadata arg0, Exception ex) {
                if (ex != null) {
                    KafkaHandler.this.sinkContext.fileMetricIncWithDetailStats("sink.failure", topic);
                    KafkaHandler.this.sinkContext.fileMetricAddFailCnt(simpleProfile, topic, arg0 == null ? "" : String.valueOf(arg0.partition()));
                    KafkaHandler.this.sinkContext.processSendFail(simpleProfile, KafkaHandler.this.clusterName, topic, sendTime, DataProxyErrCode.MQ_RETURN_ERROR, ex.getMessage());
                    if (logCounter.shouldPrint()) {
                        logger.error("Send SimplePackProfile to Kafka failure", (Throwable)ex);
                    }
                } else {
                    KafkaHandler.this.sinkContext.fileMetricAddSuccCnt(simpleProfile, topic, arg0 == null ? "" : String.valueOf(arg0.partition()));
                    KafkaHandler.this.sinkContext.fileMetricIncSumStats("sink.success");
                    KafkaHandler.this.sinkContext.addSendResultMetric(simpleProfile, KafkaHandler.this.clusterName, topic, true, sendTime);
                    KafkaHandler.this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(simpleProfile);
                    simpleProfile.ack();
                }
            }
        };
        this.producer.send(producerRecord, callback);
    }
}

