/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.common;

import org.apache.commons.lang.ClassUtils;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.metrics.DataProxyMetricItemSet;
import org.apache.inlong.dataproxy.metrics.stats.MonitorIndex;
import org.apache.inlong.dataproxy.metrics.stats.MonitorStats;
import org.apache.inlong.dataproxy.sink.common.EventHandler;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueHandler;
import org.apache.inlong.dataproxy.sink.mq.pulsar.PulsarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkContext {
    public static final String KEY_MAX_THREADS = "maxThreads";
    public static final String KEY_PROCESSINTERVAL = "processInterval";
    public static final String KEY_RELOADINTERVAL = "reloadInterval";
    public static final String KEY_MESSAGE_QUEUE_HANDLER = "messageQueueHandler";
    protected static final Logger logger = LoggerFactory.getLogger(SinkContext.class);
    protected final String clusterId;
    protected final String sinkName;
    protected final Context sinkContext;
    protected final Channel channel;
    protected final int maxThreads;
    protected final long processInterval;
    protected final long reloadInterval;
    protected final DataProxyMetricItemSet metricItemSet;
    protected MonitorIndex monitorIndex = null;
    private MonitorStats monitorStats = null;

    public SinkContext(String sinkName, Context context, Channel channel) {
        this.sinkName = sinkName;
        this.sinkContext = context;
        this.channel = channel;
        this.clusterId = CommonConfigHolder.getInstance().getClusterName();
        this.maxThreads = this.sinkContext.getInteger(KEY_MAX_THREADS, Integer.valueOf(10));
        this.processInterval = this.sinkContext.getInteger(KEY_PROCESSINTERVAL, Integer.valueOf(100)).intValue();
        this.reloadInterval = this.sinkContext.getLong(KEY_RELOADINTERVAL, Long.valueOf(60000L));
        this.metricItemSet = new DataProxyMetricItemSet(sinkName);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
    }

    public void start() {
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            this.monitorIndex = new MonitorIndex(CommonConfigHolder.getInstance().getFileMetricSinkOutName(), (long)CommonConfigHolder.getInstance().getFileMetricStatInvlSec() * 1000L, CommonConfigHolder.getInstance().getFileMetricStatCacheCnt());
            this.monitorStats = new MonitorStats(CommonConfigHolder.getInstance().getFileMetricEventOutName() + "#" + this.getSinkName(), (long)CommonConfigHolder.getInstance().getFileMetricStatInvlSec() * 1000L, CommonConfigHolder.getInstance().getFileMetricStatCacheCnt());
            this.monitorIndex.start();
            this.monitorStats.start();
        }
    }

    public void close() {
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            if (this.monitorIndex != null) {
                this.monitorIndex.stop();
            }
            if (this.monitorStats != null) {
                this.monitorStats.stop();
            }
        }
    }

    public void fileMetricIncSumStats(String eventKey) {
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            this.monitorStats.incSumStats(eventKey);
        }
    }

    public void fileMetricIncWithDetailStats(String eventKey, String detailInfoKey) {
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            this.monitorStats.incSumStats(eventKey);
            this.monitorStats.incDetailStats(eventKey + "#" + detailInfoKey);
        }
    }

    public void fileMetricAddSuccCnt(String key, int cnt, int packCnt, long packSize) {
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            this.monitorIndex.addSuccStats(key, cnt, packCnt, packSize);
        }
    }

    public void fileMetricAddFailCnt(String key, int failCnt) {
        if (CommonConfigHolder.getInstance().isEnableFileMetric()) {
            this.monitorIndex.addFailStats(key, failCnt);
        }
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getSinkName() {
        return this.sinkName;
    }

    public Context getSinkContext() {
        return this.sinkContext;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public long getProcessInterval() {
        return this.processInterval;
    }

    public long getReloadInterval() {
        return this.reloadInterval;
    }

    public DataProxyMetricItemSet getMetricItemSet() {
        return this.metricItemSet;
    }

    public EventHandler createEventHandler() {
        String eventHandlerClass = CommonConfigHolder.getInstance().getEventHandler();
        try {
            Class handlerClass = ClassUtils.getClass((String)eventHandlerClass);
            Object handlerObject = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (handlerObject instanceof EventHandler) {
                return (EventHandler)handlerObject;
            }
        }
        catch (Throwable t) {
            logger.error("{} fail to init EventHandler,handlerClass:{},error:{}", new Object[]{this.sinkName, eventHandlerClass, t.getMessage(), t});
        }
        return null;
    }

    public MessageQueueHandler createMessageQueueHandler(CacheClusterConfig config) {
        String strHandlerClass = config.getParams().getOrDefault(KEY_MESSAGE_QUEUE_HANDLER, PulsarHandler.class.getName());
        logger.info("{}'s mq handler class = {}", (Object)this.sinkName, (Object)strHandlerClass);
        try {
            Class handlerClass = ClassUtils.getClass((String)strHandlerClass);
            Object handlerObject = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (handlerObject instanceof MessageQueueHandler) {
                return (MessageQueueHandler)handlerObject;
            }
        }
        catch (Throwable t) {
            logger.error("{} fail to init MessageQueueHandler,handlerClass:{},error:{}", new Object[]{this.sinkName, strHandlerClass, t.getMessage(), t});
        }
        return null;
    }
}

