/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.metrics.stats;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.inlong.dataproxy.metrics.stats.AbsStatsDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorIndex
extends AbsStatsDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorIndex.class);
    private static final AtomicLong RECODE_ID = new AtomicLong(0L);
    private final StatsUnit[] statsUnits = new StatsUnit[2];

    public MonitorIndex(String name, long intervalMill, int maxCnt) {
        super(name, intervalMill, maxCnt);
        this.statsUnits[0] = new StatsUnit(name);
        this.statsUnits[1] = new StatsUnit(name);
    }

    public void addSuccStats(String key, int msgCnt, int packCnt, long packSize) {
        if (this.isStopped()) {
            return;
        }
        this.statsUnits[this.getWriteIndex()].addSuccCnt(key, msgCnt, packCnt, packSize);
    }

    public void addFailStats(String key, int failCnt) {
        if (this.isStopped()) {
            return;
        }
        this.statsUnits[this.getWriteIndex()].addFailCnt(key, failCnt);
    }

    @Override
    protected int loopProcess(long startTime) {
        return this.statsUnits[this.getReadIndex()].printAndResetStatsInfo(startTime);
    }

    @Override
    protected int exitProcess(long startTime) {
        int totalCnt = 0;
        if (!this.statsUnits[this.getReadIndex()].isEmpty()) {
            totalCnt += this.statsUnits[this.getReadIndex()].printAndResetStatsInfo(startTime);
        }
        if (!this.statsUnits[this.getWriteIndex()].isEmpty()) {
            totalCnt += this.statsUnits[this.getWriteIndex()].printAndResetStatsInfo(startTime);
        }
        return totalCnt;
    }

    private static class StatsItem {
        private final LongAdder msgCnt = new LongAdder();
        private final LongAdder packCnt = new LongAdder();
        private final LongAdder packSize = new LongAdder();
        private final LongAdder failCnt = new LongAdder();

        public void addSuccessCnt(int msgCnt, int packCnt, long packSize) {
            this.msgCnt.add(msgCnt);
            this.packCnt.add(packCnt);
            this.packSize.add(packSize);
        }

        public void addFailCnt(int failCnt) {
            this.failCnt.add(failCnt);
        }

        public String toString() {
            return this.msgCnt.longValue() + "#" + this.packCnt.longValue() + "#" + this.packSize.longValue() + "#" + this.failCnt.longValue();
        }
    }

    private static class StatsUnit {
        private final String statsName;
        private final ConcurrentHashMap<String, StatsItem> counterMap = new ConcurrentHashMap();

        public StatsUnit(String statsName) {
            this.statsName = statsName;
        }

        public boolean isEmpty() {
            return this.counterMap.isEmpty();
        }

        public void addSuccCnt(String key, int cnt, int packcnt, long packsize) {
            StatsItem tmpItem;
            StatsItem statsItem = this.counterMap.get(key);
            if (statsItem == null && (statsItem = this.counterMap.putIfAbsent(key, tmpItem = new StatsItem())) == null) {
                statsItem = tmpItem;
            }
            statsItem.addSuccessCnt(cnt, packcnt, packsize);
        }

        public void addFailCnt(String key, int failCnt) {
            StatsItem tmpItem;
            StatsItem statsItem = this.counterMap.get(key);
            if (statsItem == null && (statsItem = this.counterMap.putIfAbsent(key, tmpItem = new StatsItem())) == null) {
                statsItem = tmpItem;
            }
            statsItem.addFailCnt(failCnt);
        }

        public int printAndResetStatsInfo(long startTime) {
            int printCnt = 0;
            long printTime = startTime / 1000L;
            for (Map.Entry<String, StatsItem> entry : this.counterMap.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                LOGGER.info("{}#{}_{}#{}#{}", new Object[]{this.statsName, printTime, RECODE_ID.incrementAndGet(), entry.getKey(), entry.getValue().toString()});
                ++printCnt;
            }
            this.counterMap.clear();
            return printCnt;
        }
    }
}

