/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.metrics.audit;

import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flume.Event;
import org.apache.inlong.audit.AuditOperator;
import org.apache.inlong.audit.util.AuditConfig;
import org.apache.inlong.common.enums.DataProxyMsgEncType;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.metrics.DataProxyMetricItem;

public class AuditUtils {
    public static final int AUDIT_ID_DATAPROXY_READ_SUCCESS = 5;
    public static final int AUDIT_ID_DATAPROXY_SEND_SUCCESS = 6;

    public static void initAudit() {
        if (CommonConfigHolder.getInstance().isEnableAudit()) {
            AuditOperator.getInstance().setAuditProxy(CommonConfigHolder.getInstance().getAuditProxys());
            AuditConfig auditConfig = new AuditConfig(CommonConfigHolder.getInstance().getAuditFilePath(), CommonConfigHolder.getInstance().getAuditMaxCacheRows());
            AuditOperator.getInstance().setAuditConfig(auditConfig);
        }
    }

    public static void add(int auditID, Event event) {
        if (!CommonConfigHolder.getInstance().isEnableAudit() || event == null) {
            return;
        }
        Map headers = event.getHeaders();
        String pkgVersion = (String)headers.get("msgEnType");
        if (DataProxyMsgEncType.MSG_ENCODE_TYPE_PB.getStrId().equalsIgnoreCase(pkgVersion)) {
            String inlongGroupId = DataProxyMetricItem.getInlongGroupId(headers);
            String inlongStreamId = DataProxyMetricItem.getInlongStreamId(headers);
            long logTime = AuditUtils.getLogTime(headers);
            long msgCount = 1L;
            if (event.getHeaders().containsKey("msgcnt")) {
                msgCount = Long.parseLong((String)event.getHeaders().get("msgcnt"));
            }
            AuditOperator.getInstance().add(auditID, inlongGroupId, inlongStreamId, Long.valueOf(logTime), msgCount, (long)event.getBody().length);
        } else {
            String groupId = (String)headers.get("groupId");
            String streamId = (String)headers.get("streamId");
            long dataTime = NumberUtils.toLong((String)((String)headers.get("dt")));
            long msgCount = NumberUtils.toLong((String)((String)headers.get("msgcnt")));
            AuditOperator.getInstance().add(auditID, groupId, streamId, Long.valueOf(dataTime), msgCount, (long)event.getBody().length);
        }
    }

    public static long getLogTime(Map<String, String> headers) {
        String strLogTime = headers.get("msgTime");
        if (strLogTime == null) {
            strLogTime = headers.get("dt");
        }
        if (strLogTime == null) {
            return System.currentTimeMillis();
        }
        long logTime = NumberUtils.toLong((String)strLogTime, (long)0L);
        if (logTime == 0L) {
            logTime = System.currentTimeMillis();
        }
        return logTime;
    }

    public static long getLogTime(Event event) {
        if (event != null) {
            return AuditUtils.getLogTime(event.getHeaders());
        }
        return System.currentTimeMillis();
    }

    public static long getAuditFormatTime(long msgTime) {
        return msgTime - msgTime % CommonConfigHolder.getInstance().getAuditFormatInvlMs();
    }

    public static void send() {
        AuditOperator.getInstance().send();
    }
}

