/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.heartbeat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.common.enums.ComponentTypeEnum;
import org.apache.inlong.common.enums.NodeSrvStatus;
import org.apache.inlong.common.heartbeat.AbstractHeartbeatManager;
import org.apache.inlong.common.heartbeat.GroupHeartbeat;
import org.apache.inlong.common.heartbeat.HeartbeatMsg;
import org.apache.inlong.common.heartbeat.StreamHeartbeat;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.config.holder.SourceReportInfo;
import org.apache.inlong.dataproxy.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatManager
implements AbstractHeartbeatManager {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatManager.class);
    private final CloseableHttpClient httpClient = this.constructHttpClient();
    private final Gson gson = new GsonBuilder().create();

    public void start() {
        Thread reportHeartbeatThread = new Thread(() -> {
            while (true) {
                this.reportHeartbeat(this.buildHeartbeat());
                try {
                    TimeUnit.SECONDS.sleep(this.heartbeatInterval());
                    continue;
                }
                catch (InterruptedException e) {
                    log.error("interrupted while report heartbeat", (Throwable)e);
                    continue;
                }
                break;
            }
        });
        reportHeartbeatThread.setDaemon(true);
        reportHeartbeatThread.start();
    }

    public void reportHeartbeat(HeartbeatMsg heartbeat) {
        if (null == heartbeat) {
            return;
        }
        List<String> mgrHostPorts = CommonConfigHolder.getInstance().getManagerHosts();
        if (mgrHostPorts.isEmpty()) {
            return;
        }
        for (String managerHost : mgrHostPorts) {
            if (!this.sendHeartBeatMsg(managerHost, heartbeat)) continue;
            return;
        }
    }

    private boolean sendHeartBeatMsg(String mgrHostPort, HeartbeatMsg heartbeat) {
        String url = "http://" + mgrHostPort + "/inlong/manager/openapi" + "/heartbeat/report";
        try {
            HttpPost post = HttpUtils.getHttPost(url);
            String body = this.gson.toJson((Object)heartbeat);
            StringEntity stringEntity = new StringEntity(body);
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            String isSuccess = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200) {
                if (StringUtils.isNotEmpty((CharSequence)isSuccess) && log.isDebugEnabled()) {
                    log.debug("reportHeartbeat url {}, heartbeat: {}, return str {}", new Object[]{url, body, isSuccess});
                }
                return true;
            }
        }
        catch (Exception ex) {
            log.error("reportHeartbeat failed for url {}, exception message is {}", (Object)url, (Object)ex.getMessage());
        }
        return false;
    }

    private synchronized CloseableHttpClient constructHttpClient() {
        long timeoutInMs = TimeUnit.MILLISECONDS.toMillis(50000L);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)timeoutInMs).setSocketTimeout((int)timeoutInMs).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        return httpClientBuilder.build();
    }

    private HeartbeatMsg buildHeartbeat() {
        ConfigManager configManager = ConfigManager.getInstance();
        HeartbeatMsg heartbeatMsg = new HeartbeatMsg();
        SourceReportInfo reportInfo = configManager.getSourceReportInfo();
        if (!this.validReportInfo(reportInfo)) {
            return null;
        }
        heartbeatMsg.setNodeSrvStatus(ConfigManager.getInstance().isMqClusterReady() ? NodeSrvStatus.OK : NodeSrvStatus.SERVICE_UNREADY);
        heartbeatMsg.setIp(reportInfo.getIp());
        heartbeatMsg.setPort(reportInfo.getPort());
        heartbeatMsg.setProtocolType(reportInfo.getProtocolType());
        heartbeatMsg.setComponentType(ComponentTypeEnum.DataProxy.getType());
        heartbeatMsg.setReportTime(Long.valueOf(System.currentTimeMillis()));
        heartbeatMsg.setLoad(Integer.valueOf(65535));
        heartbeatMsg.setClusterTag(CommonConfigHolder.getInstance().getClusterTag());
        heartbeatMsg.setClusterName(CommonConfigHolder.getInstance().getClusterName());
        heartbeatMsg.setInCharges(CommonConfigHolder.getInstance().getClusterIncharges());
        heartbeatMsg.setExtTag(CommonConfigHolder.getInstance().getClusterExtTag());
        ConcurrentHashMap<String, String> groupIdMappings = configManager.getGroupIdNumMap();
        ConcurrentHashMap<String, ConcurrentHashMap<String, String>> streamIdMappings = configManager.getStreamIdNumMap();
        ArrayList<GroupHeartbeat> groupHeartbeats = new ArrayList<GroupHeartbeat>();
        for (Map.Entry<String, String> entry : groupIdMappings.entrySet()) {
            String groupIdNum = entry.getKey();
            String groupId = entry.getValue();
            GroupHeartbeat groupHeartbeat = new GroupHeartbeat();
            groupHeartbeat.setInlongGroupId(groupId);
            String status = configManager.isEnableNum2NameTrans(groupIdNum) ? "enabled" : "disabled";
            groupHeartbeat.setStatus(status);
            groupHeartbeats.add(groupHeartbeat);
        }
        heartbeatMsg.setGroupHeartbeats(groupHeartbeats);
        ArrayList<StreamHeartbeat> streamHeartbeats = new ArrayList<StreamHeartbeat>();
        for (Map.Entry<String, ConcurrentHashMap<String, String>> entry : streamIdMappings.entrySet()) {
            String groupIdNum = entry.getKey();
            String status = configManager.isEnableNum2NameTrans(groupIdNum) ? "enabled" : "disabled";
            String groupId = groupIdMappings.get(groupIdNum);
            for (Map.Entry<String, String> streamEntry : entry.getValue().entrySet()) {
                String streamId = streamEntry.getValue();
                StreamHeartbeat streamHeartbeat = new StreamHeartbeat();
                streamHeartbeat.setInlongGroupId(groupId);
                streamHeartbeat.setInlongStreamId(streamId);
                streamHeartbeat.setStatus(status);
                streamHeartbeats.add(streamHeartbeat);
            }
        }
        heartbeatMsg.setStreamHeartbeats(streamHeartbeats);
        return heartbeatMsg;
    }

    private boolean validReportInfo(SourceReportInfo reportInfo) {
        return StringUtils.isNotBlank((CharSequence)reportInfo.getIp()) && StringUtils.isNotBlank((CharSequence)reportInfo.getPort());
    }
}

