/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.holder;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.dataproxy.config.ConfigHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisitConfigHolder
extends ConfigHolder {
    private static final int MIN_NETMASK_BITS = 0;
    private static final int MAX_NETMASK_BITS = 32;
    private static final String MASKIP_NETMASK_SEP = "/";
    private static final String IPV4ADDR_TMP = "((?:(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d))))";
    private static final Logger LOG = LoggerFactory.getLogger(VisitConfigHolder.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final boolean isBlackList;
    private final ConcurrentHashMap<String, Long> confHolder = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> ipAddrHolder = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Pair<Integer, Integer>> ipSegmentHolder = new ConcurrentHashMap();

    public VisitConfigHolder(boolean isBlackList, String fileName) {
        super(fileName);
        this.isBlackList = isBlackList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean loadFromFileToHolder() {
        this.readWriteLock.writeLock().lock();
        try {
            Map<String, Long> tmpHolder = this.loadFile();
            if (tmpHolder == null) {
                boolean bl = false;
                return bl;
            }
            boolean added = false;
            boolean removed = false;
            HashSet<String> tmpKeys = new HashSet<String>();
            for (Map.Entry<String, Long> entry : this.confHolder.entrySet()) {
                if (tmpHolder.containsKey(entry.getKey())) continue;
                tmpKeys.add(entry.getKey());
            }
            for (String tmpKey : tmpKeys) {
                removed = true;
                this.confHolder.remove(tmpKey);
                if (tmpKey.contains(MASKIP_NETMASK_SEP)) {
                    this.ipSegmentHolder.remove(tmpKey);
                    continue;
                }
                this.ipAddrHolder.remove(tmpKey);
            }
            tmpKeys.clear();
            for (Map.Entry<String, Long> entry : tmpHolder.entrySet()) {
                if (entry == null || StringUtils.isBlank((CharSequence)entry.getKey()) || this.confHolder.containsKey(entry.getKey())) continue;
                this.confHolder.put(entry.getKey(), entry.getValue());
                if (entry.getKey().contains(MASKIP_NETMASK_SEP)) {
                    int netBits;
                    String subStr = entry.getKey().replaceAll(".*/", "");
                    try {
                        netBits = Integer.parseInt(subStr);
                    }
                    catch (Throwable e) {
                        tmpKeys.add(entry.getKey());
                        continue;
                    }
                    if (netBits < 0 || netBits > 32) {
                        tmpKeys.add(entry.getKey());
                        continue;
                    }
                    int hostAddrMask = -1 << 32 - netBits;
                    subStr = entry.getKey().replaceAll("/.*", "");
                    if (!subStr.matches(IPV4ADDR_TMP)) {
                        tmpKeys.add(entry.getKey());
                        continue;
                    }
                    int cidrIpAddr = this.getIPV4IntValue(subStr);
                    this.ipSegmentHolder.put(entry.getKey(), (Pair<Integer, Integer>)Pair.of((Object)(cidrIpAddr & hostAddrMask), (Object)hostAddrMask));
                } else {
                    if (!entry.getKey().matches(IPV4ADDR_TMP)) {
                        tmpKeys.add(entry.getKey());
                        continue;
                    }
                    this.ipAddrHolder.put(entry.getKey(), entry.getValue());
                }
                added = true;
            }
            if (!tmpKeys.isEmpty()) {
                if (this.isBlackList) {
                    LOG.warn("Load BlackList data error, found error data items: " + tmpKeys);
                } else {
                    LOG.warn("Load WhiteList data error, found error data items: " + tmpKeys);
                }
            }
            boolean bl = this.isBlackList && added || !this.isBlackList && removed;
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public boolean isContain(String strRemoteIP) {
        if (strRemoteIP == null) {
            return false;
        }
        if (this.ipAddrHolder.containsKey(strRemoteIP)) {
            return true;
        }
        int remoteId = this.getIPV4IntValue(strRemoteIP);
        for (Pair<Integer, Integer> subMask : this.ipSegmentHolder.values()) {
            if (subMask == null || subMask.getLeft() == null || subMask.getRight() == null || (remoteId & (Integer)subMask.getRight()) != (Integer)subMask.getLeft()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmptyConfig() {
        return this.ipAddrHolder.isEmpty() && this.ipSegmentHolder.isEmpty();
    }

    private int getIPV4IntValue(String ipv4Addr) {
        String[] addrItems = ipv4Addr.split("\\.");
        return Integer.parseInt(addrItems[0]) << 24 | Integer.parseInt(addrItems[1]) << 16 | Integer.parseInt(addrItems[2]) << 8 | Integer.parseInt(addrItems[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> loadFile() {
        HashMap<String, Long> hashMap;
        String filePath = this.getFilePath();
        if (StringUtils.isBlank((CharSequence)filePath)) {
            LOG.error("Fail to load " + this.getFileName() + " as the file path is empty");
            return null;
        }
        FileReader reader = null;
        BufferedReader br = null;
        HashMap<String, Long> configMap = new HashMap<String, Long>();
        try {
            String line;
            reader = new FileReader(filePath);
            br = new BufferedReader(reader);
            while ((line = br.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)(line = line.trim())) || line.startsWith("#") || line.startsWith(";")) continue;
                configMap.put(line, System.currentTimeMillis());
            }
            hashMap = configMap;
        }
        catch (Throwable e) {
            Map<String, Long> map;
            try {
                LOG.error("Fail to load " + this.getFileName() + ", path = {}, and e = {}", (Object)filePath, (Object)e);
                map = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(br);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Reader)br);
            return map;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Reader)br);
        return hashMap;
    }
}

