/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.holder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.dataproxy.config.ConfigHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertiesHolder
extends ConfigHolder {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesHolder.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final ConcurrentHashMap<String, String> confHolder = new ConcurrentHashMap();

    public PropertiesHolder(String fileName) {
        super(fileName);
    }

    public boolean fullUpdateConfigMap(Map<String, String> newConfigMap) {
        if (newConfigMap == null || newConfigMap.isEmpty()) {
            return false;
        }
        Map<String, String> filterMap = this.filterInValidRecords(newConfigMap);
        if (filterMap.isEmpty()) {
            LOG.info("Update properties {}, but the records are all illegal {}", (Object)this.getFileName(), newConfigMap);
            return false;
        }
        return this.compAndStorePropertiesToFile(filterMap);
    }

    public boolean insertNewConfigMap(Map<String, String> insertConfigMap) {
        return this.insertOrRemoveProperties(true, insertConfigMap);
    }

    public boolean deleteConfigMap(Map<String, String> rmvConfigMap) {
        return this.insertOrRemoveProperties(false, rmvConfigMap);
    }

    protected abstract Map<String, String> filterInValidRecords(Map<String, String> var1);

    protected abstract boolean updateCacheData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean loadFromFileToHolder() {
        this.readWriteLock.readLock().lock();
        try {
            Map<String, String> loadMap = this.loadConfigFromFile();
            if (loadMap == null || loadMap.isEmpty()) {
                LOG.debug("Load changed properties {}, but no records configured", (Object)this.getFileName());
                boolean bl = false;
                return bl;
            }
            Map<String, String> filteredMap = this.filterInValidRecords(loadMap);
            if (filteredMap.isEmpty()) {
                LOG.info("Load changed properties {}, but the records are all illegal {}", (Object)this.getFileName(), loadMap);
                boolean bl = false;
                return bl;
            }
            HashSet<String> rmvKeys = new HashSet<String>();
            for (Map.Entry<String, String> entry : this.confHolder.entrySet()) {
                if (entry == null || entry.getKey() == null || filteredMap.containsKey(entry.getKey())) continue;
                rmvKeys.add(entry.getKey());
            }
            for (String string : rmvKeys) {
                this.confHolder.remove(string);
            }
            HashSet<String> repKeys = new HashSet<String>();
            for (Map.Entry<String, String> entry : filteredMap.entrySet()) {
                if (entry.getValue().equals(this.confHolder.get(entry.getKey()))) continue;
                this.confHolder.put(entry.getKey(), entry.getValue());
                repKeys.add(entry.getKey());
            }
            if (rmvKeys.isEmpty() && repKeys.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.updateCacheData();
            LOG.info("Load changed properties {}, loaded config {}, updated holder {}, updated cache {}", new Object[]{this.getFileName(), loadMap, this.confHolder, bl});
            boolean bl2 = true;
            return bl2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private synchronized boolean insertOrRemoveProperties(boolean isInsert, Map<String, String> changeConfigMap) {
        if (changeConfigMap == null || changeConfigMap.isEmpty()) {
            return false;
        }
        Map<String, String> filteredMap = this.filterInValidRecords(changeConfigMap);
        if (filteredMap.isEmpty()) {
            LOG.info("Part {} properties {}, but the records are all illegal {}", new Object[]{isInsert ? "insert" : "remove", this.getFileName(), changeConfigMap});
            return false;
        }
        boolean changed = false;
        Map<String, String> newConfigMap = this.forkHolder();
        if (isInsert) {
            for (Map.Entry<String, String> entry : filteredMap.entrySet()) {
                String oldValue = newConfigMap.put(entry.getKey(), entry.getValue());
                if (ObjectUtils.equals((Object)oldValue, (Object)entry.getValue())) continue;
                changed = true;
            }
        } else {
            for (Map.Entry<String, String> entry : filteredMap.entrySet()) {
                String oldValue = newConfigMap.remove(entry.getKey());
                if (oldValue == null) continue;
                changed = true;
            }
        }
        if (!changed) {
            return false;
        }
        return this.compAndStorePropertiesToFile(newConfigMap);
    }

    private boolean compAndStorePropertiesToFile(Map<String, String> newConfigMap) {
        if (newConfigMap == null || newConfigMap.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Map.Entry<String, String> entry : newConfigMap.entrySet()) {
            if (entry.getValue().equals(this.confHolder.get(entry.getKey()))) continue;
            changed = true;
            break;
        }
        if (!changed) {
            for (Map.Entry<String, String> entry : this.confHolder.entrySet()) {
                if (entry == null || entry.getKey() == null || newConfigMap.containsKey(entry.getKey())) continue;
                changed = true;
                break;
            }
        }
        if (!changed) {
            return false;
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (Map.Entry<String, String> entry : newConfigMap.entrySet()) {
            lines.add(entry.getKey() + "=" + entry.getValue());
        }
        return this.storeConfigToFile(lines);
    }

    private Map<String, String> forkHolder() {
        HashMap<String, String> tmpHolder = new HashMap<String, String>();
        if (this.confHolder != null) {
            tmpHolder.putAll(this.confHolder);
        }
        return tmpHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfigToFile(List<String> configLines) {
        boolean isSuccess = false;
        String filePath = this.getFilePath();
        if (StringUtils.isBlank((CharSequence)filePath)) {
            LOG.error("Error in writing file {} as the file path is null.", (Object)this.getFileName());
            return isSuccess;
        }
        this.readWriteLock.writeLock().lock();
        try {
            File sourceFile = new File(filePath);
            File targetFile = new File(this.getNextBackupFileName());
            File tmpNewFile = new File(this.getFileName() + ".tmp");
            if (sourceFile.exists()) {
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
            FileUtils.writeLines((File)tmpNewFile, configLines);
            FileUtils.copyFile((File)tmpNewFile, (File)sourceFile);
            tmpNewFile.delete();
            isSuccess = true;
            this.setFileChanged();
        }
        catch (Throwable ex) {
            LOG.error("Error in writing file {}", (Object)this.getFileName(), (Object)ex);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadConfigFromFile() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)this.getFileName())) {
            LOG.error("Fail to load properties {} as the file name is null.", (Object)this.getFileName());
            return result;
        }
        InputStream inStream = null;
        try {
            URL url = this.getClass().getClassLoader().getResource(this.getFileName());
            InputStream inputStream = inStream = url != null ? url.openStream() : null;
            if (inStream == null) {
                LOG.error("Fail to load properties {} as the input stream is null", (Object)this.getFileName());
                HashMap<String, String> hashMap = result;
                return hashMap;
            }
            Properties props = new Properties();
            props.load(inStream);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (Throwable e) {
            LOG.error("Fail to load properties {}", (Object)this.getFileName(), (Object)e);
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOG.error("Fail in inStream.close for file {}", (Object)this.getFileName(), (Object)e);
                }
            }
        }
        return result;
    }
}

