/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.holder;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.dataproxy.CacheClusterObject;
import org.apache.inlong.common.pojo.dataproxy.CacheClusterSetObject;
import org.apache.inlong.common.pojo.dataproxy.DataProxyCluster;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfigResponse;
import org.apache.inlong.common.pojo.dataproxy.InLongIdObject;
import org.apache.inlong.common.pojo.dataproxy.ProxyClusterObject;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.config.pojo.CacheType;
import org.apache.inlong.dataproxy.config.pojo.DataType;
import org.apache.inlong.dataproxy.config.pojo.IdTopicConfig;
import org.apache.inlong.sdk.commons.protocol.InlongId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaConfigHolder
extends ConfigHolder {
    private static final String metaConfigFileName = "metadata.json";
    private static final long MAX_SYNC_WAIT_TIME_MS = CommonConfigHolder.getInstance().getMetaConfigSyncInvlMs() * 2L + 5000L;
    private static final int MAX_ALLOWED_JSON_FILE_SIZE = 314572800;
    private static final Logger LOG = LoggerFactory.getLogger(MetaConfigHolder.class);
    private static final Gson GSON = new Gson();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private String dataMd5 = "";
    private String dataStr = "";
    private String tmpDataMd5 = "";
    private final AtomicLong lastSyncTime = new AtomicLong(0L);
    private final List<String> defTopics = new ArrayList<String>();
    private final AtomicInteger clusterType = new AtomicInteger(CacheType.N.getId());
    private final ConcurrentHashMap<String, CacheClusterConfig> mqClusterMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IdTopicConfig> id2TopicMap = new ConcurrentHashMap();

    public MetaConfigHolder() {
        super(metaConfigFileName);
    }

    public void addDefTopic(String defTopic) {
        if (StringUtils.isBlank((CharSequence)defTopic)) {
            return;
        }
        this.defTopics.add(defTopic);
    }

    public String getBaseTopicName(String groupId, String streamId) {
        IdTopicConfig idTopicConfig = this.getIdTopicConfig(groupId, streamId);
        if (idTopicConfig == null) {
            return null;
        }
        return idTopicConfig.getTopicName();
    }

    public IdTopicConfig getIdTopicConfig(String groupId, String streamId) {
        IdTopicConfig idTopicConfig = null;
        if (StringUtils.isNotEmpty((CharSequence)groupId) && !this.id2TopicMap.isEmpty() && (idTopicConfig = this.id2TopicMap.get(InlongId.generateUid((String)groupId, (String)streamId))) == null) {
            idTopicConfig = this.id2TopicMap.get(groupId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get Topic Config by groupId = {}, streamId = {}, IdTopicConfig = {}", new Object[]{groupId, streamId, idTopicConfig});
        }
        return idTopicConfig;
    }

    public String getTopicName(String groupId, String streamId) {
        String topic = null;
        if (StringUtils.isNotEmpty((CharSequence)groupId) && !this.id2TopicMap.isEmpty()) {
            IdTopicConfig idTopicConfig = this.id2TopicMap.get(InlongId.generateUid((String)groupId, (String)streamId));
            if (idTopicConfig == null) {
                idTopicConfig = this.id2TopicMap.get(groupId);
            }
            if (idTopicConfig != null) {
                topic = idTopicConfig.getTopicName();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get topic by groupId = {}, streamId = {}, topic = {}", new Object[]{groupId, streamId, topic});
        }
        return topic;
    }

    public String getConfigMd5() {
        return System.currentTimeMillis() - this.lastSyncTime.get() >= MAX_SYNC_WAIT_TIME_MS ? this.dataMd5 : this.tmpDataMd5;
    }

    public boolean updateConfigMap(String inDataMd5, String inDataJsonStr) {
        if (StringUtils.isBlank((CharSequence)inDataMd5) || StringUtils.isBlank((CharSequence)inDataJsonStr) || inDataMd5.equalsIgnoreCase(this.dataMd5)) {
            return false;
        }
        if (this.storeConfigToFile(inDataJsonStr)) {
            this.tmpDataMd5 = inDataMd5;
            this.lastSyncTime.set(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public List<CacheClusterConfig> forkCachedCLusterConfig() {
        ArrayList<CacheClusterConfig> result = new ArrayList<CacheClusterConfig>();
        if (this.mqClusterMap.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, CacheClusterConfig> entry : this.mqClusterMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            CacheClusterConfig config = new CacheClusterConfig();
            config.setClusterName(entry.getValue().getClusterName());
            config.setToken(entry.getValue().getToken());
            config.getParams().putAll(entry.getValue().getParams());
            result.add(config);
        }
        return result;
    }

    public Set<String> getAllTopicName() {
        HashSet<String> result = new HashSet<String>();
        if (CommonConfigHolder.getInstance().isEnableUnConfigTopicAccept()) {
            result.addAll(CommonConfigHolder.getInstance().getDefTopics());
        }
        for (IdTopicConfig topicConfig : this.id2TopicMap.values()) {
            if (topicConfig == null) continue;
            result.add(topicConfig.getTopicName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean loadFromFileToHolder() {
        String jsonString = "";
        this.readWriteLock.readLock().lock();
        try {
            jsonString = this.loadConfigFromFile();
            if (StringUtils.isBlank((CharSequence)jsonString)) {
                LOG.info("Load changed json {}, but no records configured", (Object)this.getFileName());
                boolean bl = false;
                return bl;
            }
            DataProxyConfigResponse metaConfig = (DataProxyConfigResponse)GSON.fromJson(jsonString, DataProxyConfigResponse.class);
            if (!metaConfig.isResult().booleanValue() || metaConfig.getErrCode() != 0) {
                LOG.warn("Load failed json config from {}, error code is {}", (Object)this.getFileName(), (Object)metaConfig.getErrCode());
                boolean bl = false;
                return bl;
            }
            DataProxyCluster clusterObj = metaConfig.getData();
            if (clusterObj == null) {
                LOG.warn("Load failed json config from {}, malformed content, data is null", (Object)this.getFileName());
                boolean bl = false;
                return bl;
            }
            if (!CommonConfigHolder.getInstance().isEnableStartupUsingLocalMetaFile() && !ConfigManager.handshakeManagerOk.get()) {
                LOG.info("Failed to load json config from {}, don't obtain metadata from the Manager, and the startup via the cache file is false", (Object)this.getFileName());
                boolean bl = false;
                return bl;
            }
            if (this.updateCacheData(clusterObj)) {
                this.dataMd5 = metaConfig.getMd5();
                this.tmpDataMd5 = metaConfig.getMd5();
                this.lastSyncTime.set(System.currentTimeMillis());
                this.dataStr = jsonString;
                LOG.info("Load changed json {}, loaded dataMd5 {}, loaded data {}, updated cache ({}, {})", new Object[]{this.getFileName(), this.dataMd5, this.dataStr, this.id2TopicMap, this.mqClusterMap});
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            LOG.info("Process json {} changed data {} failure", new Object[]{this.getFileName(), jsonString, e});
            boolean bl = false;
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private boolean updateCacheData(DataProxyCluster metaConfigObj) {
        ProxyClusterObject proxyClusterObject = metaConfigObj.getProxyCluster();
        if (proxyClusterObject == null) {
            LOG.warn("Load failed json config from {}, malformed content, proxyCluster field is null", (Object)this.getFileName());
            return false;
        }
        CacheClusterSetObject clusterSetObject = metaConfigObj.getCacheClusterSet();
        if (clusterSetObject == null) {
            LOG.warn("Load failed json config from {}, malformed content, cacheClusterSet field is null", (Object)this.getFileName());
            return false;
        }
        List inLongIds = proxyClusterObject.getInlongIds();
        if (inLongIds == null) {
            LOG.warn("Load failed json config from {}, malformed content, inlongIds field is null", (Object)this.getFileName());
            return false;
        }
        CacheType mqType = CacheType.convert(clusterSetObject.getType());
        if (mqType == CacheType.N) {
            LOG.warn("Load failed json config from {}, unsupported mq type {}", (Object)this.getFileName(), (Object)clusterSetObject.getType());
            return false;
        }
        HashMap<String, CacheClusterConfig> tmpClusterConfigMap = new HashMap<String, CacheClusterConfig>();
        for (CacheClusterObject clusterObject : clusterSetObject.getCacheClusters()) {
            if (clusterObject == null || StringUtils.isBlank((CharSequence)clusterObject.getName())) continue;
            CacheClusterConfig config = new CacheClusterConfig();
            config.setClusterName(clusterObject.getName());
            config.setToken(clusterObject.getToken());
            config.getParams().putAll(clusterObject.getParams());
            tmpClusterConfigMap.put(config.getClusterName(), config);
        }
        if (tmpClusterConfigMap.isEmpty()) {
            LOG.warn("Load failed json config from {}, no valid {} mq cluster", (Object)this.getFileName(), (Object)clusterSetObject.getType());
            return false;
        }
        Map<String, IdTopicConfig> tmpTopicConfigMap = this.buildCacheTopicConfig(mqType, inLongIds);
        this.replaceCacheConfig(mqType, tmpClusterConfigMap, tmpTopicConfigMap);
        if (mqType.equals((Object)CacheType.TUBE)) {
            this.executeCallbacks();
        }
        return true;
    }

    private void replaceCacheConfig(CacheType cacheType, Map<String, CacheClusterConfig> clusterConfigMap, Map<String, IdTopicConfig> topicConfigMap) {
        this.clusterType.getAndSet(cacheType.getId());
        HashSet<String> tmpKeys = new HashSet<String>();
        for (Map.Entry<String, IdTopicConfig> entry : this.id2TopicMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null || topicConfigMap.containsKey(entry.getKey())) continue;
            tmpKeys.add(entry.getKey());
        }
        for (String string : tmpKeys) {
            this.id2TopicMap.remove(string);
        }
        this.id2TopicMap.putAll(topicConfigMap);
        tmpKeys.clear();
        for (Map.Entry<String, Object> entry : this.mqClusterMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null || clusterConfigMap.containsKey(entry.getKey())) continue;
            tmpKeys.add(entry.getKey());
        }
        for (String string : tmpKeys) {
            this.mqClusterMap.remove(string);
        }
        this.mqClusterMap.putAll(clusterConfigMap);
    }

    private Map<String, IdTopicConfig> buildCacheTopicConfig(CacheType mqType, List<InLongIdObject> inLongIds) {
        HashMap<String, IdTopicConfig> tmpTopicConfigMap = new HashMap<String, IdTopicConfig>();
        if (inLongIds.isEmpty()) {
            return tmpTopicConfigMap;
        }
        for (InLongIdObject idObject : inLongIds) {
            String streamId;
            String groupId;
            if (idObject == null || StringUtils.isBlank((CharSequence)idObject.getInlongId()) || StringUtils.isBlank((CharSequence)idObject.getTopic())) continue;
            String[] idItems = idObject.getInlongId().split("\\.");
            if (idItems.length == 2) {
                if (StringUtils.isBlank((CharSequence)idItems[0])) continue;
                groupId = idItems[0].trim();
                streamId = idItems[1].trim();
            } else {
                groupId = idObject.getInlongId().trim();
                streamId = "";
            }
            String topicName = idObject.getTopic().trim();
            int index = topicName.lastIndexOf(47);
            if (index >= 0) {
                topicName = topicName.substring(index + 1).trim();
            }
            String tenant = idObject.getParams().getOrDefault("tenant", "");
            String nameSpace = idObject.getParams().getOrDefault("namespace", "");
            if (StringUtils.isBlank((CharSequence)idObject.getTopic())) continue;
            if (mqType.equals((Object)CacheType.TUBE)) {
                topicName = nameSpace;
            } else if (mqType.equals((Object)CacheType.KAFKA) && topicName.equals(streamId)) {
                topicName = String.format("%s.%s", nameSpace, topicName);
            }
            IdTopicConfig tmpConfig = new IdTopicConfig();
            tmpConfig.setInlongGroupIdAndStreamId(groupId, streamId);
            tmpConfig.setTenantAndNameSpace(tenant, nameSpace);
            tmpConfig.setTopicName(topicName);
            tmpConfig.setParams(idObject.getParams());
            tmpConfig.setDataType(DataType.convert(idObject.getParams().getOrDefault("dataType", DataType.TEXT.value())));
            tmpConfig.setFieldDelimiter(idObject.getParams().getOrDefault("fieldDelimiter", "|"));
            tmpConfig.setFileDelimiter(idObject.getParams().getOrDefault("fileDelimiter", "\n"));
            tmpTopicConfigMap.put(tmpConfig.getUid(), tmpConfig);
            if (!mqType.equals((Object)CacheType.TUBE) || tmpConfig.getUid().equals(tmpConfig.getInlongGroupId()) || tmpTopicConfigMap.get(tmpConfig.getInlongGroupId()) != null) continue;
            IdTopicConfig tmpConfig2 = new IdTopicConfig();
            tmpConfig2.setInlongGroupIdAndStreamId(groupId, "");
            tmpConfig.setTenantAndNameSpace(tenant, nameSpace);
            tmpConfig2.setTopicName(topicName);
            tmpConfig2.setDataType(tmpConfig.getDataType());
            tmpConfig2.setFieldDelimiter(tmpConfig.getFieldDelimiter());
            tmpConfig2.setFileDelimiter(tmpConfig.getFileDelimiter());
            tmpConfig2.setParams(tmpConfig.getParams());
            tmpTopicConfigMap.put(tmpConfig.getUid(), tmpConfig2);
        }
        return tmpTopicConfigMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfigToFile(String metaJsonStr) {
        boolean isSuccess = false;
        String filePath = this.getFilePath();
        if (StringUtils.isBlank((CharSequence)filePath)) {
            LOG.error("Error in writing file {} as the file path is null.", (Object)this.getFileName());
            return isSuccess;
        }
        this.readWriteLock.writeLock().lock();
        try {
            File sourceFile = new File(filePath);
            File targetFile = new File(this.getNextBackupFileName());
            File tmpNewFile = new File(this.getFileName() + ".tmp");
            if (sourceFile.exists()) {
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
            FileUtils.writeStringToFile((File)tmpNewFile, (String)metaJsonStr, (Charset)StandardCharsets.UTF_8);
            FileUtils.copyFile((File)tmpNewFile, (File)sourceFile);
            tmpNewFile.delete();
            isSuccess = true;
            this.setFileChanged();
        }
        catch (Throwable ex) {
            LOG.error("Error in writing file {}", (Object)this.getFileName(), (Object)ex);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadConfigFromFile() {
        String result = "";
        if (StringUtils.isBlank((CharSequence)this.getFileName())) {
            LOG.error("Fail to load json {} as the file name is null.", (Object)this.getFileName());
            return result;
        }
        InputStream inStream = null;
        try {
            URL url = this.getClass().getClassLoader().getResource(this.getFileName());
            InputStream inputStream = inStream = url != null ? url.openStream() : null;
            if (inStream == null) {
                LOG.error("Fail to load json {} as the input stream is null", (Object)this.getFileName());
                String string = result;
                return string;
            }
            int size = inStream.available();
            if (size > 314572800) {
                LOG.error("Fail to load json {} as the content size({}) over max allowed size({})", new Object[]{this.getFileName(), size, 314572800});
                String e = result;
                return e;
            }
            byte[] buffer = new byte[size];
            inStream.read(buffer);
            result = new String(buffer, StandardCharsets.UTF_8);
        }
        catch (Throwable e) {
            LOG.error("Fail to load json {}", (Object)this.getFileName(), (Object)e);
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOG.error("Fail in inStream.close for file {}", (Object)this.getFileName(), (Object)e);
                }
            }
        }
        return result;
    }
}

