/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config;

import com.google.gson.Gson;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.common.pojo.dataproxy.DataProxyCluster;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfigRequest;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfigResponse;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigHolder;
import org.apache.inlong.dataproxy.config.holder.BlackListConfigHolder;
import org.apache.inlong.dataproxy.config.holder.ConfigUpdateCallback;
import org.apache.inlong.dataproxy.config.holder.GroupIdNumConfigHolder;
import org.apache.inlong.dataproxy.config.holder.MetaConfigHolder;
import org.apache.inlong.dataproxy.config.holder.SourceReportConfigHolder;
import org.apache.inlong.dataproxy.config.holder.SourceReportInfo;
import org.apache.inlong.dataproxy.config.holder.WeightConfigHolder;
import org.apache.inlong.dataproxy.config.holder.WhiteListConfigHolder;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.config.pojo.IdTopicConfig;
import org.apache.inlong.dataproxy.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigManager.class);
    public static final List<ConfigHolder> CONFIG_HOLDER_LIST = new ArrayList<ConfigHolder>();
    public static final AtomicBoolean handshakeManagerOk = new AtomicBoolean(false);
    private static volatile boolean isInit = false;
    private static ConfigManager instance = null;
    private final WeightConfigHolder weightConfigHolder = new WeightConfigHolder();
    private final BlackListConfigHolder blacklistConfigHolder = new BlackListConfigHolder();
    private final WhiteListConfigHolder whitelistConfigHolder = new WhiteListConfigHolder();
    private final GroupIdNumConfigHolder groupIdConfig = new GroupIdNumConfigHolder();
    private final MetaConfigHolder metaConfigHolder = new MetaConfigHolder();
    private final SourceReportConfigHolder sourceReportConfigHolder = new SourceReportConfigHolder();
    private volatile boolean mqClusterReady = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigManager getInstance() {
        if (isInit && instance != null) {
            return instance;
        }
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (!isInit) {
                instance = new ConfigManager();
                for (ConfigHolder holder : CONFIG_HOLDER_LIST) {
                    holder.loadFromFileToHolder();
                }
                ReloadConfigWorker reloadProperties = ReloadConfigWorker.create(instance);
                reloadProperties.setDaemon(true);
                reloadProperties.start();
                isInit = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public double getCpuWeight() {
        return this.weightConfigHolder.getCachedCpuWeight();
    }

    public double getNetInWeight() {
        return this.weightConfigHolder.getCachedNetInWeight();
    }

    public double getNetOutWeight() {
        return this.weightConfigHolder.getCachedNetOutWeight();
    }

    public double getTcpWeight() {
        return this.weightConfigHolder.getCachedTcpWeight();
    }

    public double getCpuThresholdWeight() {
        return this.weightConfigHolder.getCachedCpuThreshold();
    }

    public String getTopicName(String groupId, String streamId) {
        return this.metaConfigHolder.getBaseTopicName(groupId, streamId);
    }

    public IdTopicConfig getIdTopicConfig(String groupId, String streamId) {
        return this.metaConfigHolder.getIdTopicConfig(groupId, streamId);
    }

    public String getMetaConfigMD5() {
        return this.metaConfigHolder.getConfigMd5();
    }

    public boolean updateMetaConfigInfo(String inDataMd5, String inDataJsonStr) {
        return this.metaConfigHolder.updateConfigMap(inDataMd5, inDataJsonStr);
    }

    public void regMetaConfigChgCallback(ConfigUpdateCallback callback) {
        this.metaConfigHolder.addUpdateCallback(callback);
    }

    public List<CacheClusterConfig> getCachedCLusterConfig() {
        return this.metaConfigHolder.forkCachedCLusterConfig();
    }

    public Set<String> getAllTopicNames() {
        return this.metaConfigHolder.getAllTopicName();
    }

    public boolean isEnableNum2NameTrans(String groupIdNum) {
        return this.groupIdConfig.isEnableNum2NameTrans(groupIdNum);
    }

    public boolean isGroupIdNumConfigEmpty() {
        return this.groupIdConfig.isGroupIdNumConfigEmpty();
    }

    public boolean isStreamIdNumConfigEmpty() {
        return this.groupIdConfig.isStreamIdNumConfigEmpty();
    }

    public String getGroupIdNameByNum(String groupIdNum) {
        return this.groupIdConfig.getGroupIdNameByNum(groupIdNum);
    }

    public String getStreamIdNameByIdNum(String groupIdNum, String streamIdNum) {
        return this.groupIdConfig.getStreamIdNameByIdNum(groupIdNum, streamIdNum);
    }

    public ConcurrentHashMap<String, String> getGroupIdNumMap() {
        return this.groupIdConfig.getGroupIdNumMap();
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, String>> getStreamIdNumMap() {
        return this.groupIdConfig.getStreamIdNumMap();
    }

    public void regIPVisitConfigChgCallback(ConfigUpdateCallback callback) {
        this.blacklistConfigHolder.addUpdateCallback(callback);
        this.whitelistConfigHolder.addUpdateCallback(callback);
    }

    public boolean needChkIllegalIP() {
        return this.blacklistConfigHolder.needCheckBlacklist() || this.whitelistConfigHolder.needCheckWhitelist();
    }

    public boolean isIllegalIP(String strRemoteIP) {
        return strRemoteIP == null || this.blacklistConfigHolder.isIllegalIP(strRemoteIP) || this.whitelistConfigHolder.isIllegalIP(strRemoteIP);
    }

    public void addSourceReportInfo(String sourceIp, String sourcePort, String protocolType) {
        this.sourceReportConfigHolder.addSourceInfo(sourceIp, sourcePort, protocolType);
    }

    public SourceReportInfo getSourceReportInfo() {
        return this.sourceReportConfigHolder.getSourceReportInfo();
    }

    public boolean isMqClusterReady() {
        return this.mqClusterReady;
    }

    public void setMqClusterReady() {
        this.mqClusterReady = true;
    }

    public static class ReloadConfigWorker
    extends Thread {
        private final ConfigManager configManager;
        private final CloseableHttpClient httpClient;
        private final Gson gson = new Gson();
        private boolean isRunning = true;
        private final AtomicInteger managerIpListIndex = new AtomicInteger(0);

        private ReloadConfigWorker(ConfigManager managerInstance) {
            this.configManager = managerInstance;
            this.httpClient = this.constructHttpClient();
            SecureRandom random = new SecureRandom(String.valueOf(System.currentTimeMillis()).getBytes());
            this.managerIpListIndex.set(random.nextInt());
        }

        public static ReloadConfigWorker create(ConfigManager managerInstance) {
            return new ReloadConfigWorker(managerInstance);
        }

        @Override
        public void run() {
            long count = 0L;
            boolean fisrtCheck = true;
            LOG.info("Reload-Config Worker started!");
            while (this.isRunning) {
                ++count;
                long startTime = System.currentTimeMillis();
                try {
                    for (ConfigHolder holder : CONFIG_HOLDER_LIST) {
                        if (!holder.checkAndUpdateHolder()) continue;
                        holder.executeCallbacks();
                    }
                    if (fisrtCheck) {
                        fisrtCheck = false;
                        this.checkRemoteConfig();
                        count = 0L;
                    } else if (count % 3L == 0L) {
                        this.checkRemoteConfig();
                        count = 0L;
                    }
                    long wstTime = System.currentTimeMillis() - startTime;
                    if (wstTime > 60000L) {
                        LOG.warn("Reload-Config Worker process wast({}) over 60000 millis", (Object)wstTime);
                    }
                    TimeUnit.MILLISECONDS.sleep(CommonConfigHolder.getInstance().getMetaConfigSyncInvlMs() + (long)this.getRandom(0, 5000));
                }
                catch (InterruptedException ex1) {
                    LOG.error("Reload-Config Worker encounters an interrupt exception, break processing", (Throwable)ex1);
                    break;
                }
                catch (Throwable ex2) {
                    LOG.error("Reload-Config Worker encounters exception, continue process", ex2);
                }
            }
            LOG.info("Reload-Config Worker existed!");
        }

        public void close() {
            this.isRunning = false;
        }

        private synchronized CloseableHttpClient constructHttpClient() {
            long timeoutInMs = TimeUnit.MILLISECONDS.toMillis(50000L);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)timeoutInMs).setSocketTimeout((int)timeoutInMs).build();
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            return httpClientBuilder.build();
        }

        private int getRandom(int min, int max) {
            return (int)(Math.random() * (double)(max + 1 - min)) + min;
        }

        private void checkRemoteConfig() {
            String host;
            String proxyClusterName = CommonConfigHolder.getInstance().getClusterName();
            String proxyClusterTag = CommonConfigHolder.getInstance().getClusterTag();
            if (StringUtils.isBlank((CharSequence)proxyClusterName) || StringUtils.isBlank((CharSequence)proxyClusterTag)) {
                LOG.error("Found {} or {} is blank in {}, can't quest remote configure!", new Object[]{"proxy.cluster.name", "proxy.cluster.tag", "common.properties"});
                return;
            }
            List<String> managerIpList = CommonConfigHolder.getInstance().getManagerHosts();
            if (managerIpList == null || managerIpList.size() == 0) {
                LOG.error("Found manager ip list are empty, can't quest remote configure!");
                return;
            }
            int managerIpSize = managerIpList.size();
            for (int i = 0; i < managerIpList.size() && !this.reloadDataProxyConfig(proxyClusterName, proxyClusterTag, host = managerIpList.get(Math.abs(this.managerIpListIndex.getAndIncrement()) % managerIpSize)); ++i) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean reloadDataProxyConfig(String clusterName, String clusterTag, String host) {
            String url = null;
            HttpPost httpPost = null;
            try {
                url = "http://" + host + "/inlong/manager/openapi" + "/dataproxy/getAllConfig";
                httpPost = HttpUtils.getHttPost(url);
                DataProxyConfigRequest request = new DataProxyConfigRequest();
                request.setClusterName(clusterName);
                request.setClusterTag(clusterTag);
                if (StringUtils.isNotBlank((CharSequence)this.configManager.getMetaConfigMD5())) {
                    request.setMd5(this.configManager.getMetaConfigMD5());
                }
                httpPost.setEntity((HttpEntity)HttpUtils.getEntity(request));
                LOG.info("Start to request {} to get config info, with params: {}, headers: {}", new Object[]{url, request, httpPost.getAllHeaders()});
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
                String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() != 200) {
                    LOG.warn("Failed to request {}, with params: {}, headers: {}, the response is {}", new Object[]{url, request, httpPost.getAllHeaders(), returnStr});
                    boolean bl = false;
                    return bl;
                }
                LOG.info("End to request {} to get config info:{}", (Object)url, (Object)returnStr);
                DataProxyConfigResponse proxyResponse = (DataProxyConfigResponse)this.gson.fromJson(returnStr, DataProxyConfigResponse.class);
                if (!proxyResponse.isResult().booleanValue()) {
                    LOG.warn("Fail to get config from url {}, with params {}, error code is {}", new Object[]{url, request, proxyResponse.getErrCode()});
                    boolean bl = false;
                    return bl;
                }
                if (proxyResponse.getErrCode() != 0) {
                    if (proxyResponse.getErrCode() != 1) {
                        LOG.warn("Get config failure from url:{}, with params {}, error code is {}", new Object[]{url, request, proxyResponse.getErrCode()});
                    }
                    boolean bl = true;
                    return bl;
                }
                DataProxyCluster dataProxyCluster = proxyResponse.getData();
                if (dataProxyCluster == null || dataProxyCluster.getCacheClusterSet() == null || dataProxyCluster.getCacheClusterSet().getCacheClusters().isEmpty()) {
                    LOG.warn("Get config empty from url:{}, with params {}, return:{}, cluster is empty!", new Object[]{url, request, returnStr});
                    boolean bl = true;
                    return bl;
                }
                if (this.configManager.updateMetaConfigInfo(proxyResponse.getMd5(), returnStr)) {
                    handshakeManagerOk.set(true);
                    LOG.info("Get config success from manager and updated, set handshake status is ok!");
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable ex) {
                LOG.error("Request manager {} failure, throw exception", url, (Object)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
            }
        }
    }
}

