/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config;

import com.google.common.base.Splitter;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.config.holder.ConfigUpdateCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigHolder {
    public static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)"&").trimResults().withKeyValueSeparator("=");
    private static final Logger LOG = LoggerFactory.getLogger(ConfigHolder.class);
    private final String fileName;
    private final AtomicBoolean fileChanged = new AtomicBoolean(false);
    private final List<ConfigUpdateCallback> callbackList = new ArrayList<ConfigUpdateCallback>();
    private long lastModifyTime;
    private String filePath;
    private File configFile;

    public ConfigHolder(String fileName) {
        this.fileName = fileName;
        this.setFilePath(fileName);
        ConfigManager.CONFIG_HOLDER_LIST.add(this);
        if (this.configFile != null) {
            this.lastModifyTime = this.configFile.lastModified();
        }
    }

    public void addUpdateCallback(ConfigUpdateCallback callback) {
        this.callbackList.add(callback);
    }

    public void executeCallbacks() {
        for (ConfigUpdateCallback callback : this.callbackList) {
            callback.update();
        }
    }

    protected abstract boolean loadFromFileToHolder();

    public boolean checkAndUpdateHolder() {
        if (this.fileChanged.compareAndSet(true, false) || this.configFile != null && this.configFile.lastModified() != this.lastModifyTime) {
            if (this.configFile != null) {
                this.lastModifyTime = this.configFile.lastModified();
            }
            LOG.info("File {} has changed, reload from local file", (Object)this.fileName);
            return this.loadFromFileToHolder();
        }
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getNextBackupFileName() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = format.format(new Date(System.currentTimeMillis()));
        return this.getFilePath() + "." + dateStr;
    }

    public String getFilePath() {
        return this.filePath;
    }

    private void setFilePath(String fileName) {
        URL url = this.getClass().getClassLoader().getResource(fileName);
        if (url != null) {
            this.filePath = url.getPath();
            this.configFile = new File(this.filePath);
            LOG.info("Set {} file path, lastTime: {}, currentTime: {}", new Object[]{fileName, this.lastModifyTime, this.configFile.lastModified()});
        }
    }

    public void setFileChanged() {
        this.fileChanged.set(true);
    }
}

