/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadUtils.class);

    public static void threadThrowableHandler(Thread t, Throwable e) {
        if (AgentUtils.enableOOMExit()) {
            ThreadUtils.handleOOM(t, e);
        }
    }

    private static void handleOOM(Thread t, Throwable e) {
        if (ExceptionUtils.indexOfThrowable((Throwable)e, OutOfMemoryError.class) != -1) {
            LOGGER.error("Agent exit caused by {} OutOfMemory: ", (Object)t.getName(), (Object)e);
            ThreadUtils.forceShutDown();
        }
    }

    private static void forceShutDown() {
        try {
            Runtime.getRuntime().exit(-1);
        }
        catch (Throwable e) {
            LOGGER.error("exit failed, just halt, exception: ", e);
            Runtime.getRuntime().halt(-2);
        }
    }
}

