/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.state;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.agent.state.State;
import org.apache.inlong.agent.state.StateCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStateWrapper
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStateWrapper.class);
    private final Map<Pair<State, State>, StateCallback> callBacks = new HashMap<Pair<State, State>, StateCallback>();
    private volatile State currentState = State.ACCEPTED;

    public AbstractStateWrapper() {
        this.addCallbacks();
    }

    public abstract void addCallbacks();

    public AbstractStateWrapper addCallback(State begin, State end, StateCallback callback) {
        this.callBacks.put((Pair<State, State>)new ImmutablePair((Object)begin, (Object)end), callback);
        return this;
    }

    public synchronized void doChangeState(State nextState) {
        LOGGER.debug("state change, current state is {}, next state is {}", (Object)this.currentState, (Object)nextState);
        ImmutablePair statePair = new ImmutablePair((Object)this.currentState, (Object)nextState);
        StateCallback callback = this.callBacks.get(statePair);
        this.currentState = nextState;
        if (callback != null) {
            callback.call(this.currentState, nextState);
        }
    }

    public boolean isException() {
        State tmpState = this.currentState;
        return State.KILLED.equals((Object)tmpState) || State.FAILED.equals((Object)tmpState) || State.FATAL.equals((Object)tmpState);
    }

    public boolean isFinished() {
        State tmpState = this.currentState;
        return State.FATAL.equals((Object)tmpState) || State.SUCCEEDED.equals((Object)tmpState) || State.KILLED.equals((Object)tmpState);
    }

    public boolean isSuccess() {
        return State.SUCCEEDED.equals((Object)this.currentState);
    }

    public boolean isFailed() {
        return State.FAILED.equals((Object)this.currentState);
    }

    public boolean isFatal() {
        State tmpState = this.currentState;
        return State.FATAL.equals((Object)tmpState) || State.KILLED.equals((Object)tmpState);
    }

    public State getCurrentState() {
        return this.currentState;
    }
}

