/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.pojo;

import com.google.gson.Gson;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.pojo.DbCollectorTask;

public class SqlJobProfileDto {
    public static final String SQL_JOB = "SQL_JOB";
    public static final String DEFAULT_CHANNEL = "org.apache.inlong.agent.plugin.channel.MemoryChannel";
    public static final String DEFAULT_DATAPROXY_SINK = "org.apache.inlong.agent.plugin.sinks.ProxySink";
    public static final String DEFAULT_SOURCE = "org.apache.inlong.agent.plugin.sources.DatabaseSqlSource";
    private static final Gson GSON = new Gson();
    private Job job;
    private Proxy proxy;

    private static Job getJob(DbCollectorTask task) {
        Sql sql = new Sql();
        sql.setHostname(task.getIp());
        sql.setPort(task.getDbport());
        sql.setUser(task.getUser());
        sql.setPassword(task.getPassword());
        sql.setCommand(task.getSqlStatement());
        Job job = new Job();
        job.setId(Integer.parseInt(task.getId()));
        job.setName(SQL_JOB);
        job.setSource(DEFAULT_SOURCE);
        job.setSink(DEFAULT_DATAPROXY_SINK);
        job.setChannel(DEFAULT_CHANNEL);
        job.setDbName(task.getDbName());
        job.setTotalLimit(task.getTotalLimit());
        job.setOnceLimit(task.getOnceLimit());
        job.setTimeLimit(task.getTimeLimit());
        job.setRetryTimes(task.getRetryTimes());
        job.setSql(sql);
        return job;
    }

    private static Proxy getProxy(DbCollectorTask task) {
        Proxy proxy = new Proxy();
        Manager manager = new Manager();
        AgentConfiguration agentConf = AgentConfiguration.getAgentConf();
        manager.setHost(agentConf.get("agent.manager.vip.http.host"));
        manager.setPort(agentConf.get("agent.manager.vip.http.port"));
        proxy.setInlongGroupId(task.getInlongGroupId());
        proxy.setInlongStreamId(task.getInlongStreamId());
        proxy.setManager(manager);
        return proxy;
    }

    public static JobProfile convertToJobProfile(DbCollectorTask task) {
        if (!task.isValid()) {
            throw new IllegalArgumentException("input task" + task + "is invalid please check");
        }
        SqlJobProfileDto profileDto = new SqlJobProfileDto();
        Proxy proxy = SqlJobProfileDto.getProxy(task);
        Job job = SqlJobProfileDto.getJob(task);
        profileDto.setProxy(proxy);
        profileDto.setJob(job);
        return JobProfile.parseJsonStr(GSON.toJson((Object)profileDto));
    }

    public Job getJob() {
        return this.job;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlJobProfileDto)) {
            return false;
        }
        SqlJobProfileDto other = (SqlJobProfileDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Job this$job = this.getJob();
        Job other$job = other.getJob();
        if (this$job == null ? other$job != null : !((Object)this$job).equals(other$job)) {
            return false;
        }
        Proxy this$proxy = this.getProxy();
        Proxy other$proxy = other.getProxy();
        return !(this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlJobProfileDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Job $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
        Proxy $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        return result;
    }

    public String toString() {
        return "SqlJobProfileDto(job=" + this.getJob() + ", proxy=" + this.getProxy() + ")";
    }

    public static class Proxy {
        private String inlongGroupId;
        private String inlongStreamId;
        private Manager manager;

        public String getInlongGroupId() {
            return this.inlongGroupId;
        }

        public String getInlongStreamId() {
            return this.inlongStreamId;
        }

        public Manager getManager() {
            return this.manager;
        }

        public void setInlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
        }

        public void setInlongStreamId(String inlongStreamId) {
            this.inlongStreamId = inlongStreamId;
        }

        public void setManager(Manager manager) {
            this.manager = manager;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Proxy)) {
                return false;
            }
            Proxy other = (Proxy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$inlongGroupId = this.getInlongGroupId();
            String other$inlongGroupId = other.getInlongGroupId();
            if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
                return false;
            }
            String this$inlongStreamId = this.getInlongStreamId();
            String other$inlongStreamId = other.getInlongStreamId();
            if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
                return false;
            }
            Manager this$manager = this.getManager();
            Manager other$manager = other.getManager();
            return !(this$manager == null ? other$manager != null : !((Object)this$manager).equals(other$manager));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Proxy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $inlongGroupId = this.getInlongGroupId();
            result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
            String $inlongStreamId = this.getInlongStreamId();
            result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
            Manager $manager = this.getManager();
            result = result * 59 + ($manager == null ? 43 : ((Object)$manager).hashCode());
            return result;
        }

        public String toString() {
            return "SqlJobProfileDto.Proxy(inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", manager=" + this.getManager() + ")";
        }
    }

    public static class Manager {
        private String port;
        private String host;

        public String getPort() {
            return this.port;
        }

        public String getHost() {
            return this.host;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Manager)) {
                return false;
            }
            Manager other = (Manager)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$port = this.getPort();
            String other$port = other.getPort();
            if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Manager;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : $port.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "SqlJobProfileDto.Manager(port=" + this.getPort() + ", host=" + this.getHost() + ")";
        }
    }

    public static class Job {
        private int id;
        private String name;
        private String source;
        private String sink;
        private String channel;
        private String dbName;
        private Integer totalLimit;
        private Integer onceLimit;
        private Integer timeLimit;
        private Integer retryTimes;
        private Sql sql;

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getSource() {
            return this.source;
        }

        public String getSink() {
            return this.sink;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getDbName() {
            return this.dbName;
        }

        public Integer getTotalLimit() {
            return this.totalLimit;
        }

        public Integer getOnceLimit() {
            return this.onceLimit;
        }

        public Integer getTimeLimit() {
            return this.timeLimit;
        }

        public Integer getRetryTimes() {
            return this.retryTimes;
        }

        public Sql getSql() {
            return this.sql;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setSink(String sink) {
            this.sink = sink;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public void setTotalLimit(Integer totalLimit) {
            this.totalLimit = totalLimit;
        }

        public void setOnceLimit(Integer onceLimit) {
            this.onceLimit = onceLimit;
        }

        public void setTimeLimit(Integer timeLimit) {
            this.timeLimit = timeLimit;
        }

        public void setRetryTimes(Integer retryTimes) {
            this.retryTimes = retryTimes;
        }

        public void setSql(Sql sql) {
            this.sql = sql;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Job)) {
                return false;
            }
            Job other = (Job)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            Integer this$totalLimit = this.getTotalLimit();
            Integer other$totalLimit = other.getTotalLimit();
            if (this$totalLimit == null ? other$totalLimit != null : !((Object)this$totalLimit).equals(other$totalLimit)) {
                return false;
            }
            Integer this$onceLimit = this.getOnceLimit();
            Integer other$onceLimit = other.getOnceLimit();
            if (this$onceLimit == null ? other$onceLimit != null : !((Object)this$onceLimit).equals(other$onceLimit)) {
                return false;
            }
            Integer this$timeLimit = this.getTimeLimit();
            Integer other$timeLimit = other.getTimeLimit();
            if (this$timeLimit == null ? other$timeLimit != null : !((Object)this$timeLimit).equals(other$timeLimit)) {
                return false;
            }
            Integer this$retryTimes = this.getRetryTimes();
            Integer other$retryTimes = other.getRetryTimes();
            if (this$retryTimes == null ? other$retryTimes != null : !((Object)this$retryTimes).equals(other$retryTimes)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$sink = this.getSink();
            String other$sink = other.getSink();
            if (this$sink == null ? other$sink != null : !this$sink.equals(other$sink)) {
                return false;
            }
            String this$channel = this.getChannel();
            String other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
                return false;
            }
            String this$dbName = this.getDbName();
            String other$dbName = other.getDbName();
            if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
                return false;
            }
            Sql this$sql = this.getSql();
            Sql other$sql = other.getSql();
            return !(this$sql == null ? other$sql != null : !((Object)this$sql).equals(other$sql));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Job;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            Integer $totalLimit = this.getTotalLimit();
            result = result * 59 + ($totalLimit == null ? 43 : ((Object)$totalLimit).hashCode());
            Integer $onceLimit = this.getOnceLimit();
            result = result * 59 + ($onceLimit == null ? 43 : ((Object)$onceLimit).hashCode());
            Integer $timeLimit = this.getTimeLimit();
            result = result * 59 + ($timeLimit == null ? 43 : ((Object)$timeLimit).hashCode());
            Integer $retryTimes = this.getRetryTimes();
            result = result * 59 + ($retryTimes == null ? 43 : ((Object)$retryTimes).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $sink = this.getSink();
            result = result * 59 + ($sink == null ? 43 : $sink.hashCode());
            String $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
            String $dbName = this.getDbName();
            result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
            Sql $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : ((Object)$sql).hashCode());
            return result;
        }

        public String toString() {
            return "SqlJobProfileDto.Job(id=" + this.getId() + ", name=" + this.getName() + ", source=" + this.getSource() + ", sink=" + this.getSink() + ", channel=" + this.getChannel() + ", dbName=" + this.getDbName() + ", totalLimit=" + this.getTotalLimit() + ", onceLimit=" + this.getOnceLimit() + ", timeLimit=" + this.getTimeLimit() + ", retryTimes=" + this.getRetryTimes() + ", sql=" + this.getSql() + ")";
        }
    }

    public static class Sql {
        private String user;
        private String password;
        private String hostname;
        private Integer port;
        private String command;

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getCommand() {
            return this.command;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sql)) {
                return false;
            }
            Sql other = (Sql)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
                return false;
            }
            String this$command = this.getCommand();
            String other$command = other.getCommand();
            return !(this$command == null ? other$command != null : !this$command.equals(other$command));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sql;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            String $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            return result;
        }

        public String toString() {
            return "SqlJobProfileDto.Sql(user=" + this.getUser() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", command=" + this.getCommand() + ")";
        }
    }
}

