/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.metrics.audit;

import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.audit.AuditOperator;
import org.apache.inlong.audit.util.AuditConfig;

public class AuditUtils {
    public static final String AUDIT_KEY_FILE_PATH = "audit.filePath";
    public static final String AUDIT_DEFAULT_FILE_PATH = "/data/inlong/audit/";
    public static final String AUDIT_KEY_MAX_CACHE_ROWS = "audit.maxCacheRows";
    public static final int AUDIT_DEFAULT_MAX_CACHE_ROWS = 2000000;
    public static final int AUDIT_ID_AGENT_READ_SUCCESS = 3;
    public static final int AUDIT_ID_AGENT_SEND_SUCCESS = 4;
    private static boolean IS_AUDIT = true;

    public static void initAudit() {
        AgentConfiguration conf = AgentConfiguration.getAgentConf();
        IS_AUDIT = conf.getBoolean("audit.enable", true);
        if (IS_AUDIT) {
            String strIpPorts = conf.get("audit.proxys", "");
            HashSet proxySet = new HashSet();
            if (!StringUtils.isBlank((CharSequence)strIpPorts)) {
                String[] ipPorts = strIpPorts.split("\\s+");
                Collections.addAll(proxySet, ipPorts);
            }
            AuditOperator.getInstance().setAuditProxy(proxySet);
            String filePath = conf.get(AUDIT_KEY_FILE_PATH, AUDIT_DEFAULT_FILE_PATH);
            int maxCacheRow = conf.getInt(AUDIT_KEY_MAX_CACHE_ROWS, 2000000);
            AuditConfig auditConfig = new AuditConfig(filePath, maxCacheRow);
            AuditOperator.getInstance().setAuditConfig(auditConfig);
        }
    }

    public static void add(int auditID, String inlongGroupId, String inlongStreamId, long logTime, int count, long size) {
        if (!IS_AUDIT) {
            return;
        }
        AuditOperator.getInstance().add(auditID, inlongGroupId, inlongStreamId, Long.valueOf(logTime), (long)count, size);
    }

    public static void send() {
        if (!IS_AUDIT) {
            return;
        }
        AuditOperator.getInstance().send();
    }
}

