/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.db;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.TriggerProfile;
import org.apache.inlong.agent.db.Db;
import org.apache.inlong.agent.db.KeyValueEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerProfileDb {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerProfileDb.class);
    private final Db db;

    public TriggerProfileDb(Db db) {
        this.db = db;
    }

    public List<TriggerProfile> getTriggers() {
        List<KeyValueEntity> result = this.db.findAll("trigger_");
        ArrayList<TriggerProfile> triggerList = new ArrayList<TriggerProfile>();
        for (KeyValueEntity entity : result) {
            triggerList.add(entity.getAsTriggerProfile());
        }
        return triggerList;
    }

    public void storeTrigger(TriggerProfile trigger) {
        String keyName;
        KeyValueEntity entity;
        KeyValueEntity oldEntity;
        if (trigger.allRequiredKeyExist() && (oldEntity = this.db.put(entity = new KeyValueEntity(keyName = "trigger_" + trigger.get("job.id"), trigger.toJsonStr(), trigger.get("job.fileJob.dir.patterns")))) != null) {
            LOGGER.warn("trigger profile {} has been replaced", (Object)oldEntity.getKey());
        }
    }

    public void deleteTrigger(String id) {
        this.db.remove("trigger_" + id);
    }
}

