/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.db;

import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.conf.TriggerProfile;
import org.apache.inlong.agent.db.StateSearchKey;

public class KeyValueEntity {
    private String key;
    private StateSearchKey stateSearchKey;
    private String fileName;
    private String jsonValue;

    private KeyValueEntity() {
    }

    public KeyValueEntity(String key, String jsonValue, String fileName) {
        this.key = key;
        this.jsonValue = jsonValue;
        this.stateSearchKey = StateSearchKey.ACCEPTED;
        this.fileName = fileName;
    }

    public String getKey() {
        return this.key;
    }

    public String getFileName() {
        return this.fileName;
    }

    public StateSearchKey getStateSearchKey() {
        return this.stateSearchKey;
    }

    public KeyValueEntity setStateSearchKey(StateSearchKey stateSearchKey) {
        this.stateSearchKey = stateSearchKey;
        return this;
    }

    public String getJsonValue() {
        return this.jsonValue;
    }

    public KeyValueEntity setJsonValue(String jsonValue) {
        this.jsonValue = jsonValue;
        return this;
    }

    public JobProfile getAsJobProfile() {
        return JobProfile.parseJsonStr(this.getJsonValue());
    }

    public TriggerProfile getAsTriggerProfile() {
        return TriggerProfile.parseJsonStr(this.getJsonValue());
    }

    public boolean checkFinished() {
        return this.stateSearchKey.equals((Object)StateSearchKey.SUCCESS) || this.stateSearchKey.equals((Object)StateSearchKey.FAILED);
    }
}

