/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.db;

import java.util.List;
import org.apache.inlong.agent.conf.TriggerProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.db.Db;
import org.apache.inlong.common.db.CommandEntity;

public class CommandDb {
    private final Db db;

    public CommandDb(Db db) {
        this.db = db;
    }

    public void storeCommand(CommandEntity commandEntity) {
        this.db.putCommand(commandEntity);
    }

    public List<CommandEntity> getUnackedCommands() {
        return this.db.searchCommands(false);
    }

    public void saveNormalCmds(TriggerProfile profile, boolean success) {
        CommandEntity entity = new CommandEntity();
        entity.setId(CommandEntity.generateCommandId((String)profile.getTriggerId(), (int)profile.getOpType()));
        entity.setTaskId(Integer.valueOf(Integer.parseInt(profile.getTriggerId())));
        entity.setCommandResult(success ? 0 : 1);
        entity.setVersion(Integer.valueOf(profile.getInt("job.version", AgentConstants.DEFAULT_JOB_VERSION)));
        entity.setAcked(false);
        this.storeCommand(entity);
    }

    public void saveSpecialCmds(Integer id, Integer taskId, boolean success) {
        CommandEntity entity = new CommandEntity();
        entity.setId(String.valueOf(id));
        entity.setTaskId(taskId);
        entity.setAcked(false);
        entity.setCommandResult(success ? 0 : 1);
        this.storeCommand(entity);
    }
}

