/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.cache;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileCache.class);
    private final File file;
    private final long cacheTime;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public LocalFileCache(File file, long cacheTime) {
        this.file = file;
        this.cacheTime = cacheTime;
    }

    public String getCacheInfo() {
        this.lock.readLock().lock();
        String result = null;
        try {
            result = FileUtils.readFileToString((File)this.file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            LOGGER.error("exception on reading {}", (Object)this.file, (Object)ex);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public void writeToCache(String info) {
        this.lock.writeLock().lock();
        try {
            FileUtils.writeStringToFile((File)this.file, (String)info, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            LOGGER.error("exception on writing {}", (Object)this.file, (Object)ex);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean cacheIsExpired() {
        this.lock.readLock().lock();
        try {
            boolean bl = System.currentTimeMillis() - this.file.lastModified() > this.cacheTime;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

