/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.tubemq.corebase.cluster.MasterInfo;
import org.apache.inlong.tubemq.corebase.cluster.NodeAddrInfo;
import org.apache.inlong.tubemq.corerpc.AbstractServiceInvoker;
import org.apache.inlong.tubemq.corerpc.RequestWrapper;
import org.apache.inlong.tubemq.corerpc.ResponseWrapper;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.client.Callback;
import org.apache.inlong.tubemq.corerpc.client.Client;
import org.apache.inlong.tubemq.corerpc.client.ClientFactory;
import org.apache.inlong.tubemq.corerpc.codec.PbEnDecoder;
import org.apache.inlong.tubemq.corerpc.exception.StandbyException;
import org.apache.inlong.tubemq.corerpc.utils.MixUtils;

public class RpcServiceFailoverInvoker
extends AbstractServiceInvoker {
    private final AtomicInteger retryCounter = new AtomicInteger(0);
    private MasterInfo masterInfo;
    private Client currentClient;
    private int masterNodeCnt;

    public RpcServiceFailoverInvoker(ClientFactory clientFactory, Class serviceClass, RpcConfig conf, MasterInfo masterInfo) {
        super(clientFactory, serviceClass, conf);
        this.masterInfo = masterInfo;
        this.masterNodeCnt = masterInfo.getNodeHostPortList().size();
        this.getNextClient(false);
    }

    @Override
    public Object callMethod(String targetInterface, String method, Object arg, Callback callback) throws Throwable {
        if (this.currentClient == null || !this.currentClient.isReady()) {
            this.getNextClient(false);
        }
        int currentCounter = this.retryCounter.get();
        RequestWrapper requestWrapper = new RequestWrapper(PbEnDecoder.getServiceIdByServiceName(targetInterface), 3, 0, this.requestTimeout);
        requestWrapper.setMethodId(PbEnDecoder.getMethIdByName(method));
        requestWrapper.setRequestData(arg);
        Throwable t = null;
        for (int i = 0; i < this.masterNodeCnt; ++i) {
            if (this.currentClient != null) {
                try {
                    ResponseWrapper responseWrapper = this.currentClient.call(requestWrapper, callback, this.requestTimeout, TimeUnit.MILLISECONDS);
                    if (responseWrapper == null) break;
                    if (responseWrapper.isSuccess()) {
                        return responseWrapper.getResponseData();
                    }
                    Throwable remote = MixUtils.unwrapException(new StringBuilder(512).append(responseWrapper.getErrMsg()).append("#").append(responseWrapper.getStackTrace()).toString());
                    if (IOException.class.isAssignableFrom(remote.getClass()) || StandbyException.class.isAssignableFrom(remote.getClass())) {
                        if (currentCounter == this.retryCounter.get()) {
                            this.getNextClient(true);
                            ++currentCounter;
                        }
                        t = remote;
                        continue;
                    }
                    throw remote;
                }
                catch (Throwable e) {
                    if (currentCounter == this.retryCounter.get()) {
                        this.getNextClient(true);
                        ++currentCounter;
                    }
                    t = e;
                    continue;
                }
            }
            int index = (currentCounter & Integer.MAX_VALUE) % this.masterNodeCnt;
            t = new IOException(new StringBuilder(512).append("Connect server ").append(this.masterInfo.getNodeHostPortList().get(index)).append(" failure!").toString());
            if (currentCounter != this.retryCounter.get()) continue;
            this.getNextClient(false);
            ++currentCounter;
        }
        if (t != null) {
            throw t;
        }
        return null;
    }

    private synchronized Client getNextClient(boolean forceChange) {
        if (this.currentClient != null && (forceChange || !this.currentClient.isReady())) {
            this.currentClient.close();
            this.currentClient = null;
        }
        if (this.currentClient == null) {
            Client client = null;
            int retryTimes = this.masterNodeCnt;
            List<String> addressList = this.masterInfo.getNodeHostPortList();
            while (client == null || !client.isReady()) {
                String nodeKey = addressList.get((this.retryCounter.getAndIncrement() & Integer.MAX_VALUE) % this.masterNodeCnt);
                NodeAddrInfo nodeAddrInfo = this.masterInfo.getAddrMap4Failover().get(nodeKey);
                try {
                    client = this.clientFactory.getClient(nodeAddrInfo, this.conf);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (retryTimes-- != 0) continue;
                break;
            }
            if (client != null) {
                this.currentClient = client;
            }
            return client;
        }
        return this.currentClient;
    }
}

