/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.consume;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.audit.config.MessageQueueConfig;
import org.apache.inlong.audit.config.StoreConfig;
import org.apache.inlong.audit.service.InsertData;
import org.apache.inlong.audit.service.consume.BaseConsume;
import org.apache.inlong.audit.service.consume.KafkaConsume;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsume
extends BaseConsume {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConsume.class);
    private KafkaConsumer<String, byte[]> consumer;
    private String serverUrl;
    private String topic;

    public KafkaConsume(List<InsertData> insertServiceList, StoreConfig storeConfig, MessageQueueConfig mqConfig) {
        super(insertServiceList, storeConfig, mqConfig);
    }

    public void start() {
        this.serverUrl = this.mqConfig.getKafkaServerUrl();
        this.topic = this.mqConfig.getKafkaTopic();
        boolean isAutoCommit = Boolean.getBoolean(this.mqConfig.getEnableAutoCommit());
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.serverUrl), (Object)"no kafka server url specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.mqConfig.getKafkaTopic()), (Object)"no kafka topic topic specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.mqConfig.getKafkaConsumerName()), (Object)"no kafka consume name specified");
        this.initConsumer(this.mqConfig);
        Thread thread = new Thread((Runnable)new Fetcher(this, this.consumer, this.topic, isAutoCommit, this.mqConfig.getFetchWaitMs()), "KafkaConsume_Fetcher_Thread");
        thread.start();
    }

    protected void initConsumer(MessageQueueConfig mqConfig) {
        LOG.info("init kafka consumer, topic:{}, serverUrl:{}", (Object)this.topic, (Object)this.serverUrl);
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.serverUrl);
        properties.put("group.id", mqConfig.getKafkaGroupId());
        properties.put("enable.auto.commit", mqConfig.getEnableAutoCommit());
        properties.put("auto.commit.interval.ms", mqConfig.getAutoCommitIntervalMs());
        properties.put("auto.offset.reset", mqConfig.getAutoOffsetReset());
        properties.put("key.deserializer", StringDeserializer.class.getName());
        properties.put("value.deserializer", ByteArrayDeserializer.class.getName());
        this.consumer = new KafkaConsumer(properties);
        this.consumer.subscribe(Collections.singleton(this.topic));
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

