/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.audit.config.ClickHouseConfig;
import org.apache.inlong.audit.db.entities.ClickHouseDataPo;
import org.apache.inlong.audit.protocol.AuditData;
import org.apache.inlong.audit.service.InsertData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseService
implements InsertData,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ClickHouseService.class);
    public static final String INSERT_SQL = "insert into audit_data (ip, docker_id, thread_id,\r\n      sdk_ts, packet_id, log_ts,\r\n      inlong_group_id, inlong_stream_id, audit_id,\r\n      count, size, delay, \r\n      update_time)\r\n    values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private ClickHouseConfig chConfig;
    private ScheduledExecutorService timerService = Executors.newSingleThreadScheduledExecutor();
    private LinkedBlockingQueue<ClickHouseDataPo> batchQueue;
    private AtomicBoolean needBatchOutput = new AtomicBoolean(false);
    private AtomicInteger batchCounter = new AtomicInteger(0);
    private AtomicLong lastCheckTime = new AtomicLong(System.currentTimeMillis());
    private Connection conn;

    public ClickHouseService(ClickHouseConfig chConfig) {
        this.chConfig = chConfig;
    }

    public void start() {
        this.batchQueue = new LinkedBlockingQueue(this.chConfig.getBatchThreshold() * this.chConfig.getBatchIntervalMs() / this.chConfig.getProcessIntervalMs());
        try {
            Class.forName(this.chConfig.getDriver());
            this.reconnect();
        }
        catch (Exception e) {
            LOG.error("ClickHouseService start failure!", (Throwable)e);
        }
        this.timerService.scheduleWithFixedDelay(() -> this.processOutput(), this.chConfig.getProcessIntervalMs(), this.chConfig.getProcessIntervalMs(), TimeUnit.MILLISECONDS);
    }

    private void processOutput() {
        if (!this.needBatchOutput.get() && System.currentTimeMillis() - this.lastCheckTime.get() < (long)this.chConfig.getBatchIntervalMs()) {
            return;
        }
        try (PreparedStatement pstat = this.conn.prepareStatement(INSERT_SQL);){
            int counter = 0;
            ClickHouseDataPo data = (ClickHouseDataPo)this.batchQueue.poll();
            while (data != null) {
                pstat.setString(1, data.getIp());
                pstat.setString(2, data.getDockerId());
                pstat.setString(3, data.getThreadId());
                pstat.setTimestamp(4, data.getSdkTs());
                pstat.setLong(5, data.getPacketId());
                pstat.setTimestamp(6, data.getLogTs());
                pstat.setString(7, data.getInlongGroupId());
                pstat.setString(8, data.getInlongStreamId());
                pstat.setString(9, data.getAuditId());
                pstat.setLong(10, data.getCount());
                pstat.setLong(11, data.getSize());
                pstat.setLong(12, data.getDelay());
                pstat.setTimestamp(13, data.getUpdateTime());
                pstat.addBatch();
                this.batchCounter.decrementAndGet();
                if (++counter >= this.chConfig.getBatchThreshold()) {
                    pstat.executeBatch();
                    this.conn.commit();
                    counter = 0;
                }
                data = (ClickHouseDataPo)this.batchQueue.poll();
            }
            if (counter > 0) {
                pstat.executeBatch();
                this.conn.commit();
            }
        }
        catch (Exception e1) {
            LOG.error("Execute output to clickhouse failure!", (Throwable)e1);
            try {
                this.reconnect();
            }
            catch (SQLException e2) {
                LOG.error("Re-connect clickhouse failure!", (Throwable)e2);
            }
        }
        this.lastCheckTime.set(System.currentTimeMillis());
        this.needBatchOutput.compareAndSet(true, false);
    }

    private void reconnect() throws SQLException {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            this.conn = null;
        }
        this.conn = DriverManager.getConnection(this.chConfig.getUrl(), this.chConfig.getUsername(), this.chConfig.getPassword());
        this.conn.setAutoCommit(false);
    }

    public void insert(AuditData msgBody) {
        ClickHouseDataPo data = new ClickHouseDataPo();
        data.setIp(msgBody.getIp());
        data.setThreadId(msgBody.getThreadId());
        data.setDockerId(msgBody.getDockerId());
        data.setPacketId(Long.valueOf(msgBody.getPacketId()));
        data.setSdkTs(new Timestamp(msgBody.getSdkTs()));
        data.setLogTs(new Timestamp(msgBody.getLogTs()));
        data.setAuditId(msgBody.getAuditId());
        data.setCount(Long.valueOf(msgBody.getCount()));
        data.setDelay(Long.valueOf(msgBody.getDelay()));
        data.setInlongGroupId(msgBody.getInlongGroupId());
        data.setInlongStreamId(msgBody.getInlongStreamId());
        data.setSize(Long.valueOf(msgBody.getSize()));
        data.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        try {
            this.batchQueue.offer(data, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            if (this.batchCounter.incrementAndGet() >= this.chConfig.getBatchThreshold()) {
                this.needBatchOutput.compareAndSet(false, true);
            }
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws Exception {
        this.conn.close();
        this.timerService.shutdown();
    }
}

